/*
 * Decompiled with CFR 0.152.
 */
package org.onlab.packet;

import com.google.common.collect.ImmutableList;
import java.nio.ByteBuffer;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.onlab.packet.DHCP6;
import org.onlab.packet.DHCP6Option;
import org.onlab.packet.Deserializer;
import org.onlab.packet.Ip6Address;
import org.onlab.packet.PacketTestUtils;

public class Dhcp6Test {
    private static final int OPT_CLIENT_ID = -1091584273;
    private static final byte[] OPT_CLIENT_ID_BYTE_ARR = new byte[]{-66, -17, -66, -17};
    private static final short OPT_CLIENT_ID_SIZE = 4;
    private static final int OPT_AUTH = -1173243375;
    private static final byte[] OPT_AUTH_BYTE_AR = new byte[]{-70, 17, -70, 17};
    private static final short OPT_AUTH_SIZE = 4;
    private static final int TRANSACTION_ID = 12648430;
    private static final byte[] TRANSACTION_ID_BYTE_ARR = new byte[]{-64, -1, -18};
    private static final byte HOP_COUNT = 3;
    private static final Ip6Address LINK_ADDRESS = Ip6Address.valueOf((String)"1111:2222::8888");
    private static final Ip6Address PEER_ADDRESS = Ip6Address.valueOf((String)"3333:4444::9999");
    Deserializer<DHCP6> deserializer = DHCP6.deserializer();
    private byte[] byteHeader;

    @Test
    public void testDeserializeBadInput() throws Exception {
        PacketTestUtils.testDeserializeBadInput(this.deserializer);
    }

    @Test
    public void testDeserializeTruncated() throws Exception {
        ByteBuffer bb = ByteBuffer.allocate(4);
        bb.put(DHCP6.MsgType.REQUEST.value());
        bb.put(TRANSACTION_ID_BYTE_ARR);
        this.byteHeader = bb.array();
        PacketTestUtils.testDeserializeTruncated(this.deserializer, this.byteHeader);
    }

    @Test
    public void testDeserializeDefaultPayload() throws Exception {
        ByteBuffer bb = ByteBuffer.allocate(12);
        bb.put(DHCP6.MsgType.REQUEST.value());
        bb.put(TRANSACTION_ID_BYTE_ARR);
        bb.putShort(DHCP6.OptionCode.CLIENTID.value());
        bb.putShort((short)4);
        bb.putInt(-1091584273);
        this.byteHeader = bb.array();
        DHCP6 dhcp6 = (DHCP6)this.deserializer.deserialize(this.byteHeader, 0, this.byteHeader.length);
        Assert.assertEquals((long)dhcp6.getMsgType(), (long)DHCP6.MsgType.REQUEST.value());
        Assert.assertEquals((long)dhcp6.getTransactionId(), (long)12648430L);
        Assert.assertEquals((long)dhcp6.getOptions().size(), (long)1L);
        DHCP6Option clientIdOption = (DHCP6Option)dhcp6.getOptions().get(0);
        Assert.assertEquals((long)clientIdOption.getCode(), (long)DHCP6.OptionCode.CLIENTID.value());
        Assert.assertArrayEquals((byte[])clientIdOption.getData(), (byte[])OPT_CLIENT_ID_BYTE_ARR);
    }

    @Test
    public void testDeserializeRelayAgent() throws Exception {
        ByteBuffer bb = ByteBuffer.allocate(42);
        bb.put(DHCP6.MsgType.RELAY_FORW.value());
        bb.put((byte)3);
        bb.put(LINK_ADDRESS.toOctets());
        bb.put(PEER_ADDRESS.toOctets());
        bb.putShort(DHCP6.OptionCode.CLIENTID.value());
        bb.putShort((short)4);
        bb.putInt(-1091584273);
        this.byteHeader = bb.array();
        DHCP6 dhcp6 = (DHCP6)this.deserializer.deserialize(this.byteHeader, 0, this.byteHeader.length);
        Assert.assertEquals((long)dhcp6.getMsgType(), (long)DHCP6.MsgType.RELAY_FORW.value());
        Assert.assertEquals((long)dhcp6.getHopCount(), (long)3L);
        Assert.assertArrayEquals((byte[])dhcp6.getLinkAddress(), (byte[])LINK_ADDRESS.toOctets());
        Assert.assertArrayEquals((byte[])dhcp6.getPeerAddress(), (byte[])PEER_ADDRESS.toOctets());
        Assert.assertEquals((long)dhcp6.getOptions().size(), (long)1L);
        DHCP6Option clientIdOption = (DHCP6Option)dhcp6.getOptions().get(0);
        Assert.assertEquals((long)clientIdOption.getCode(), (long)DHCP6.OptionCode.CLIENTID.value());
        Assert.assertArrayEquals((byte[])clientIdOption.getData(), (byte[])OPT_CLIENT_ID_BYTE_ARR);
    }

    @Test
    public void testSerializeDefaultPayload() throws Exception {
        DHCP6 dhcp6 = new DHCP6();
        dhcp6.setMsgType(DHCP6.MsgType.REQUEST.value());
        dhcp6.setTransactionId(12648430);
        DHCP6Option opt1 = new DHCP6Option();
        opt1.setCode(DHCP6.OptionCode.CLIENTID.value());
        opt1.setLength((short)4);
        opt1.setData(OPT_CLIENT_ID_BYTE_ARR);
        DHCP6Option opt2 = new DHCP6Option();
        opt2.setCode(DHCP6.OptionCode.AUTH.value());
        opt2.setLength((short)4);
        opt2.setData(OPT_AUTH_BYTE_AR);
        dhcp6.setOptions((List)ImmutableList.of((Object)opt1, (Object)opt2));
        byte[] serialized = dhcp6.serialize();
        ByteBuffer expected = ByteBuffer.allocate(20).put(DHCP6.MsgType.REQUEST.value()).put(TRANSACTION_ID_BYTE_ARR).putShort(DHCP6.OptionCode.CLIENTID.value()).putShort((short)4).putInt(-1091584273).putShort(DHCP6.OptionCode.AUTH.value()).putShort((short)4).putInt(-1173243375);
        Assert.assertArrayEquals((byte[])serialized, (byte[])expected.array());
    }

    @Test
    public void testSerializeRelayAgent() throws Exception {
        DHCP6 dhcp6 = new DHCP6();
        dhcp6.setMsgType(DHCP6.MsgType.RELAY_FORW.value());
        dhcp6.setHopCount((byte)3);
        dhcp6.setLinkAddress(LINK_ADDRESS.toOctets());
        dhcp6.setPeerAddress(PEER_ADDRESS.toOctets());
        DHCP6Option opt1 = new DHCP6Option();
        opt1.setCode(DHCP6.OptionCode.CLIENTID.value());
        opt1.setLength((short)4);
        opt1.setData(OPT_CLIENT_ID_BYTE_ARR);
        DHCP6Option opt2 = new DHCP6Option();
        opt2.setCode(DHCP6.OptionCode.AUTH.value());
        opt2.setLength((short)4);
        opt2.setData(OPT_AUTH_BYTE_AR);
        dhcp6.setOptions((List)ImmutableList.of((Object)opt1, (Object)opt2));
        byte[] serialized = dhcp6.serialize();
        ByteBuffer expected = ByteBuffer.allocate(50).put(DHCP6.MsgType.RELAY_FORW.value()).put((byte)3).put(LINK_ADDRESS.toOctets()).put(PEER_ADDRESS.toOctets()).putShort(DHCP6.OptionCode.CLIENTID.value()).putShort((short)4).putInt(-1091584273).putShort(DHCP6.OptionCode.AUTH.value()).putShort((short)4).putInt(-1173243375);
        Assert.assertArrayEquals((byte[])serialized, (byte[])expected.array());
    }
}

