/*
 * Decompiled with CFR 0.152.
 */
package org.onlab.util;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.onlab.util.ExtendedSet;

public class ExtendedSetTest {
    @Test
    public void testGet() {
        ExtendedSet set = new ExtendedSet((Map)Maps.newConcurrentMap());
        TestValue e1 = new TestValue("foo", 1);
        set.add((Object)e1);
        TestValue lookupValue = new TestValue("foo", 2);
        TestValue setEntry = (TestValue)set.get((Object)lookupValue);
        Assert.assertEquals((Object)e1, (Object)setEntry);
    }

    @Test
    public void testInsertOrReplace() {
        ExtendedSet set = new ExtendedSet((Map)Maps.newConcurrentMap());
        TestValue small = new TestValue("foo", 1);
        TestValue medium = new TestValue("foo", 2);
        TestValue large = new TestValue("foo", 3);
        Assert.assertTrue((boolean)set.insertOrReplace((Object)small, existing -> existing.value2() < small.value2()));
        Assert.assertTrue((boolean)set.insertOrReplace((Object)large, existing -> existing.value2() < large.value2()));
        Assert.assertFalse((boolean)set.insertOrReplace((Object)medium, existing -> existing.value2() < medium.value2()));
        Assert.assertTrue((boolean)set.contains((Object)small));
        Assert.assertTrue((boolean)set.contains((Object)medium));
        Assert.assertTrue((boolean)set.contains((Object)large));
    }

    @Test
    public void testConditionalRemove() {
        ExtendedSet set = new ExtendedSet((Map)Maps.newConcurrentMap());
        TestValue small = new TestValue("foo", 1);
        TestValue medium = new TestValue("foo", 2);
        Assert.assertTrue((boolean)set.add((Object)small));
        set.conditionalRemove((Object)medium, existing -> existing.value2() < medium.value2);
        Assert.assertFalse((boolean)set.contains((Object)small));
        Assert.assertTrue((boolean)set.add((Object)small));
        set.conditionalRemove((Object)medium, existing -> existing.value2() > medium.value2);
        Assert.assertTrue((boolean)set.contains((Object)small));
    }

    @Test
    public void testIsEmpty() {
        ExtendedSet nonemptyset = new ExtendedSet((Map)Maps.newConcurrentMap());
        TestValue val = new TestValue("foo", 1);
        Assert.assertTrue((boolean)nonemptyset.insertOrReplace((Object)val, existing -> existing.value2() < val.value2()));
        Assert.assertTrue((boolean)nonemptyset.contains((Object)val));
        Assert.assertFalse((boolean)nonemptyset.isEmpty());
        ExtendedSet emptyset = new ExtendedSet((Map)Maps.newConcurrentMap());
        Assert.assertTrue((boolean)emptyset.isEmpty());
    }

    @Test
    public void testClear() {
        ExtendedSet set = new ExtendedSet((Map)Maps.newConcurrentMap());
        TestValue val = new TestValue("foo", 1);
        Assert.assertTrue((boolean)set.insertOrReplace((Object)val, existing -> existing.value2() < val.value2()));
        Assert.assertTrue((boolean)set.contains((Object)val));
        set.clear();
        Assert.assertFalse((boolean)set.contains((Object)val));
    }

    @Test
    public void testSize() {
        ExtendedSet nonemptyset = new ExtendedSet((Map)Maps.newConcurrentMap());
        TestValue val = new TestValue("foo", 1);
        Assert.assertTrue((boolean)nonemptyset.insertOrReplace((Object)val, existing -> existing.value2() < val.value2()));
        Assert.assertTrue((boolean)nonemptyset.contains((Object)val));
        Assert.assertEquals((long)1L, (long)nonemptyset.size());
        TestValue secval = new TestValue("goo", 2);
        Assert.assertTrue((boolean)nonemptyset.insertOrReplace((Object)secval, existing -> existing.value2() < secval.value2()));
        Assert.assertTrue((boolean)nonemptyset.contains((Object)secval));
        Assert.assertEquals((long)2L, (long)nonemptyset.size());
        ExtendedSet emptyset = new ExtendedSet((Map)Maps.newConcurrentMap());
        Assert.assertEquals((long)0L, (long)emptyset.size());
    }

    @Test
    public void testIterator() {
        ExtendedSet set = new ExtendedSet((Map)Maps.newConcurrentMap());
        TestValue val = new TestValue("foo", 1);
        Assert.assertTrue((boolean)set.insertOrReplace((Object)val, existing -> existing.value2() < val.value2()));
        TestValue nextval = new TestValue("goo", 2);
        Assert.assertTrue((boolean)set.insertOrReplace((Object)nextval, existing -> existing.value2() < nextval.value2()));
        Assert.assertTrue((boolean)set.contains((Object)nextval));
        Iterator iterator = set.iterator();
        Assert.assertEquals((Object)val, iterator.next());
        Assert.assertTrue((boolean)iterator.hasNext());
        Assert.assertEquals((Object)nextval, iterator.next());
    }

    @Test
    public void testToArray() {
        ExtendedSet set = new ExtendedSet((Map)Maps.newConcurrentMap());
        TestValue val = new TestValue("foo", 1);
        Assert.assertTrue((boolean)set.insertOrReplace((Object)val, existing -> existing.value2() < val.value2()));
        TestValue nextval = new TestValue("goo", 2);
        Assert.assertTrue((boolean)set.insertOrReplace((Object)nextval, existing -> existing.value2() < nextval.value2()));
        Object[] array = set.toArray();
        Object[] valarray = new TestValue[]{val, nextval};
        Assert.assertArrayEquals((Object[])valarray, (Object[])array);
        Assert.assertTrue((boolean)(((TestValue[])set.toArray((Object[])new TestValue[0]))[0] instanceof TestValue));
    }

    @Test
    public void testContainsAll() {
        ExtendedSet set = new ExtendedSet((Map)Maps.newConcurrentMap());
        TestValue val = new TestValue("foo", 1);
        Assert.assertTrue((boolean)set.insertOrReplace((Object)val, existing -> existing.value2() < val.value2()));
        TestValue nextval = new TestValue("goo", 2);
        Assert.assertTrue((boolean)set.insertOrReplace((Object)nextval, existing -> existing.value2() < nextval.value2()));
        ArrayList<TestValue> vals = new ArrayList<TestValue>();
        vals.add(val);
        vals.add(nextval);
        Assert.assertTrue((boolean)set.containsAll(vals));
    }

    @Test
    public void testRemove() {
        ExtendedSet set = new ExtendedSet((Map)Maps.newConcurrentMap());
        TestValue val = new TestValue("foo", 1);
        Assert.assertTrue((boolean)set.insertOrReplace((Object)val, existing -> existing.value2() < val.value2()));
        TestValue nextval = new TestValue("goo", 2);
        Assert.assertTrue((boolean)set.insertOrReplace((Object)nextval, existing -> existing.value2() < nextval.value2()));
        Assert.assertTrue((boolean)set.remove((Object)val));
        Assert.assertFalse((boolean)set.contains((Object)val));
        Assert.assertTrue((boolean)set.remove((Object)nextval));
        Assert.assertFalse((boolean)set.contains((Object)nextval));
    }

    @Test
    public void testAddAll() {
        ExtendedSet nonemptyset = new ExtendedSet((Map)Maps.newConcurrentMap());
        TestValue val = new TestValue("foo", 1);
        Assert.assertTrue((boolean)nonemptyset.insertOrReplace((Object)val, existing -> existing.value2() < val.value2()));
        TestValue nextval = new TestValue("goo", 2);
        TestValue finalval = new TestValue("shoo", 3);
        ArrayList<TestValue> vals = new ArrayList<TestValue>();
        vals.add(nextval);
        vals.add(finalval);
        Assert.assertTrue((boolean)nonemptyset.addAll(vals));
        Assert.assertTrue((boolean)nonemptyset.contains((Object)nextval));
        Assert.assertTrue((boolean)nonemptyset.contains((Object)finalval));
        ExtendedSet emptyset = new ExtendedSet((Map)Maps.newConcurrentMap());
        vals = new ArrayList();
        vals.add(val);
        vals.add(nextval);
        vals.add(finalval);
        Assert.assertTrue((boolean)emptyset.addAll(vals));
        Assert.assertTrue((boolean)emptyset.contains((Object)val));
        Assert.assertTrue((boolean)emptyset.contains((Object)nextval));
        Assert.assertTrue((boolean)emptyset.contains((Object)finalval));
    }

    @Test
    public void testRemoveAll() {
        ExtendedSet set = new ExtendedSet((Map)Maps.newConcurrentMap());
        TestValue val = new TestValue("foo", 1);
        Assert.assertTrue((boolean)set.insertOrReplace((Object)val, existing -> existing.value2() < val.value2()));
        TestValue nextval = new TestValue("goo", 2);
        Assert.assertTrue((boolean)set.insertOrReplace((Object)nextval, existing -> existing.value2() < nextval.value2()));
        TestValue finalval = new TestValue("shoo", 3);
        Assert.assertTrue((boolean)set.insertOrReplace((Object)finalval, existing -> existing.value2() < finalval.value2()));
        ArrayList<TestValue> vals = new ArrayList<TestValue>();
        vals.add(nextval);
        vals.add(finalval);
        Assert.assertTrue((boolean)set.removeAll(vals));
        Assert.assertFalse((boolean)set.contains((Object)nextval));
        Assert.assertFalse((boolean)set.contains((Object)finalval));
    }

    @Test
    @Ignore(value="retainAll appears to violate the documented semantics because it does not properly remove the items that are not in the Collection parameter.")
    public void testRetainAll() {
        ExtendedSet set = new ExtendedSet((Map)Maps.newConcurrentMap());
        TestValue small = new TestValue("foo", 1);
        Assert.assertTrue((boolean)set.insertOrReplace((Object)small, existing -> existing.value2() < small.value2()));
        TestValue medium = new TestValue("goo", 2);
        Assert.assertTrue((boolean)set.insertOrReplace((Object)medium, existing -> existing.value2() < medium.value2()));
        TestValue large = new TestValue("shoo", 3);
        Assert.assertTrue((boolean)set.insertOrReplace((Object)large, existing -> existing.value2() < large.value2()));
        TestValue extreme = new TestValue("who", 4);
        Assert.assertTrue((boolean)set.insertOrReplace((Object)extreme, existing -> existing.value2() < extreme.value2()));
        ArrayList<TestValue> firstvals = new ArrayList<TestValue>();
        firstvals.add(medium);
        firstvals.add(extreme);
        set.retainAll(firstvals);
        Assert.assertTrue((boolean)set.contains((Object)medium));
        Assert.assertTrue((boolean)set.contains((Object)extreme));
        Assert.assertFalse((boolean)set.contains((Object)small));
        Assert.assertFalse((boolean)set.contains((Object)large));
        ArrayList<TestValue> secondval = new ArrayList<TestValue>();
        secondval.add(medium);
        set.retainAll(secondval);
        Assert.assertFalse((boolean)set.contains((Object)extreme));
        Assert.assertTrue((boolean)set.contains((Object)medium));
    }

    private class TestValue {
        private String value1;
        private int value2;

        public TestValue(String v1, int v2) {
            this.value1 = v1;
            this.value2 = v2;
        }

        public String value1() {
            return this.value1;
        }

        public int value2() {
            return this.value2;
        }

        public boolean equals(Object other) {
            if (other instanceof TestValue) {
                TestValue that = (TestValue)other;
                return Objects.equals(this.value1, that.value1);
            }
            return false;
        }

        public int hashCode() {
            return Objects.hash(this.value1);
        }
    }
}

