/*
 * Decompiled with CFR 0.152.
 */
package org.onlab.packet;

import com.google.common.base.Charsets;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.commons.lang3.StringUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.onlab.packet.DHCP;
import org.onlab.packet.Deserializer;
import org.onlab.packet.Ip4Address;
import org.onlab.packet.MacAddress;
import org.onlab.packet.PacketTestUtils;
import org.onlab.packet.dhcp.DhcpOption;

public class DhcpTest {
    private static final int TRANSACTION_ID = 1000;
    private static final MacAddress CLIENT1_HOST_MAC = MacAddress.valueOf((String)"1a:1a:1a:1a:1a:1a");
    private static final Ip4Address REQ_IP = Ip4Address.valueOf((String)"10.2.0.2");
    private static final byte[] EXPECTED_SERIALIZED = ByteBuffer.allocate(300).put((byte)1).put((byte)1).put((byte)6).put((byte)0).putInt(1000).putShort((short)0).putShort((short)0).putInt(0).putInt(0).putInt(0).putInt(0).put(CLIENT1_HOST_MAC.toBytes()).put(new byte[10]).put(new byte[64]).put(new byte[128]).putInt(1669485411).put(new byte[]{53, 1, 3}).put(new byte[]{50, 4, 10, 2, 0, 2}).put((byte)-1).put(new byte[50]).array();
    private Deserializer<DHCP> deserializer = DHCP.deserializer();
    private byte opCode = 1;
    private byte hardwareType = 1;
    private byte hardwareAddressLength = (byte)6;
    private byte hops = 0;
    private int transactionId = 785705808;
    private short seconds = 0;
    private short flags = 0;
    private int clientIpAddress = 1;
    private int yourIpAddress = 2;
    private int serverIpAddress = 3;
    private int gatewayIpAddress = 4;
    private byte[] clientHardwareAddress = MacAddress.valueOf((long)500L).toBytes();
    private String serverName = "test-server";
    private String bootFileName = "test-file";
    private String hostName = "test-host";
    private DhcpOption hostNameOption = new DhcpOption();
    private byte[] byteHeader;

    @Before
    public void setUp() {
        this.hostNameOption.setCode((byte)55);
        this.hostNameOption.setLength((byte)this.hostName.length());
        this.hostNameOption.setData(this.hostName.getBytes(Charsets.US_ASCII));
        ByteBuffer bb = ByteBuffer.allocate(242 + this.hostNameOption.getLength() + 1);
        bb.put(this.opCode);
        bb.put(this.hardwareType);
        bb.put(this.hardwareAddressLength);
        bb.put(this.hops);
        bb.putInt(this.transactionId);
        bb.putShort(this.seconds);
        bb.putShort(this.flags);
        bb.putInt(this.clientIpAddress);
        bb.putInt(this.yourIpAddress);
        bb.putInt(this.serverIpAddress);
        bb.putInt(this.gatewayIpAddress);
        bb.put(this.clientHardwareAddress);
        bb.put(new byte[16 - this.hardwareAddressLength]);
        bb.put(this.serverName.getBytes(Charsets.US_ASCII));
        bb.put(new byte[64 - this.serverName.length()]);
        bb.put(this.bootFileName.getBytes(Charsets.US_ASCII));
        bb.put(new byte[128 - this.bootFileName.length()]);
        bb.put("DHCP".getBytes(Charsets.US_ASCII));
        bb.put(this.hostNameOption.getCode());
        bb.put(this.hostNameOption.getLength());
        bb.put(this.hostNameOption.getData());
        bb.put(DHCP.DHCPOptionCode.OptionCode_END.getValue());
        this.byteHeader = bb.array();
    }

    @Test
    public void testDeserializeBadInput() throws Exception {
        PacketTestUtils.testDeserializeBadInput(this.deserializer);
    }

    @Test
    public void testDeserializeTruncated() throws Exception {
        PacketTestUtils.testDeserializeTruncated(this.deserializer, this.byteHeader);
    }

    @Test
    public void testDeserialize() throws Exception {
        DHCP dhcp = (DHCP)this.deserializer.deserialize(this.byteHeader, 0, this.byteHeader.length);
        Assert.assertEquals((long)this.opCode, (long)dhcp.opCode);
        Assert.assertEquals((long)this.hardwareType, (long)dhcp.hardwareType);
        Assert.assertEquals((long)this.hardwareAddressLength, (long)dhcp.hardwareAddressLength);
        Assert.assertEquals((long)this.hops, (long)dhcp.hops);
        Assert.assertEquals((long)this.transactionId, (long)dhcp.transactionId);
        Assert.assertEquals((long)this.seconds, (long)dhcp.seconds);
        Assert.assertEquals((long)this.flags, (long)dhcp.flags);
        Assert.assertEquals((long)this.clientIpAddress, (long)dhcp.clientIPAddress);
        Assert.assertEquals((long)this.yourIpAddress, (long)dhcp.yourIPAddress);
        Assert.assertEquals((long)this.serverIpAddress, (long)dhcp.serverIPAddress);
        Assert.assertEquals((long)this.gatewayIpAddress, (long)dhcp.gatewayIPAddress);
        Assert.assertTrue((boolean)Arrays.equals(this.clientHardwareAddress, dhcp.clientHardwareAddress));
        Assert.assertEquals((Object)this.serverName, (Object)dhcp.serverName);
        Assert.assertEquals((Object)this.bootFileName, (Object)dhcp.bootFileName);
        Assert.assertEquals((long)2L, (long)dhcp.options.size());
        Assert.assertEquals((Object)this.hostNameOption, dhcp.options.get(0));
    }

    @Test
    public void testToStringDhcp() throws Exception {
        DHCP dhcp = (DHCP)this.deserializer.deserialize(this.byteHeader, 0, this.byteHeader.length);
        String str = dhcp.toString();
        Assert.assertTrue((boolean)StringUtils.contains((CharSequence)str, (CharSequence)("opCode=" + this.opCode)));
        Assert.assertTrue((boolean)StringUtils.contains((CharSequence)str, (CharSequence)("hardwareType=" + this.hardwareType)));
        Assert.assertTrue((boolean)StringUtils.contains((CharSequence)str, (CharSequence)("hardwareAddressLength=" + this.hardwareAddressLength)));
        Assert.assertTrue((boolean)StringUtils.contains((CharSequence)str, (CharSequence)("hops=" + this.hops)));
        Assert.assertTrue((boolean)StringUtils.contains((CharSequence)str, (CharSequence)("transactionId=" + this.transactionId)));
        Assert.assertTrue((boolean)StringUtils.contains((CharSequence)str, (CharSequence)("seconds=" + this.seconds)));
        Assert.assertTrue((boolean)StringUtils.contains((CharSequence)str, (CharSequence)("flags=" + this.flags)));
        Assert.assertTrue((boolean)StringUtils.contains((CharSequence)str, (CharSequence)("clientIPAddress=" + this.clientIpAddress)));
        Assert.assertTrue((boolean)StringUtils.contains((CharSequence)str, (CharSequence)("yourIPAddress=" + this.yourIpAddress)));
        Assert.assertTrue((boolean)StringUtils.contains((CharSequence)str, (CharSequence)("serverIPAddress=" + this.serverIpAddress)));
        Assert.assertTrue((boolean)StringUtils.contains((CharSequence)str, (CharSequence)("gatewayIPAddress=" + this.gatewayIpAddress)));
        Assert.assertTrue((boolean)StringUtils.contains((CharSequence)str, (CharSequence)("clientHardwareAddress=" + Arrays.toString(this.clientHardwareAddress))));
        Assert.assertTrue((boolean)StringUtils.contains((CharSequence)str, (CharSequence)("serverName=" + this.serverName)));
        Assert.assertTrue((boolean)StringUtils.contains((CharSequence)str, (CharSequence)("bootFileName=" + this.bootFileName)));
    }

    @Test
    public void testSerialize() throws Exception {
        DHCP dhcpReply = new DHCP();
        dhcpReply.setOpCode((byte)1);
        dhcpReply.setYourIPAddress(0);
        dhcpReply.setServerIPAddress(0);
        dhcpReply.setTransactionId(1000);
        dhcpReply.setClientHardwareAddress(CLIENT1_HOST_MAC.toBytes());
        dhcpReply.setHardwareType((byte)1);
        dhcpReply.setHardwareAddressLength((byte)6);
        DhcpOption option = new DhcpOption();
        ArrayList<DhcpOption> optionList = new ArrayList<DhcpOption>();
        option.setCode(DHCP.DHCPOptionCode.OptionCode_MessageType.getValue());
        option.setLength((byte)1);
        byte[] optionData = new byte[]{(byte)DHCP.MsgType.DHCPREQUEST.getValue()};
        option.setData(optionData);
        optionList.add(option);
        option = new DhcpOption();
        option.setCode(DHCP.DHCPOptionCode.OptionCode_RequestedIP.getValue());
        option.setLength((byte)4);
        optionData = REQ_IP.toOctets();
        option.setData(optionData);
        optionList.add(option);
        option = new DhcpOption();
        option.setCode(DHCP.DHCPOptionCode.OptionCode_END.getValue());
        option.setLength((byte)1);
        optionList.add(option);
        dhcpReply.setOptions(optionList);
        Assert.assertArrayEquals((byte[])EXPECTED_SERIALIZED, (byte[])dhcpReply.serialize());
    }
}

