/*
 * Decompiled with CFR 0.152.
 */
package org.onlab.packet.ndp;

import java.nio.ByteBuffer;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.onlab.packet.Deserializer;
import org.onlab.packet.MacAddress;
import org.onlab.packet.PacketTestUtils;
import org.onlab.packet.ndp.NeighborDiscoveryOptions;
import org.onlab.packet.ndp.RouterSolicitation;

public class RouterSolicitationTest {
    private static final MacAddress MAC_ADDRESS1 = MacAddress.valueOf((String)"11:22:33:44:55:66");
    private static final MacAddress MAC_ADDRESS2 = MacAddress.valueOf((String)"11:22:33:44:55:00");
    private static byte[] bytePacket;
    private Deserializer<RouterSolicitation> deserializer = RouterSolicitation.deserializer();

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        byte[] byteHeader = new byte[]{0, 0, 0, 0, 2, 1, 17, 34, 51, 68, 85, 102};
        bytePacket = new byte[byteHeader.length];
        System.arraycopy(byteHeader, 0, bytePacket, 0, byteHeader.length);
    }

    @Test
    public void testSerialize() {
        RouterSolicitation rs = new RouterSolicitation();
        rs.addOption((byte)2, MAC_ADDRESS1.toBytes());
        Assert.assertArrayEquals((byte[])rs.serialize(), (byte[])bytePacket);
    }

    @Test
    public void testDeserializeBadInput() throws Exception {
        PacketTestUtils.testDeserializeBadInput(RouterSolicitation.deserializer());
    }

    @Test
    public void testDeserializeTruncated() throws Exception {
        byte[] rsHeader = new byte[4];
        ByteBuffer.wrap(bytePacket).get(rsHeader);
        PacketTestUtils.testDeserializeTruncated(RouterSolicitation.deserializer(), rsHeader);
    }

    @Test
    public void testDeserialize() throws Exception {
        RouterSolicitation rs = (RouterSolicitation)this.deserializer.deserialize(bytePacket, 0, bytePacket.length);
        Assert.assertThat((Object)rs.getOptions().size(), (Matcher)Matchers.is((Object)1));
        NeighborDiscoveryOptions.Option option = (NeighborDiscoveryOptions.Option)rs.getOptions().get(0);
        Assert.assertThat((Object)option.type(), (Matcher)Matchers.is((Object)2));
        Assert.assertArrayEquals((byte[])option.data(), (byte[])MAC_ADDRESS1.toBytes());
    }

    @Test
    public void testEqual() {
        RouterSolicitation rs1 = new RouterSolicitation();
        rs1.addOption((byte)2, MAC_ADDRESS1.toBytes());
        RouterSolicitation rs2 = new RouterSolicitation();
        rs2.addOption((byte)2, MAC_ADDRESS2.toBytes());
        Assert.assertTrue((boolean)rs1.equals((Object)rs1));
        Assert.assertFalse((boolean)rs1.equals((Object)rs2));
    }

    @Test
    public void testToStringRS() throws Exception {
        RouterSolicitation rs = (RouterSolicitation)this.deserializer.deserialize(bytePacket, 0, bytePacket.length);
        String str = rs.toString();
    }
}

