/*
 * Decompiled with CFR 0.152.
 */
package org.onlab.graph;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.onlab.graph.DefaultPath;
import org.onlab.graph.Edge;
import org.onlab.graph.MutablePath;
import org.onlab.graph.Path;
import org.onlab.graph.Vertex;
import org.onlab.graph.Weight;

public class DefaultMutablePath<V extends Vertex, E extends Edge<V>>
implements MutablePath<V, E> {
    private final List<E> edges = new ArrayList();
    private Weight cost;

    public DefaultMutablePath() {
    }

    public DefaultMutablePath(Path<V, E> path) {
        Preconditions.checkNotNull(path, (Object)"Path cannot be null");
        this.cost = path.cost();
        this.edges.addAll(path.edges());
    }

    @Override
    public V src() {
        return this.edges.isEmpty() ? null : (V)((Edge)this.edges.get(0)).src();
    }

    @Override
    public V dst() {
        return this.edges.isEmpty() ? null : (V)((Edge)this.edges.get(this.edges.size() - 1)).dst();
    }

    @Override
    public Weight cost() {
        return this.cost;
    }

    @Override
    public List<E> edges() {
        return ImmutableList.copyOf(this.edges);
    }

    @Override
    public void setCost(Weight cost) {
        this.cost = cost;
    }

    @Override
    public Path<V, E> toImmutable() {
        return new DefaultPath(this.edges, this.cost);
    }

    @Override
    public void insertEdge(E edge) {
        Preconditions.checkNotNull(edge, (Object)"Edge cannot be null");
        Preconditions.checkArgument((this.edges.isEmpty() || this.src().equals(edge.dst()) ? 1 : 0) != 0, (Object)"Edge destination must be the same as the current path source");
        this.edges.add(0, edge);
    }

    @Override
    public void appendEdge(E edge) {
        Preconditions.checkNotNull(edge, (Object)"Edge cannot be null");
        Preconditions.checkArgument((this.edges.isEmpty() || this.dst().equals(edge.src()) ? 1 : 0) != 0, (Object)"Edge source must be the same as the current path destination");
        this.edges.add(edge);
    }

    @Override
    public void removeEdge(E edge) {
        Preconditions.checkArgument((edge.src().equals(edge.dst()) || this.edges.indexOf(edge) == 0 || this.edges.lastIndexOf(edge) == this.edges.size() - 1 ? 1 : 0) != 0, (Object)"Edge must be at start or end of path, or it must be a cyclic edge");
        this.edges.remove(edge);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("src", this.src()).add("dst", this.dst()).add("cost", (Object)this.cost).add("edges", this.edges).toString();
    }

    public int hashCode() {
        return Objects.hash(this.edges, this.cost);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultMutablePath) {
            DefaultMutablePath other = (DefaultMutablePath)obj;
            return Objects.equals(this.cost, other.cost) && Objects.equals(this.edges, other.edges);
        }
        return false;
    }
}

