/*
 * Decompiled with CFR 0.152.
 */
package org.onlab.packet.dhcp;

import com.google.common.collect.Maps;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.Objects;
import org.onlab.packet.DeserializationException;
import org.onlab.packet.Deserializer;
import org.onlab.packet.IPacket;
import org.onlab.packet.dhcp.DhcpOption;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DhcpRelayAgentOption
extends DhcpOption {
    private static final int SUB_OPT_DEFAULT_LEN = 2;
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final Map<Byte, DhcpOption> subOptions = Maps.newHashMap();

    @Override
    public byte[] serialize() {
        int totalLen = 0;
        totalLen += this.subOptions.size() * 2;
        totalLen += this.subOptions.values().stream().mapToInt(DhcpOption::getLength).sum();
        ByteBuffer byteBuffer = ByteBuffer.allocate(totalLen += 2);
        byteBuffer.put(this.code);
        byteBuffer.put(this.length);
        this.subOptions.values().forEach(subOpt -> {
            byteBuffer.put(subOpt.code);
            byteBuffer.put(subOpt.length);
            byteBuffer.put(subOpt.data);
        });
        return byteBuffer.array();
    }

    @Override
    public IPacket deserialize(byte[] data, int offset, int length) {
        try {
            return DhcpRelayAgentOption.deserializer().deserialize(data, offset, length);
        }
        catch (DeserializationException e) {
            this.log.warn("can't deserialize DHCP relay agent information option {}", (Throwable)e);
            return null;
        }
    }

    public static Deserializer<DhcpOption> deserializer() {
        return (data, offset, length) -> {
            DhcpRelayAgentOption relayOption = new DhcpRelayAgentOption();
            ByteBuffer byteBuffer = ByteBuffer.wrap(data, offset, length);
            relayOption.code = byteBuffer.get();
            relayOption.length = byteBuffer.get();
            while (byteBuffer.remaining() >= 2) {
                byte subOptCode = byteBuffer.get();
                byte subOptLen = byteBuffer.get();
                byte[] subOptData = new byte[subOptLen];
                byteBuffer.get(subOptData);
                DhcpOption subOption = new DhcpOption();
                subOption.code = subOptCode;
                subOption.length = subOptLen;
                subOption.data = subOptData;
                relayOption.subOptions.put(subOptCode, subOption);
            }
            return relayOption;
        };
    }

    public DhcpOption getSubOption(byte code) {
        return this.subOptions.get(code);
    }

    public void addSubOption(DhcpOption subOption) {
        this.length = (byte)(this.length + (2 + subOption.length));
        this.subOptions.put(subOption.getCode(), subOption);
    }

    public DhcpOption removeSubOption(byte code) {
        DhcpOption subOption = this.subOptions.remove(code);
        if (subOption != null) {
            this.length = (byte)(this.length - (2 + subOption.length));
        }
        return subOption;
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof DhcpRelayAgentOption)) {
            return false;
        }
        DhcpRelayAgentOption that = (DhcpRelayAgentOption)obj;
        return Objects.equals(this.subOptions, that.subOptions);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.subOptions);
    }

    public static enum RelayAgentInfoOptions {
        CIRCUIT_ID(1),
        REMOTE_ID(2),
        DOCSIS(4),
        LINK_SELECTION(5),
        SUBSCRIBER_ID(6),
        RADIUS(7),
        AUTH(8),
        VENDOR_SPECIFIC(9),
        RELAY_AGENT_FLAGS(10),
        SERVER_ID_OVERRIDE(11),
        VIRTUAL_SUBNET_SELECTION(-105),
        VIRTUAL_SUBNET_SELECTION_CTRL(-104);

        private byte value;

        public byte getValue() {
            return this.value;
        }

        private RelayAgentInfoOptions(byte value) {
            this.value = value;
        }
    }
}

