/*
 * Decompiled with CFR 0.152.
 */
package org.onlab.util;

import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.onlab.util.RetryingFunction;

public class RetryingFunctionTest {
    private int round;

    @Before
    public void setUp() {
        this.round = 1;
    }

    @After
    public void tearDown() {
        this.round = 0;
    }

    @Test(expected=RetryableException.class)
    public void testNoRetries() {
        new RetryingFunction(this::succeedAfterOneFailure, RetryableException.class, 0, 10).apply(null);
    }

    @Test
    public void testSuccessAfterOneRetry() {
        new RetryingFunction(this::succeedAfterOneFailure, RetryableException.class, 1, 10).apply(null);
    }

    @Test(expected=RetryableException.class)
    public void testFailureAfterOneRetry() {
        new RetryingFunction(this::succeedAfterTwoFailures, RetryableException.class, 1, 10).apply(null);
    }

    @Test
    public void testFailureAfterTwoRetries() {
        new RetryingFunction(this::succeedAfterTwoFailures, RetryableException.class, 2, 10).apply(null);
    }

    @Test(expected=NonRetryableException.class)
    public void testFailureWithNonRetryableFailure() {
        new RetryingFunction(this::failCompletely, RetryableException.class, 2, 10).apply(null);
    }

    private String succeedAfterOneFailure(String input) {
        if (this.round++ <= 1) {
            throw new RetryableException();
        }
        return "pass";
    }

    private String succeedAfterTwoFailures(String input) {
        if (this.round++ <= 2) {
            throw new RetryableException();
        }
        return "pass";
    }

    private String failCompletely(String input) {
        if (this.round++ <= 1) {
            throw new NonRetryableException();
        }
        return "pass";
    }

    private class NonRetryableException
    extends RuntimeException {
        private NonRetryableException() {
        }
    }

    private class RetryableException
    extends RuntimeException {
        private RetryableException() {
        }
    }
}

