/*
 * Decompiled with CFR 0.152.
 */
package org.onlab.packet.dhcp;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.io.Resources;
import java.net.URL;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.onlab.packet.DHCP6;
import org.onlab.packet.Deserializer;
import org.onlab.packet.IPacket;
import org.onlab.packet.Ip6Address;
import org.onlab.packet.MacAddress;
import org.onlab.packet.PacketTestUtils;
import org.onlab.packet.dhcp.Dhcp6ClientIdOption;
import org.onlab.packet.dhcp.Dhcp6Duid;
import org.onlab.packet.dhcp.Dhcp6IaAddressOption;
import org.onlab.packet.dhcp.Dhcp6IaNaOption;
import org.onlab.packet.dhcp.Dhcp6Option;
import org.onlab.packet.dhcp.Dhcp6RelayOption;
import org.onlab.packet.dhcp.Dhcp6RelayTest;

public class Dhcp6Test {
    private static final String SOLICIT = "dhcp6_solicit.bin";
    private static final String ADVERTISE = "dhcp6_advertise.bin";
    private static final String REQUEST = "dhcp6_request.bin";
    private static final String REPLY = "dhcp6_reply.bin";
    private static final int XID_1 = 13346301;
    private static final int XID_2 = 9807588;
    private static final int IA_ID = 1;
    private static final int T1_CLIENT = 3600;
    private static final int T2_CLIENT = 5400;
    private static final int T1_SERVER = 0;
    private static final int T2_SERVER = 0;
    private static final Ip6Address IA_ADDRESS = Ip6Address.valueOf((String)"2000::201");
    private static final int PREFFERRED_LT_SERVER = 375;
    private static final int VALID_LT_SERVER = 600;
    private static final int PREFFERRED_LT_REQ = 7200;
    private static final int VALID_LT_REQ = 7500;
    private static final MacAddress CLIENT_MAC = MacAddress.valueOf((String)"00:bb:00:00:00:01");
    private static final int CLIENT_DUID_TIME = 553653940;
    private Deserializer<DHCP6> deserializer = DHCP6.deserializer();

    @Test
    public void testDeserializeBadInput() throws Exception {
        PacketTestUtils.testDeserializeBadInput(this.deserializer);
    }

    @Test
    public void testDeserializeTruncated() throws Exception {
        ByteBuffer bb = ByteBuffer.allocate(4);
        bb.put(DHCP6.MsgType.REQUEST.value());
        bb.put(new byte[]{0, 0});
        PacketTestUtils.testDeserializeTruncated(this.deserializer, bb.array());
    }

    @Test
    public void testDeserializeSolicit() throws Exception {
        byte[] data = Resources.toByteArray((URL)Dhcp6RelayTest.class.getResource(SOLICIT));
        DHCP6 dhcp6 = (DHCP6)DHCP6.deserializer().deserialize(data, 0, data.length);
        Assert.assertEquals((long)dhcp6.getMsgType(), (long)DHCP6.MsgType.SOLICIT.value());
        Assert.assertEquals((long)dhcp6.getTransactionId(), (long)13346301L);
        Assert.assertEquals((long)dhcp6.getOptions().size(), (long)4L);
        Dhcp6Option option = (Dhcp6Option)dhcp6.getOptions().get(0);
        Assert.assertTrue((boolean)(option instanceof Dhcp6ClientIdOption));
        Dhcp6ClientIdOption clientIdOption = (Dhcp6ClientIdOption)option;
        Assert.assertEquals((long)clientIdOption.getCode(), (long)DHCP6.OptionCode.CLIENTID.value());
        Assert.assertEquals((long)clientIdOption.getLength(), (long)14L);
        Assert.assertEquals((Object)clientIdOption.getDuid().getDuidType(), (Object)Dhcp6Duid.DuidType.DUID_LLT);
        Assert.assertEquals((long)clientIdOption.getDuid().getHardwareType(), (long)1L);
        Assert.assertEquals((long)clientIdOption.getDuid().getDuidTime(), (long)553653940L);
        Assert.assertArrayEquals((byte[])clientIdOption.getDuid().getLinkLayerAddress(), (byte[])CLIENT_MAC.toBytes());
        option = (Dhcp6Option)dhcp6.getOptions().get(1);
        Assert.assertEquals((long)option.getCode(), (long)DHCP6.OptionCode.ORO.value());
        Assert.assertEquals((long)option.getLength(), (long)8L);
        Assert.assertArrayEquals((byte[])option.getData(), (byte[])new byte[]{0, 23, 0, 24, 0, 39, 0, 31});
        option = (Dhcp6Option)dhcp6.getOptions().get(2);
        Assert.assertEquals((long)option.getCode(), (long)DHCP6.OptionCode.ELAPSED_TIME.value());
        Assert.assertEquals((long)option.getLength(), (long)2L);
        Assert.assertArrayEquals((byte[])option.getData(), (byte[])new byte[]{0, 0});
        option = (Dhcp6Option)dhcp6.getOptions().get(3);
        Assert.assertTrue((boolean)(option instanceof Dhcp6IaNaOption));
        Dhcp6IaNaOption iaNaOption = (Dhcp6IaNaOption)option;
        Assert.assertEquals((long)iaNaOption.getCode(), (long)DHCP6.OptionCode.IA_NA.value());
        Assert.assertEquals((long)iaNaOption.getLength(), (long)12L);
        Assert.assertEquals((long)iaNaOption.getIaId(), (long)1L);
        Assert.assertEquals((long)iaNaOption.getT1(), (long)3600L);
        Assert.assertEquals((long)iaNaOption.getT2(), (long)5400L);
        Assert.assertEquals((long)iaNaOption.getOptions().size(), (long)0L);
        Assert.assertArrayEquals((byte[])data, (byte[])dhcp6.serialize());
    }

    @Test
    public void serializeSolicit() throws Exception {
        DHCP6 dhcp6 = new DHCP6();
        dhcp6.setMsgType(DHCP6.MsgType.SOLICIT.value());
        dhcp6.setTransactionId(13346301);
        ArrayList options = Lists.newArrayList();
        Dhcp6Duid duid = new Dhcp6Duid();
        duid.setDuidType(Dhcp6Duid.DuidType.DUID_LLT);
        duid.setHardwareType((short)1);
        duid.setDuidTime(553653940);
        duid.setLinkLayerAddress(CLIENT_MAC.toBytes());
        Dhcp6ClientIdOption clientIdOption = new Dhcp6ClientIdOption();
        clientIdOption.setDuid(duid);
        options.add(clientIdOption);
        Dhcp6Option option = new Dhcp6Option();
        option.setCode(DHCP6.OptionCode.ORO.value());
        option.setLength((short)8);
        option.setData(new byte[]{0, 23, 0, 24, 0, 39, 0, 31});
        options.add(option);
        option = new Dhcp6Option();
        option.setCode(DHCP6.OptionCode.ELAPSED_TIME.value());
        option.setLength((short)2);
        option.setData(new byte[]{0, 0});
        options.add(option);
        Dhcp6IaNaOption iaNaOption = new Dhcp6IaNaOption();
        iaNaOption.setIaId(1);
        iaNaOption.setT1(3600);
        iaNaOption.setT2(5400);
        iaNaOption.setOptions(Collections.emptyList());
        options.add(iaNaOption);
        dhcp6.setOptions((List)options);
        Dhcp6RelayOption relayOption = new Dhcp6RelayOption();
        relayOption.setPayload((IPacket)dhcp6);
        Assert.assertArrayEquals((byte[])Resources.toByteArray((URL)Dhcp6RelayTest.class.getResource(SOLICIT)), (byte[])dhcp6.serialize());
    }

    @Test
    public void deserializeAdvertise() throws Exception {
        byte[] data = Resources.toByteArray((URL)this.getClass().getResource(ADVERTISE));
        DHCP6 dhcp6 = (DHCP6)DHCP6.deserializer().deserialize(data, 0, data.length);
        Assert.assertEquals((long)dhcp6.getMsgType(), (long)DHCP6.MsgType.ADVERTISE.value());
        Assert.assertEquals((long)dhcp6.getTransactionId(), (long)13346301L);
        Assert.assertEquals((long)dhcp6.getOptions().size(), (long)3L);
        Dhcp6Option option = (Dhcp6Option)dhcp6.getOptions().get(0);
        Assert.assertTrue((boolean)(option instanceof Dhcp6IaNaOption));
        Dhcp6IaNaOption iaNaOption = (Dhcp6IaNaOption)option;
        Assert.assertEquals((long)iaNaOption.getCode(), (long)DHCP6.OptionCode.IA_NA.value());
        Assert.assertEquals((long)iaNaOption.getLength(), (long)40L);
        Assert.assertEquals((long)iaNaOption.getIaId(), (long)1L);
        Assert.assertEquals((long)iaNaOption.getT1(), (long)0L);
        Assert.assertEquals((long)iaNaOption.getT2(), (long)0L);
        Assert.assertEquals((long)iaNaOption.getOptions().size(), (long)1L);
        Assert.assertTrue((boolean)(iaNaOption.getOptions().get(0) instanceof Dhcp6IaAddressOption));
        Dhcp6IaAddressOption iaAddressOption = (Dhcp6IaAddressOption)iaNaOption.getOptions().get(0);
        Assert.assertEquals((Object)iaAddressOption.getIp6Address(), (Object)IA_ADDRESS);
        Assert.assertEquals((long)iaAddressOption.getPreferredLifetime(), (long)375L);
        Assert.assertEquals((long)iaAddressOption.getValidLifetime(), (long)600L);
        Assert.assertNull((Object)iaAddressOption.getOptions());
        option = (Dhcp6Option)dhcp6.getOptions().get(1);
        Assert.assertTrue((boolean)(option instanceof Dhcp6ClientIdOption));
        Dhcp6ClientIdOption clientIdOption = (Dhcp6ClientIdOption)option;
        Assert.assertEquals((long)clientIdOption.getCode(), (long)DHCP6.OptionCode.CLIENTID.value());
        Assert.assertEquals((long)clientIdOption.getLength(), (long)14L);
        Assert.assertEquals((Object)clientIdOption.getDuid().getDuidType(), (Object)Dhcp6Duid.DuidType.DUID_LLT);
        Assert.assertEquals((long)clientIdOption.getDuid().getHardwareType(), (long)1L);
        Assert.assertEquals((long)clientIdOption.getDuid().getDuidTime(), (long)553653940L);
        Assert.assertArrayEquals((byte[])clientIdOption.getDuid().getLinkLayerAddress(), (byte[])CLIENT_MAC.toBytes());
        option = (Dhcp6Option)dhcp6.getOptions().get(2);
        Assert.assertEquals((long)option.getCode(), (long)DHCP6.OptionCode.SERVERID.value());
        Assert.assertEquals((long)option.getLength(), (long)14L);
        Assert.assertArrayEquals((byte[])option.getData(), (byte[])new byte[]{0, 1, 0, 1, 32, -1, -8, -17, 0, -103, 102, 0, 0, 1});
        Assert.assertArrayEquals((byte[])data, (byte[])dhcp6.serialize());
    }

    @Test
    public void serializeAdvertise() throws Exception {
        DHCP6 dhcp6 = new DHCP6();
        dhcp6.setMsgType(DHCP6.MsgType.ADVERTISE.value());
        dhcp6.setTransactionId(13346301);
        ArrayList options = Lists.newArrayList();
        Dhcp6IaAddressOption iaAddressOption = new Dhcp6IaAddressOption();
        iaAddressOption.setIp6Address(IA_ADDRESS);
        iaAddressOption.setPreferredLifetime(375);
        iaAddressOption.setValidLifetime(600);
        Dhcp6IaNaOption iaNaOption = new Dhcp6IaNaOption();
        iaNaOption.setIaId(1);
        iaNaOption.setT1(0);
        iaNaOption.setT2(0);
        iaNaOption.setOptions((List)ImmutableList.of((Object)iaAddressOption));
        options.add(iaNaOption);
        Dhcp6Duid duid = new Dhcp6Duid();
        duid.setDuidType(Dhcp6Duid.DuidType.DUID_LLT);
        duid.setHardwareType((short)1);
        duid.setDuidTime(553653940);
        duid.setLinkLayerAddress(CLIENT_MAC.toBytes());
        Dhcp6ClientIdOption clientIdOption = new Dhcp6ClientIdOption();
        clientIdOption.setDuid(duid);
        options.add(clientIdOption);
        Dhcp6Option option = new Dhcp6Option();
        option.setCode(DHCP6.OptionCode.SERVERID.value());
        option.setLength((short)14);
        option.setData(new byte[]{0, 1, 0, 1, 32, -1, -8, -17, 0, -103, 102, 0, 0, 1});
        options.add(option);
        dhcp6.setOptions((List)options);
        Dhcp6RelayOption relayOption = new Dhcp6RelayOption();
        relayOption.setPayload((IPacket)dhcp6);
        Assert.assertArrayEquals((byte[])Resources.toByteArray((URL)Dhcp6RelayTest.class.getResource(ADVERTISE)), (byte[])dhcp6.serialize());
    }

    @Test
    public void deserializeRequest() throws Exception {
        byte[] data = Resources.toByteArray((URL)this.getClass().getResource(REQUEST));
        DHCP6 dhcp6 = (DHCP6)DHCP6.deserializer().deserialize(data, 0, data.length);
        Assert.assertEquals((long)dhcp6.getMsgType(), (long)DHCP6.MsgType.REQUEST.value());
        Assert.assertEquals((long)dhcp6.getTransactionId(), (long)9807588L);
        Assert.assertEquals((long)dhcp6.getOptions().size(), (long)5L);
        Dhcp6Option option = (Dhcp6Option)dhcp6.getOptions().get(0);
        Assert.assertTrue((boolean)(option instanceof Dhcp6ClientIdOption));
        Dhcp6ClientIdOption clientIdOption = (Dhcp6ClientIdOption)option;
        Assert.assertEquals((long)clientIdOption.getCode(), (long)DHCP6.OptionCode.CLIENTID.value());
        Assert.assertEquals((long)clientIdOption.getLength(), (long)14L);
        Assert.assertEquals((Object)clientIdOption.getDuid().getDuidType(), (Object)Dhcp6Duid.DuidType.DUID_LLT);
        Assert.assertEquals((long)clientIdOption.getDuid().getHardwareType(), (long)1L);
        Assert.assertEquals((long)clientIdOption.getDuid().getDuidTime(), (long)553653940L);
        Assert.assertArrayEquals((byte[])clientIdOption.getDuid().getLinkLayerAddress(), (byte[])CLIENT_MAC.toBytes());
        option = (Dhcp6Option)dhcp6.getOptions().get(1);
        Assert.assertEquals((long)option.getCode(), (long)DHCP6.OptionCode.SERVERID.value());
        Assert.assertEquals((long)option.getLength(), (long)14L);
        Assert.assertArrayEquals((byte[])option.getData(), (byte[])new byte[]{0, 1, 0, 1, 32, -1, -8, -17, 0, -103, 102, 0, 0, 1});
        option = (Dhcp6Option)dhcp6.getOptions().get(2);
        Assert.assertEquals((long)option.getCode(), (long)DHCP6.OptionCode.ORO.value());
        Assert.assertEquals((long)option.getLength(), (long)8L);
        Assert.assertArrayEquals((byte[])option.getData(), (byte[])new byte[]{0, 23, 0, 24, 0, 39, 0, 31});
        option = (Dhcp6Option)dhcp6.getOptions().get(3);
        Assert.assertEquals((long)option.getCode(), (long)DHCP6.OptionCode.ELAPSED_TIME.value());
        Assert.assertEquals((long)option.getLength(), (long)2L);
        Assert.assertArrayEquals((byte[])option.getData(), (byte[])new byte[]{0, 0});
        option = (Dhcp6Option)dhcp6.getOptions().get(4);
        Assert.assertTrue((boolean)(option instanceof Dhcp6IaNaOption));
        Dhcp6IaNaOption iaNaOption = (Dhcp6IaNaOption)option;
        Assert.assertEquals((long)iaNaOption.getCode(), (long)DHCP6.OptionCode.IA_NA.value());
        Assert.assertEquals((long)iaNaOption.getLength(), (long)40L);
        Assert.assertEquals((long)iaNaOption.getIaId(), (long)1L);
        Assert.assertEquals((long)iaNaOption.getT1(), (long)3600L);
        Assert.assertEquals((long)iaNaOption.getT2(), (long)5400L);
        Assert.assertEquals((long)iaNaOption.getOptions().size(), (long)1L);
        Assert.assertTrue((boolean)(iaNaOption.getOptions().get(0) instanceof Dhcp6IaAddressOption));
        Dhcp6IaAddressOption iaAddressOption = (Dhcp6IaAddressOption)iaNaOption.getOptions().get(0);
        Assert.assertEquals((Object)iaAddressOption.getIp6Address(), (Object)IA_ADDRESS);
        Assert.assertEquals((long)iaAddressOption.getPreferredLifetime(), (long)7200L);
        Assert.assertEquals((long)iaAddressOption.getValidLifetime(), (long)7500L);
        Assert.assertNull((Object)iaAddressOption.getOptions());
        Assert.assertArrayEquals((byte[])data, (byte[])dhcp6.serialize());
    }

    @Test
    public void serializeRequest() throws Exception {
        DHCP6 dhcp6 = new DHCP6();
        dhcp6.setMsgType(DHCP6.MsgType.REQUEST.value());
        dhcp6.setTransactionId(9807588);
        ArrayList options = Lists.newArrayList();
        Dhcp6Duid duid = new Dhcp6Duid();
        duid.setDuidType(Dhcp6Duid.DuidType.DUID_LLT);
        duid.setHardwareType((short)1);
        duid.setDuidTime(553653940);
        duid.setLinkLayerAddress(CLIENT_MAC.toBytes());
        Dhcp6ClientIdOption clientIdOption = new Dhcp6ClientIdOption();
        clientIdOption.setDuid(duid);
        options.add(clientIdOption);
        Dhcp6Option option = new Dhcp6Option();
        option.setCode(DHCP6.OptionCode.SERVERID.value());
        option.setLength((short)14);
        option.setData(new byte[]{0, 1, 0, 1, 32, -1, -8, -17, 0, -103, 102, 0, 0, 1});
        options.add(option);
        option = new Dhcp6Option();
        option.setCode(DHCP6.OptionCode.ORO.value());
        option.setLength((short)8);
        option.setData(new byte[]{0, 23, 0, 24, 0, 39, 0, 31});
        options.add(option);
        option = new Dhcp6Option();
        option.setCode(DHCP6.OptionCode.ELAPSED_TIME.value());
        option.setLength((short)2);
        option.setData(new byte[]{0, 0});
        options.add(option);
        Dhcp6IaAddressOption iaAddressOption = new Dhcp6IaAddressOption();
        iaAddressOption.setIp6Address(IA_ADDRESS);
        iaAddressOption.setPreferredLifetime(7200);
        iaAddressOption.setValidLifetime(7500);
        Dhcp6IaNaOption iaNaOption = new Dhcp6IaNaOption();
        iaNaOption.setIaId(1);
        iaNaOption.setT1(3600);
        iaNaOption.setT2(5400);
        iaNaOption.setOptions((List)ImmutableList.of((Object)iaAddressOption));
        options.add(iaNaOption);
        dhcp6.setOptions((List)options);
        Dhcp6RelayOption relayOption = new Dhcp6RelayOption();
        relayOption.setPayload((IPacket)dhcp6);
        Assert.assertArrayEquals((byte[])Resources.toByteArray((URL)Dhcp6RelayTest.class.getResource(REQUEST)), (byte[])dhcp6.serialize());
    }

    @Test
    public void deserializeReply() throws Exception {
        byte[] data = Resources.toByteArray((URL)this.getClass().getResource(REPLY));
        DHCP6 dhcp6 = (DHCP6)DHCP6.deserializer().deserialize(data, 0, data.length);
        Assert.assertEquals((long)dhcp6.getMsgType(), (long)DHCP6.MsgType.REPLY.value());
        Assert.assertEquals((long)dhcp6.getTransactionId(), (long)9807588L);
        Assert.assertEquals((long)dhcp6.getOptions().size(), (long)3L);
        Dhcp6Option option = (Dhcp6Option)dhcp6.getOptions().get(0);
        Assert.assertTrue((boolean)(option instanceof Dhcp6IaNaOption));
        Dhcp6IaNaOption iaNaOption = (Dhcp6IaNaOption)option;
        Assert.assertEquals((long)iaNaOption.getCode(), (long)DHCP6.OptionCode.IA_NA.value());
        Assert.assertEquals((long)iaNaOption.getLength(), (long)40L);
        Assert.assertEquals((long)iaNaOption.getIaId(), (long)1L);
        Assert.assertEquals((long)iaNaOption.getT1(), (long)0L);
        Assert.assertEquals((long)iaNaOption.getT2(), (long)0L);
        Assert.assertEquals((long)iaNaOption.getOptions().size(), (long)1L);
        Assert.assertTrue((boolean)(iaNaOption.getOptions().get(0) instanceof Dhcp6IaAddressOption));
        Dhcp6IaAddressOption iaAddressOption = (Dhcp6IaAddressOption)iaNaOption.getOptions().get(0);
        Assert.assertEquals((Object)iaAddressOption.getIp6Address(), (Object)IA_ADDRESS);
        Assert.assertEquals((long)iaAddressOption.getPreferredLifetime(), (long)375L);
        Assert.assertEquals((long)iaAddressOption.getValidLifetime(), (long)600L);
        Assert.assertNull((Object)iaAddressOption.getOptions());
        option = (Dhcp6Option)dhcp6.getOptions().get(1);
        Assert.assertTrue((boolean)(option instanceof Dhcp6ClientIdOption));
        Dhcp6ClientIdOption clientIdOption = (Dhcp6ClientIdOption)option;
        Assert.assertEquals((long)clientIdOption.getCode(), (long)DHCP6.OptionCode.CLIENTID.value());
        Assert.assertEquals((long)clientIdOption.getLength(), (long)14L);
        Assert.assertEquals((Object)clientIdOption.getDuid().getDuidType(), (Object)Dhcp6Duid.DuidType.DUID_LLT);
        Assert.assertEquals((long)clientIdOption.getDuid().getHardwareType(), (long)1L);
        Assert.assertEquals((long)clientIdOption.getDuid().getDuidTime(), (long)553653940L);
        Assert.assertArrayEquals((byte[])clientIdOption.getDuid().getLinkLayerAddress(), (byte[])CLIENT_MAC.toBytes());
        option = (Dhcp6Option)dhcp6.getOptions().get(2);
        Assert.assertEquals((long)option.getCode(), (long)DHCP6.OptionCode.SERVERID.value());
        Assert.assertEquals((long)option.getLength(), (long)14L);
        Assert.assertArrayEquals((byte[])option.getData(), (byte[])new byte[]{0, 1, 0, 1, 32, -1, -8, -17, 0, -103, 102, 0, 0, 1});
        Assert.assertArrayEquals((byte[])data, (byte[])dhcp6.serialize());
    }

    @Test
    public void serializeReply() throws Exception {
        DHCP6 dhcp6 = new DHCP6();
        dhcp6.setMsgType(DHCP6.MsgType.REPLY.value());
        dhcp6.setTransactionId(9807588);
        ArrayList options = Lists.newArrayList();
        Dhcp6IaAddressOption iaAddressOption = new Dhcp6IaAddressOption();
        iaAddressOption.setIp6Address(IA_ADDRESS);
        iaAddressOption.setPreferredLifetime(375);
        iaAddressOption.setValidLifetime(600);
        Dhcp6IaNaOption iaNaOption = new Dhcp6IaNaOption();
        iaNaOption.setIaId(1);
        iaNaOption.setT1(0);
        iaNaOption.setT2(0);
        iaNaOption.setOptions((List)ImmutableList.of((Object)iaAddressOption));
        options.add(iaNaOption);
        Dhcp6Duid duid = new Dhcp6Duid();
        duid.setDuidType(Dhcp6Duid.DuidType.DUID_LLT);
        duid.setHardwareType((short)1);
        duid.setDuidTime(553653940);
        duid.setLinkLayerAddress(CLIENT_MAC.toBytes());
        Dhcp6ClientIdOption clientIdOption = new Dhcp6ClientIdOption();
        clientIdOption.setDuid(duid);
        options.add(clientIdOption);
        Dhcp6Option option = new Dhcp6Option();
        option.setCode(DHCP6.OptionCode.SERVERID.value());
        option.setLength((short)14);
        option.setData(new byte[]{0, 1, 0, 1, 32, -1, -8, -17, 0, -103, 102, 0, 0, 1});
        options.add(option);
        dhcp6.setOptions((List)options);
        Dhcp6RelayOption relayOption = new Dhcp6RelayOption();
        relayOption.setPayload((IPacket)dhcp6);
        Assert.assertArrayEquals((byte[])Resources.toByteArray((URL)Dhcp6RelayTest.class.getResource(REPLY)), (byte[])dhcp6.serialize());
    }
}

