/*
 * Decompiled with CFR 0.152.
 */
package org.onlab.graph;

import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.onlab.graph.DefaultEdgeWeigher;
import org.onlab.graph.DefaultMutablePath;
import org.onlab.graph.DefaultPath;
import org.onlab.graph.Edge;
import org.onlab.graph.EdgeWeigher;
import org.onlab.graph.Graph;
import org.onlab.graph.GraphPathSearch;
import org.onlab.graph.Path;
import org.onlab.graph.Vertex;
import org.onlab.graph.Weight;

public abstract class AbstractGraphPathSearch<V extends Vertex, E extends Edge<V>>
implements GraphPathSearch<V, E> {
    private void buildAllPaths(DefaultResult result, V src, V dst, int maxPaths) {
        DefaultMutablePath basePath = new DefaultMutablePath();
        basePath.setCost(result.cost(dst));
        HashSet pendingPaths = new HashSet();
        pendingPaths.add(basePath);
        while (!(pendingPaths.isEmpty() || maxPaths != -1 && result.paths.size() >= maxPaths)) {
            HashSet<DefaultMutablePath> frontier = new HashSet<DefaultMutablePath>();
            for (DefaultMutablePath path : pendingPaths) {
                V firstVertex = this.firstVertex(path, dst);
                if (firstVertex.equals(src)) {
                    path.setCost(result.cost(dst));
                    result.paths.add(new DefaultPath(path.edges(), path.cost()));
                    continue;
                }
                Set firstVertexParents = result.parents.get(firstVertex);
                if (firstVertexParents == null || firstVertexParents.isEmpty()) break;
                Iterator edges = firstVertexParents.iterator();
                while (edges.hasNext()) {
                    boolean isLast;
                    Edge edge = (Edge)edges.next();
                    boolean bl = isLast = !edges.hasNext();
                    if (this.isInPath(edge, path)) continue;
                    DefaultMutablePath pendingPath = isLast ? path : new DefaultMutablePath(path);
                    pendingPath.insertEdge(edge);
                    frontier.add(pendingPath);
                }
            }
            pendingPaths = frontier;
        }
    }

    private boolean isInPath(E edge, DefaultMutablePath<V, E> path) {
        return path.edges().stream().anyMatch(e -> edge.src().equals(e.dst()));
    }

    private V firstVertex(Path<V, E> path, V dst) {
        return path.edges().isEmpty() ? dst : ((Edge)path.edges().get(0)).src();
    }

    protected void checkArguments(Graph<V, E> graph, V src, V dst) {
        Preconditions.checkNotNull(graph, (Object)"Graph cannot be null");
        Preconditions.checkNotNull(src, (Object)"Source cannot be null");
        Set<V> vertices = graph.getVertexes();
        Preconditions.checkArgument((boolean)vertices.contains(src), (Object)"Source not in the graph");
        Preconditions.checkArgument((dst == null || vertices.contains(dst) ? 1 : 0) != 0, (Object)"Destination not in graph");
    }

    @Override
    public GraphPathSearch.Result<V, E> search(Graph<V, E> graph, V src, V dst, EdgeWeigher<V, E> weigher, int maxPaths) {
        this.checkArguments(graph, src, dst);
        return this.internalSearch(graph, src, dst, weigher != null ? weigher : new DefaultEdgeWeigher(), maxPaths);
    }

    protected abstract GraphPathSearch.Result<V, E> internalSearch(Graph<V, E> var1, V var2, V var3, EdgeWeigher<V, E> var4, int var5);

    protected class DefaultResult
    implements GraphPathSearch.Result<V, E> {
        private final V src;
        private final V dst;
        protected final Set<Path<V, E>> paths = new HashSet();
        protected final Map<V, Weight> costs = new HashMap();
        protected final Map<V, Set<E>> parents = new HashMap();
        protected final int maxPaths;
        final /* synthetic */ AbstractGraphPathSearch this$0;

        public DefaultResult(V src, V dst) {
            this(this$0, (Vertex)src, (Vertex)dst, 1);
        }

        /*
         * WARNING - Possible parameter corruption
         */
        public DefaultResult(V src, V dst, int maxPaths) {
            this.this$0 = (AbstractGraphPathSearch)this$0;
            Preconditions.checkNotNull(src, (Object)"Source cannot be null");
            this.src = src;
            this.dst = dst;
            this.maxPaths = maxPaths;
        }

        @Override
        public V src() {
            return this.src;
        }

        @Override
        public V dst() {
            return this.dst;
        }

        @Override
        public Set<Path<V, E>> paths() {
            return this.paths;
        }

        @Override
        public Map<V, Weight> costs() {
            return this.costs;
        }

        @Override
        public Map<V, Set<E>> parents() {
            return this.parents;
        }

        boolean hasCost(V v) {
            return this.costs.containsKey(v);
        }

        Weight cost(V v) {
            return this.costs.get(v);
        }

        void updateVertex(V vertex, E edge, Weight cost, boolean replace) {
            this.costs.put((Weight)vertex, cost);
            if (edge != null) {
                Set edges = this.parents.get(vertex);
                if (edges == null) {
                    edges = new HashSet();
                    this.parents.put((Set)vertex, edges);
                }
                if (replace) {
                    edges.clear();
                }
                if (this.maxPaths == -1 || edges.size() < this.maxPaths) {
                    edges.add(edge);
                }
            }
        }

        void removeVertex(V v) {
            this.parents.remove(v);
        }

        boolean relaxEdge(E edge, Weight cost, EdgeWeigher<V, E> ew, boolean ... forbidNegatives) {
            Object v = edge.dst();
            Weight hopCost = ew.weight(edge);
            if (!hopCost.isViable() || hopCost.isNegative() && forbidNegatives.length == 1 && forbidNegatives[0]) {
                return false;
            }
            Weight newCost = cost.merge(hopCost);
            int compareResult = -1;
            if (this.hasCost(v)) {
                Weight oldCost = this.cost(v);
                compareResult = newCost.compareTo(oldCost);
            }
            if (compareResult <= 0) {
                this.updateVertex(v, edge, newCost, compareResult < 0);
            }
            return compareResult < 0;
        }

        protected void buildPaths() {
            HashSet destinations = new HashSet();
            if (this.dst == null) {
                destinations.addAll(this.costs.keySet());
            } else {
                destinations.add(this.dst);
            }
            for (Vertex v : destinations) {
                if (v.equals(this.src)) continue;
                this.this$0.buildAllPaths(this, this.src, v, this.maxPaths);
            }
        }
    }
}

