/*
 * Decompiled with CFR 0.152.
 */
package org.onlab.packet;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.onlab.packet.BasePacket;
import org.onlab.packet.DeserializationException;
import org.onlab.packet.Deserializer;
import org.onlab.packet.IPacket;
import org.onlab.packet.Ip6Address;
import org.onlab.packet.dhcp.Dhcp6ClientIdOption;
import org.onlab.packet.dhcp.Dhcp6IaAddressOption;
import org.onlab.packet.dhcp.Dhcp6IaNaOption;
import org.onlab.packet.dhcp.Dhcp6IaTaOption;
import org.onlab.packet.dhcp.Dhcp6Option;
import org.onlab.packet.dhcp.Dhcp6RelayOption;

public class DHCP6
extends BasePacket {
    private static final int OPT_CODE_SIZE = 2;
    private static final int OPT_LEN_SIZE = 2;
    private static final int DHCP6_DEFAULT_SIZE = 4;
    private static final int DHCP6_RELAY_MSG_SIZE = 34;
    private static final int IPV6_ADDR_LEN = 16;
    private static final int MSG_TYPE_OFFSET = 24;
    private static final int TRANSACTION_ID_MASK = 0xFFFFFF;
    public static final Set<Byte> RELAY_MSG_TYPES = ImmutableSet.of((Object)MsgType.RELAY_FORW.value, (Object)MsgType.RELAY_REPL.value);
    private static final Map<Short, Deserializer<Dhcp6Option>> OPT_DESERIALIZERS = ImmutableMap.of((Object)OptionCode.IA_NA.value, Dhcp6IaNaOption.deserializer(), (Object)OptionCode.IA_TA.value, Dhcp6IaTaOption.deserializer(), (Object)OptionCode.IAADDR.value, Dhcp6IaAddressOption.deserializer(), (Object)OptionCode.RELAY_MSG.value, Dhcp6RelayOption.deserializer(), (Object)OptionCode.CLIENTID.value, Dhcp6ClientIdOption.deserializer());
    private byte msgType;
    private List<Dhcp6Option> options = Lists.newArrayList();
    private int transactionId;
    private byte hopCount;
    private byte[] linkAddress;
    private byte[] peerAddress;

    @Override
    public byte[] serialize() {
        int payloadLength = this.options.stream().mapToInt(Dhcp6Option::getLength).sum();
        payloadLength += this.options.size() * 4;
        payloadLength = RELAY_MSG_TYPES.contains(this.msgType) ? (payloadLength += 34) : (payloadLength += 4);
        ByteBuffer bb = ByteBuffer.allocate(payloadLength);
        if (RELAY_MSG_TYPES.contains(this.msgType)) {
            bb.put(this.msgType);
            bb.put(this.hopCount);
            bb.put(this.linkAddress);
            bb.put(this.peerAddress);
        } else {
            int defaultHeader = this.msgType << 24 | this.transactionId & 0xFFFFFF;
            bb.putInt(defaultHeader);
        }
        this.options.forEach(option -> bb.put(option.serialize()));
        return bb.array();
    }

    public static Deserializer<DHCP6> deserializer() {
        return (data, offset, length) -> {
            DHCP6 dhcp6 = new DHCP6();
            Preconditions.checkNotNull((Object)data);
            if (offset < 0 || length < 0 || length > data.length || offset >= data.length || offset + length > data.length) {
                throw new DeserializationException("Illegal offset or length");
            }
            ByteBuffer bb = ByteBuffer.wrap(data, offset, length);
            if (bb.remaining() < 4) {
                throw new DeserializationException("Buffer underflow while reading DHCPv6 option");
            }
            dhcp6.msgType = (byte)(0xFF & bb.array()[offset]);
            if (RELAY_MSG_TYPES.contains(dhcp6.msgType)) {
                bb.get();
                dhcp6.hopCount = bb.get();
                dhcp6.linkAddress = new byte[16];
                dhcp6.peerAddress = new byte[16];
                bb.get(dhcp6.linkAddress);
                bb.get(dhcp6.peerAddress);
            } else {
                int defaultHeader = bb.getInt();
                dhcp6.transactionId = defaultHeader & 0xFFFFFF;
            }
            dhcp6.options = Lists.newArrayList();
            while (bb.remaining() >= 4) {
                ByteBuffer optByteBuffer = ByteBuffer.wrap(data, bb.position(), length - bb.position());
                short code = optByteBuffer.getShort();
                short optionLen = (short)(0xFFFF & optByteBuffer.getShort());
                if (optByteBuffer.remaining() < optionLen) {
                    throw new DeserializationException("Buffer underflow while reading DHCPv6 option");
                }
                byte[] optionData = new byte[4 + optionLen];
                bb.get(optionData);
                Dhcp6Option option = OPT_DESERIALIZERS.containsKey(code) ? OPT_DESERIALIZERS.get(code).deserialize(optionData, 0, optionData.length) : Dhcp6Option.deserializer().deserialize(optionData, 0, optionData.length);
                option.setParent(dhcp6);
                dhcp6.options.add(option);
            }
            return dhcp6;
        };
    }

    @Override
    public IPacket deserialize(byte[] data, int offset, int length) {
        try {
            return DHCP6.deserializer().deserialize(data, offset, length);
        }
        catch (DeserializationException e) {
            return null;
        }
    }

    public byte getMsgType() {
        return this.msgType;
    }

    public List<Dhcp6Option> getOptions() {
        return this.options;
    }

    public int getTransactionId() {
        return this.transactionId;
    }

    public byte getHopCount() {
        return this.hopCount;
    }

    public byte[] getLinkAddress() {
        return this.linkAddress;
    }

    public Ip6Address getIp6LinkAddress() {
        return this.linkAddress == null ? null : Ip6Address.valueOf(this.linkAddress);
    }

    public byte[] getPeerAddress() {
        return this.peerAddress;
    }

    public Ip6Address getIp6PeerAddress() {
        return this.peerAddress == null ? null : Ip6Address.valueOf(this.peerAddress);
    }

    public void setMsgType(byte msgType) {
        this.msgType = msgType;
    }

    public void setOptions(List<Dhcp6Option> options) {
        this.options = options;
    }

    public void setTransactionId(int transactionId) {
        this.transactionId = transactionId;
    }

    public void setHopCount(byte hopCount) {
        this.hopCount = hopCount;
    }

    public void setLinkAddress(byte[] linkAddress) {
        this.linkAddress = linkAddress;
    }

    public void setPeerAddress(byte[] peerAddress) {
        this.peerAddress = peerAddress;
    }

    public String toString() {
        if (RELAY_MSG_TYPES.contains(this.msgType)) {
            return MoreObjects.toStringHelper(this.getClass()).add("msgType", (int)this.msgType).add("hopCount", (int)this.hopCount).add("linkAddress", (Object)Ip6Address.valueOf(this.linkAddress)).add("peerAddress", (Object)Ip6Address.valueOf(this.peerAddress)).add("options", this.options).toString();
        }
        return MoreObjects.toStringHelper(this.getClass()).add("msgType", (int)this.msgType).add("transactionId", this.transactionId).add("options", this.options).toString();
    }

    public static enum OptionCode {
        CLIENTID(1),
        SERVERID(2),
        IA_NA(3),
        IA_TA(4),
        IAADDR(5),
        ORO(6),
        PREFERENCE(7),
        ELAPSED_TIME(8),
        RELAY_MSG(9),
        AUTH(11),
        UNICAST(12),
        STATUS_CODE(13),
        RAPID_COMMIT(14),
        USER_CLASS(15),
        VENDOR_CLASS(16),
        VENDOR_OPTS(17),
        INTERFACE_ID(18),
        RECONF_MSG(19),
        RECONF_ACCEPT(20);

        protected short value;

        private OptionCode(short value) {
            this.value = value;
        }

        public short value() {
            return this.value;
        }
    }

    public static enum MsgType {
        SOLICIT(1),
        ADVERTISE(2),
        REQUEST(3),
        CONFIRM(4),
        RENEW(5),
        REBIND(6),
        REPLY(7),
        RELEASE(8),
        DECLINE(9),
        RECONFIGURE(10),
        INFORMATION_REQUEST(11),
        RELAY_FORW(12),
        RELAY_REPL(13);

        protected byte value;

        private MsgType(byte value) {
            this.value = value;
        }

        public byte value() {
            return this.value;
        }
    }
}

