/*
 * Decompiled with CFR 0.152.
 */
package org.onlab.packet;

import com.google.common.base.MoreObjects;
import java.nio.ByteBuffer;
import org.onlab.packet.BasePacket;
import org.onlab.packet.Data;
import org.onlab.packet.DeserializationException;
import org.onlab.packet.Deserializer;
import org.onlab.packet.IPacket;
import org.onlab.packet.PacketUtils;

public class VXLAN
extends BasePacket {
    private static final short VXLAN_HEADER_LENGTH = 8;
    private static final int BYTE_SHIFT = 8;
    private static final int BYTE_MASK = 255;
    protected byte flags = 0;
    protected byte[] rsvd1 = new byte[]{0, 0, 0};
    protected byte[] vni = new byte[]{0, 0, 0};
    protected byte rsvd2 = 0;

    @Override
    public byte[] serialize() {
        byte[] payloadData = null;
        if (this.payload != null) {
            this.payload.setParent(this);
            payloadData = this.payload.serialize();
        }
        int length = 8 + (payloadData == null ? 0 : payloadData.length);
        byte[] data = new byte[length];
        ByteBuffer bb = ByteBuffer.wrap(data);
        bb.put(this.flags);
        bb.put(this.rsvd1);
        bb.put(this.vni);
        bb.put(this.rsvd2);
        if (payloadData != null) {
            bb.put(payloadData);
        }
        return data;
    }

    @Override
    public IPacket deserialize(byte[] data, int offset, int length) {
        ByteBuffer bb = ByteBuffer.wrap(data, offset, length);
        if (bb.remaining() < 8) {
            return this;
        }
        this.flags = bb.get();
        bb.get(this.rsvd1);
        bb.get(this.vni);
        this.rsvd2 = bb.get();
        Deserializer<Data> deserializer = Data.deserializer();
        try {
            this.payload = deserializer.deserialize(data, bb.position(), bb.limit() - bb.position());
            this.payload.setParent(this);
        }
        catch (DeserializationException e) {
            return this;
        }
        return this;
    }

    public int getVni() {
        return (this.vni[0] << 16) + (this.vni[1] << 8) + this.vni[2];
    }

    public VXLAN setVni(int vni) {
        this.vni[0] = (byte)(vni >> 16 & 0xFF);
        this.vni[1] = (byte)(vni >> 8 & 0xFF);
        this.vni[2] = (byte)(vni & 0xFF);
        return this;
    }

    public byte getFlag() {
        return this.flags;
    }

    public VXLAN setFlag(byte flags) {
        this.flags = flags;
        return this;
    }

    @Override
    public int hashCode() {
        int prime = 2521;
        int result = super.hashCode();
        result = 2521 * result + this.getVni();
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof VXLAN)) {
            return false;
        }
        VXLAN other = (VXLAN)obj;
        return this.getVni() == other.getVni();
    }

    public static Deserializer<VXLAN> deserializer() {
        return (data, offset, length) -> {
            PacketUtils.checkInput(data, offset, length, 8);
            VXLAN vxlan = new VXLAN();
            ByteBuffer bb = ByteBuffer.wrap(data, offset, length);
            vxlan.flags = bb.get();
            bb.get(vxlan.rsvd1);
            bb.get(vxlan.vni);
            vxlan.rsvd2 = bb.get();
            Deserializer<Data> deserializer = Data.deserializer();
            vxlan.payload = deserializer.deserialize(data, bb.position(), bb.limit() - bb.position());
            vxlan.payload.setParent(vxlan);
            return vxlan;
        };
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("vni", (Object)Integer.toString(this.getVni())).add("flags", (Object)Byte.toString(this.getFlag())).toString();
    }
}

