/*
 * Decompiled with CFR 0.152.
 */
package org.onlab.packet.dhcp;

import java.nio.ByteBuffer;
import org.onlab.packet.BasePacket;
import org.onlab.packet.Deserializer;
import org.onlab.packet.IPacket;

public class Dhcp6Duid
extends BasePacket {
    private static final int DEFAULT_LLT_LEN = 8;
    private static final int DEFAULT_EN_LEN = 6;
    private static final int DEFAULT_LL_LEN = 4;
    private DuidType duidType;
    private short hardwareType;
    private int duidTime;
    private byte[] linkLayerAddress;
    private int enterpriseNumber;
    private byte[] identifier;

    public DuidType getDuidType() {
        return this.duidType;
    }

    public void setDuidType(DuidType duidType) {
        this.duidType = duidType;
    }

    public short getHardwareType() {
        return this.hardwareType;
    }

    public void setHardwareType(short hardwareType) {
        this.hardwareType = hardwareType;
    }

    public int getDuidTime() {
        return this.duidTime;
    }

    public void setDuidTime(int duidTime) {
        this.duidTime = duidTime;
    }

    public byte[] getLinkLayerAddress() {
        return this.linkLayerAddress;
    }

    public void setLinkLayerAddress(byte[] linkLayerAddress) {
        this.linkLayerAddress = linkLayerAddress;
    }

    public int getEnterpriseNumber() {
        return this.enterpriseNumber;
    }

    public void setEnterpriseNumber(int enterpriseNumber) {
        this.enterpriseNumber = enterpriseNumber;
    }

    public byte[] getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(byte[] identifier) {
        this.identifier = identifier;
    }

    @Override
    public byte[] serialize() {
        ByteBuffer byteBuffer;
        switch (this.duidType) {
            case DUID_LLT: {
                byteBuffer = ByteBuffer.allocate(8 + this.linkLayerAddress.length);
                byteBuffer.putShort(this.duidType.value);
                byteBuffer.putShort(this.hardwareType);
                byteBuffer.putInt(this.duidTime);
                byteBuffer.put(this.linkLayerAddress);
                break;
            }
            case DUID_EN: {
                byteBuffer = ByteBuffer.allocate(6 + this.identifier.length);
                byteBuffer.putShort(this.duidType.value);
                byteBuffer.putInt(this.enterpriseNumber);
                byteBuffer.put(this.identifier);
                break;
            }
            case DUID_LL: {
                byteBuffer = ByteBuffer.allocate(4 + this.linkLayerAddress.length);
                byteBuffer.putShort(this.duidType.value);
                byteBuffer.putShort(this.hardwareType);
                byteBuffer.put(this.linkLayerAddress);
                break;
            }
            default: {
                throw new RuntimeException("Unknown duidType: " + this.duidType.toString());
            }
        }
        return byteBuffer.array();
    }

    @Override
    public IPacket deserialize(byte[] data, int offset, int length) {
        return null;
    }

    public static Deserializer<Dhcp6Duid> deserializer() {
        return (data, offset, length) -> {
            Dhcp6Duid duid = new Dhcp6Duid();
            ByteBuffer byteBuffer = ByteBuffer.wrap(data, offset, length);
            DuidType duidType = DuidType.of(byteBuffer.getShort());
            duid.setDuidType(duidType);
            switch (duidType) {
                case DUID_LLT: {
                    duid.setHardwareType(byteBuffer.getShort());
                    duid.setDuidTime(byteBuffer.getInt());
                    duid.linkLayerAddress = new byte[length - 8];
                    byteBuffer.get(duid.linkLayerAddress);
                    break;
                }
                case DUID_EN: {
                    duid.setEnterpriseNumber(byteBuffer.getInt());
                    duid.identifier = new byte[length - 6];
                    byteBuffer.get(duid.identifier);
                    break;
                }
                case DUID_LL: {
                    duid.setHardwareType(byteBuffer.getShort());
                    duid.linkLayerAddress = new byte[length - 4];
                    byteBuffer.get(duid.linkLayerAddress);
                    break;
                }
                default: {
                    throw new RuntimeException("Unknown type: " + (Object)((Object)duidType));
                }
            }
            return duid;
        };
    }

    public static enum DuidType {
        DUID_LLT(1),
        DUID_EN(2),
        DUID_LL(3);

        private short value;

        private DuidType(short value) {
            this.value = value;
        }

        public short getValue() {
            return this.value;
        }

        public static DuidType of(short type) {
            switch (type) {
                case 1: {
                    return DUID_LLT;
                }
                case 2: {
                    return DUID_EN;
                }
                case 3: {
                    return DUID_LL;
                }
            }
            throw new RuntimeException("Unknown type: " + type);
        }
    }
}

