/*
 * Decompiled with CFR 0.152.
 */
package org.onlab.packet.dhcp;

import com.google.common.collect.Lists;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Objects;
import org.onlab.packet.DHCP6;
import org.onlab.packet.DeserializationException;
import org.onlab.packet.Deserializer;
import org.onlab.packet.dhcp.Dhcp6IaAddressOption;
import org.onlab.packet.dhcp.Dhcp6Option;

public final class Dhcp6IaNaOption
extends Dhcp6Option {
    public static final int DEFAULT_LEN = 12;
    private int iaId;
    private int t1;
    private int t2;
    private List<Dhcp6Option> options;

    @Override
    public short getCode() {
        return DHCP6.OptionCode.IA_NA.value();
    }

    @Override
    public short getLength() {
        return (short)(12 + this.options.stream().mapToInt(opt -> opt.getLength() + 4).sum());
    }

    public int getIaId() {
        return this.iaId;
    }

    public void setIaId(int iaId) {
        this.iaId = iaId;
    }

    public int getT1() {
        return this.t1;
    }

    public void setT1(int t1) {
        this.t1 = t1;
    }

    public int getT2() {
        return this.t2;
    }

    public void setT2(int t2) {
        this.t2 = t2;
    }

    public List<Dhcp6Option> getOptions() {
        return this.options;
    }

    public void setOptions(List<Dhcp6Option> options) {
        this.options = options;
    }

    public Dhcp6IaNaOption() {
    }

    public Dhcp6IaNaOption(Dhcp6Option dhcp6Option) {
        super(dhcp6Option);
    }

    public static Deserializer<Dhcp6Option> deserializer() {
        return (data, offset, length) -> {
            Dhcp6Option dhcp6Option = Dhcp6Option.deserializer().deserialize(data, offset, length);
            if (dhcp6Option.getLength() < 12) {
                throw new DeserializationException("Invalid IA NA option data");
            }
            Dhcp6IaNaOption iaNaOption = new Dhcp6IaNaOption(dhcp6Option);
            byte[] optionData = iaNaOption.getData();
            ByteBuffer bb = ByteBuffer.wrap(optionData);
            iaNaOption.iaId = bb.getInt();
            iaNaOption.t1 = bb.getInt();
            iaNaOption.t2 = bb.getInt();
            iaNaOption.options = Lists.newArrayList();
            while (bb.remaining() >= 4) {
                ByteBuffer optByteBuffer = ByteBuffer.wrap(optionData, bb.position(), optionData.length - bb.position());
                short code = optByteBuffer.getShort();
                short len = optByteBuffer.getShort();
                byte[] subOptData = new byte[4 + len];
                bb.get(subOptData);
                Dhcp6Option option = code == DHCP6.OptionCode.IAADDR.value() ? Dhcp6IaAddressOption.deserializer().deserialize(subOptData, 0, subOptData.length) : Dhcp6Option.deserializer().deserialize(subOptData, 0, subOptData.length);
                iaNaOption.options.add(option);
            }
            return iaNaOption;
        };
    }

    @Override
    public byte[] serialize() {
        int payloadLen = 12 + this.options.stream().mapToInt(opt -> opt.getLength() + 4).sum();
        int len = 4 + payloadLen;
        ByteBuffer bb = ByteBuffer.allocate(len);
        bb.putShort(DHCP6.OptionCode.IA_NA.value());
        bb.putShort((short)payloadLen);
        bb.putInt(this.iaId);
        bb.putInt(this.t1);
        bb.putInt(this.t2);
        this.options.stream().map(Dhcp6Option::serialize).forEach(bb::put);
        return bb.array();
    }

    @Override
    public int hashCode() {
        return 31 * super.hashCode() + Objects.hash(this.iaId, this.t1, this.t2, this.options);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        Dhcp6IaNaOption other = (Dhcp6IaNaOption)obj;
        return Objects.equals(this.iaId, other.iaId) && Objects.equals(this.t1, other.t1) && Objects.equals(this.t2, other.t2) && Objects.equals(this.options, other.options);
    }

    @Override
    public String toString() {
        return this.getToStringHelper().add("iaId", this.iaId).add("t1", this.t1).add("t2", this.t2).add("options", this.options).toString();
    }
}

