/*
 * Decompiled with CFR 0.152.
 */
package org.onlab.packet.dhcp;

import com.google.common.collect.Lists;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Objects;
import org.onlab.packet.DHCP6;
import org.onlab.packet.DeserializationException;
import org.onlab.packet.Deserializer;
import org.onlab.packet.dhcp.Dhcp6IaAddressOption;
import org.onlab.packet.dhcp.Dhcp6Option;

public final class Dhcp6IaTaOption
extends Dhcp6Option {
    public static final int DEFAULT_LEN = 4;
    private int iaId;
    private List<Dhcp6Option> options;

    @Override
    public short getCode() {
        return DHCP6.OptionCode.IA_TA.value();
    }

    @Override
    public short getLength() {
        return (short)(4 + this.options.stream().mapToInt(opt -> opt.getLength() + 4).sum());
    }

    public int getIaId() {
        return this.iaId;
    }

    public void setIaId(int iaId) {
        this.iaId = iaId;
    }

    public List<Dhcp6Option> getOptions() {
        return this.options;
    }

    public void setOptions(List<Dhcp6Option> options) {
        this.options = options;
    }

    public Dhcp6IaTaOption() {
    }

    public Dhcp6IaTaOption(Dhcp6Option dhcp6Option) {
        super(dhcp6Option);
    }

    public static Deserializer<Dhcp6Option> deserializer() {
        return (data, offset, length) -> {
            Dhcp6Option dhcp6Option = Dhcp6Option.deserializer().deserialize(data, offset, length);
            if (dhcp6Option.getLength() < 4) {
                throw new DeserializationException("Invalid IA NA option data");
            }
            Dhcp6IaTaOption iaTaOption = new Dhcp6IaTaOption(dhcp6Option);
            byte[] optionData = iaTaOption.getData();
            ByteBuffer bb = ByteBuffer.wrap(optionData);
            iaTaOption.iaId = bb.getInt();
            iaTaOption.options = Lists.newArrayList();
            while (bb.remaining() >= 4) {
                ByteBuffer optByteBuffer = ByteBuffer.wrap(optionData, bb.position(), optionData.length - bb.position());
                short code = optByteBuffer.getShort();
                short len = optByteBuffer.getShort();
                byte[] subOptData = new byte[4 + len];
                bb.get(subOptData);
                Dhcp6Option option = code == DHCP6.OptionCode.IAADDR.value() ? Dhcp6IaAddressOption.deserializer().deserialize(subOptData, 0, subOptData.length) : Dhcp6Option.deserializer().deserialize(subOptData, 0, subOptData.length);
                iaTaOption.options.add(option);
            }
            return iaTaOption;
        };
    }

    @Override
    public byte[] serialize() {
        int payloadLen = 4 + this.options.stream().mapToInt(opt -> opt.getLength()).sum();
        int len = 4 + payloadLen;
        ByteBuffer bb = ByteBuffer.allocate(len);
        bb.putShort(DHCP6.OptionCode.IA_TA.value());
        bb.putShort((short)payloadLen);
        bb.putInt(this.iaId);
        this.options.stream().map(Dhcp6Option::serialize).forEach(bb::put);
        return bb.array();
    }

    @Override
    public int hashCode() {
        return 31 * super.hashCode() + Objects.hash(this.iaId, this.options);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Dhcp6IaTaOption other = (Dhcp6IaTaOption)obj;
        return Objects.equals(this.iaId, other.iaId) && Objects.equals(this.options, other.options);
    }

    @Override
    public String toString() {
        return this.getToStringHelper().add("iaId", this.iaId).add("options", this.options).toString();
    }
}

