/*
 * Decompiled with CFR 0.152.
 */
package org.onlab.packet.dhcp;

import org.onlab.packet.DHCP6;
import org.onlab.packet.Deserializer;
import org.onlab.packet.dhcp.Dhcp6Option;

public final class Dhcp6RelayOption
extends Dhcp6Option {
    @Override
    public short getCode() {
        return DHCP6.OptionCode.RELAY_MSG.value();
    }

    @Override
    public short getLength() {
        return (short)this.payload.serialize().length;
    }

    public Dhcp6RelayOption() {
    }

    public Dhcp6RelayOption(Dhcp6Option dhcp6Option) {
        super(dhcp6Option);
    }

    public static Deserializer<Dhcp6Option> deserializer() {
        return (data, offset, len) -> {
            Dhcp6Option dhcp6Option = Dhcp6Option.deserializer().deserialize(data, offset, len);
            DHCP6 payload = DHCP6.deserializer().deserialize(dhcp6Option.getData(), 0, dhcp6Option.getLength());
            Dhcp6RelayOption relayOption = new Dhcp6RelayOption(dhcp6Option);
            relayOption.setPayload(payload);
            payload.setParent(relayOption);
            return relayOption;
        };
    }
}

