/*
 * Decompiled with CFR 0.152.
 */
package org.onlab.packet.dhcp;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Objects;
import org.onlab.packet.BasePacket;
import org.onlab.packet.DeserializationException;
import org.onlab.packet.Deserializer;
import org.onlab.packet.IPacket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DhcpOption
extends BasePacket {
    public static final int OPT_CODE_LEN = 1;
    public static final int DEFAULT_LEN = 2;
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    protected byte code;
    protected byte length;
    protected byte[] data;

    @Override
    public byte[] serialize() {
        ByteBuffer byteBuffer;
        if (this.data != null) {
            byteBuffer = ByteBuffer.allocate(2 + this.data.length);
            byteBuffer.put(this.code);
            byteBuffer.put(this.length);
            byteBuffer.put(this.data);
        } else {
            byteBuffer = ByteBuffer.allocate(1);
            byteBuffer.put(this.code);
        }
        return byteBuffer.array();
    }

    @Override
    public IPacket deserialize(byte[] data, int offset, int length) {
        try {
            return DhcpOption.deserializer().deserialize(data, offset, length);
        }
        catch (DeserializationException e) {
            this.log.warn("Can't deserialize DhcpOption {}", (Throwable)e);
            return null;
        }
    }

    public static Deserializer<DhcpOption> deserializer() {
        return (data, offset, length) -> {
            DhcpOption dhcpOption = new DhcpOption();
            ByteBuffer byteBuffer = ByteBuffer.wrap(data, offset, length);
            dhcpOption.code = byteBuffer.get();
            if (byteBuffer.hasRemaining()) {
                dhcpOption.length = byteBuffer.get();
                dhcpOption.data = new byte[dhcpOption.length];
                byteBuffer.get(dhcpOption.data);
            } else {
                dhcpOption.length = 0;
                dhcpOption.data = null;
            }
            return dhcpOption;
        };
    }

    public byte getCode() {
        return this.code;
    }

    public DhcpOption setCode(byte code) {
        this.code = code;
        return this;
    }

    public byte getLength() {
        return this.length;
    }

    public DhcpOption setLength(byte length) {
        this.length = length;
        return this;
    }

    public byte[] getData() {
        return this.data;
    }

    public DhcpOption setData(byte[] data) {
        this.data = data;
        return this;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.code, this.length, Arrays.hashCode(this.data));
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DhcpOption)) {
            return false;
        }
        DhcpOption other = (DhcpOption)obj;
        return Objects.equals(this.code, other.code) && Objects.equals(this.length, other.length) && Arrays.equals(this.data, other.data);
    }

    public String toString() {
        return "DhcpOption [code=" + this.code + ", length=" + this.length + ", data=" + Arrays.toString(this.data) + "]";
    }
}

