/*
 * Decompiled with CFR 0.152.
 */
package org.onlab.util;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import org.apache.commons.lang3.ArrayUtils;
import org.onlab.util.HexString;

public final class ImmutableByteSequence {
    private ByteBuffer value;

    private ImmutableByteSequence(ByteBuffer value) {
        this.value = value;
        this.value.rewind();
    }

    public static ImmutableByteSequence copyFrom(byte[] original) {
        Preconditions.checkArgument((original != null && original.length > 0 ? 1 : 0) != 0, (Object)"Cannot copy from an empty or null array");
        return new ImmutableByteSequence(ByteBuffer.allocate(original.length).put(original));
    }

    public static ImmutableByteSequence copyFrom(byte[] original, int fromIdx, int toIdx) {
        Preconditions.checkArgument((original != null && original.length > 0 ? 1 : 0) != 0, (Object)"Cannot copy from an empty or null array");
        Preconditions.checkArgument((toIdx >= fromIdx && toIdx < original.length ? 1 : 0) != 0, (Object)"invalid indexes");
        ByteBuffer buffer = ByteBuffer.allocate(toIdx - fromIdx + 1);
        for (int i = fromIdx; i <= toIdx; ++i) {
            buffer.put(original[i]);
        }
        return new ImmutableByteSequence(buffer);
    }

    public static ImmutableByteSequence copyFrom(ByteBuffer original) {
        Preconditions.checkArgument((original != null && original.capacity() > 0 ? 1 : 0) != 0, (Object)"Cannot copy from an empty or null byte buffer");
        byte[] bytes = new byte[original.capacity()];
        original.rewind();
        original.get(bytes);
        if (original.order() == ByteOrder.LITTLE_ENDIAN) {
            ArrayUtils.reverse((byte[])bytes);
        }
        return new ImmutableByteSequence(ByteBuffer.wrap(bytes));
    }

    public static ImmutableByteSequence copyFrom(long original) {
        return new ImmutableByteSequence(ByteBuffer.allocate(8).putLong(original));
    }

    public static ImmutableByteSequence copyFrom(int original) {
        return new ImmutableByteSequence(ByteBuffer.allocate(4).putInt(original));
    }

    public static ImmutableByteSequence copyFrom(short original) {
        return new ImmutableByteSequence(ByteBuffer.allocate(2).putShort(original));
    }

    public static ImmutableByteSequence copyFrom(byte original) {
        return new ImmutableByteSequence(ByteBuffer.allocate(1).put(original));
    }

    public static ImmutableByteSequence ofZeros(int size) {
        byte[] bytes = new byte[size];
        Arrays.fill(bytes, (byte)0);
        return new ImmutableByteSequence(ByteBuffer.wrap(bytes));
    }

    public static ImmutableByteSequence ofOnes(int size) {
        byte[] bytes = new byte[size];
        Arrays.fill(bytes, (byte)-1);
        return new ImmutableByteSequence(ByteBuffer.wrap(bytes));
    }

    public ByteBuffer asReadOnlyBuffer() {
        return this.value.asReadOnlyBuffer();
    }

    public int size() {
        return this.value.capacity();
    }

    public byte[] asArray() {
        ByteBuffer bb = this.asReadOnlyBuffer();
        byte[] bytes = new byte[this.size()];
        bb.get(bytes);
        return bytes;
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ImmutableByteSequence other = (ImmutableByteSequence)obj;
        return Objects.equal((Object)this.value, (Object)other.value);
    }

    public String toString() {
        return HexString.toHexString(this.value.array());
    }

    public static ImmutableByteSequence fit(ImmutableByteSequence original, int bitWidth) throws ByteSequenceTrimException {
        Preconditions.checkNotNull((Object)original, (Object)"byte sequence cannot be null");
        Preconditions.checkArgument((bitWidth > 0 ? 1 : 0) != 0, (Object)"bit-width must be a non-zero positive integer");
        int newByteWidth = (int)Math.ceil((double)bitWidth / 8.0);
        byte[] originalBytes = original.asArray();
        if (newByteWidth > original.size()) {
            return ImmutableByteSequence.copyFrom(Arrays.copyOf(originalBytes, newByteWidth));
        }
        byte[] newBytes = new byte[newByteWidth];
        int diff = originalBytes.length - newByteWidth;
        for (int i = originalBytes.length - 1; i >= 0; --i) {
            byte nb;
            byte ob = originalBytes[i];
            if (i > diff) {
                nb = ob;
            } else if (i == diff) {
                byte mask = (byte)((1 >> bitWidth % 8 + 1) - 1);
                if ((ob & ~mask) != 0) {
                    throw new ByteSequenceTrimException(originalBytes, bitWidth);
                }
                nb = (byte)(ob & mask);
            } else {
                if (originalBytes[i] == 0) continue;
                throw new ByteSequenceTrimException(originalBytes, bitWidth);
            }
            newBytes[i - diff] = nb;
        }
        return ImmutableByteSequence.copyFrom(newBytes);
    }

    public static class ByteSequenceTrimException
    extends Exception {
        ByteSequenceTrimException(byte[] bytes, int bitWidth) {
            super(String.format("cannot trim %s into a %d long bits value", HexString.toHexString(bytes), bitWidth));
        }
    }
}

