/*
 * Decompiled with CFR 0.152.
 */
package org.onlab.packet.pim;

import com.google.common.base.MoreObjects;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import org.onlab.packet.BasePacket;
import org.onlab.packet.Deserializer;
import org.onlab.packet.IPacket;
import org.onlab.packet.IpAddress;
import org.onlab.packet.PacketUtils;
import org.onlab.packet.pim.PIMHelloOption;

public class PIMHello
extends BasePacket {
    private IpAddress nbrIpAddress;
    private boolean priorityPresent = false;
    private Map<Short, PIMHelloOption> options = new HashMap<Short, PIMHelloOption>();

    public void createDefaultOptions() {
        this.options.put((short)1, new PIMHelloOption(1));
        this.options.put((short)19, new PIMHelloOption(19));
        this.options.put((short)20, new PIMHelloOption(20));
    }

    public void addOption(PIMHelloOption opt) {
        this.options.put(opt.getOptType(), opt);
    }

    public Map<Short, PIMHelloOption> getOptions() {
        return this.options;
    }

    @Override
    public byte[] serialize() {
        int totalLen = 0;
        for (Short optType : this.options.keySet()) {
            PIMHelloOption opt = this.options.get(optType);
            totalLen += 4 + opt.getOptLength();
        }
        byte[] data = new byte[totalLen];
        ByteBuffer bb = ByteBuffer.wrap(data);
        for (Short optType : this.options.keySet()) {
            PIMHelloOption opt = this.options.get(optType);
            bb.put(opt.serialize());
        }
        return data;
    }

    @Override
    public IPacket deserialize(byte[] data, int offset, int length) {
        return null;
    }

    public static Deserializer<PIMHello> deserializer() {
        return (data, offset, length) -> {
            PacketUtils.checkInput(data, offset, length, 4);
            ByteBuffer bb = ByteBuffer.wrap(data, offset, length);
            PIMHello hello = new PIMHello();
            while (bb.hasRemaining()) {
                PIMHelloOption opt = PIMHelloOption.deserialize(bb);
                hello.addOption(opt);
            }
            return hello;
        };
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("nbrIpAddress", (Object)this.nbrIpAddress.toString()).add("priorityPresent", (Object)Boolean.toString(this.priorityPresent)).toString();
    }
}

