/*
 * Decompiled with CFR 0.152.
 */
package org.onlab.util;

import com.google.common.testing.EqualsTester;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Random;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.onlab.util.ImmutableByteSequence;

public class ImmutableByteSequenceTest {
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Test
    public void testCopy() throws Exception {
        byte byteValue = 1;
        short shortValue = byteValue;
        byte intValue = byteValue;
        long longValue = byteValue;
        byte[] arrayValue = new byte[64];
        arrayValue[63] = byteValue;
        ByteBuffer bufferValue = ByteBuffer.allocate(64).put(arrayValue);
        ImmutableByteSequence bsByte = ImmutableByteSequence.copyFrom((byte)byteValue);
        ImmutableByteSequence bsShort = ImmutableByteSequence.copyFrom((short)shortValue);
        ImmutableByteSequence bsInt = ImmutableByteSequence.copyFrom((int)intValue);
        ImmutableByteSequence bsLong = ImmutableByteSequence.copyFrom((long)longValue);
        ImmutableByteSequence bsArray = ImmutableByteSequence.copyFrom((byte[])arrayValue);
        ImmutableByteSequence bsBuffer = ImmutableByteSequence.copyFrom((ByteBuffer)bufferValue);
        MatcherAssert.assertThat((String)"byte sequence of a byte value must have size 1", (Object)bsByte.size(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)1)));
        MatcherAssert.assertThat((String)"byte sequence of a short value must have size 2", (Object)bsShort.size(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)2)));
        MatcherAssert.assertThat((String)"byte sequence of an int value must have size 4", (Object)bsInt.size(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)4)));
        MatcherAssert.assertThat((String)"byte sequence of a long value must have size 8", (Object)bsLong.size(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)8)));
        MatcherAssert.assertThat((String)"byte sequence of a byte array value must have same size of the array", (Object)bsArray.size(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)arrayValue.length)));
        MatcherAssert.assertThat((String)"byte sequence of a byte buffer value must have same size of the buffer", (Object)bsBuffer.size(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)bufferValue.capacity())));
        String errStr = "incorrect byte sequence value";
        MatcherAssert.assertThat((String)errStr, (Object)bsByte.asArray()[0], (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)byteValue)));
        MatcherAssert.assertThat((String)errStr, (Object)bsShort.asArray()[1], (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)byteValue)));
        MatcherAssert.assertThat((String)errStr, (Object)bsInt.asArray()[3], (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)byteValue)));
        MatcherAssert.assertThat((String)errStr, (Object)bsLong.asArray()[7], (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)byteValue)));
        MatcherAssert.assertThat((String)errStr, (Object)bsArray.asArray()[63], (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)byteValue)));
        MatcherAssert.assertThat((String)errStr, (Object)bsBuffer.asArray()[63], (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)byteValue)));
    }

    @Test
    public void testEndianness() throws Exception {
        long longValue = new Random().nextLong();
        ByteBuffer bbBigEndian = ByteBuffer.allocate(8).order(ByteOrder.BIG_ENDIAN).putLong(longValue);
        ImmutableByteSequence bsBufferCopyBigEndian = ImmutableByteSequence.copyFrom((ByteBuffer)bbBigEndian);
        ByteBuffer bbLittleEndian = ByteBuffer.allocate(8).order(ByteOrder.LITTLE_ENDIAN).putLong(longValue);
        ImmutableByteSequence bsBufferCopyLittleEndian = ImmutableByteSequence.copyFrom((ByteBuffer)bbLittleEndian);
        ImmutableByteSequence bsLongCopy = ImmutableByteSequence.copyFrom((long)longValue);
        new EqualsTester().addEqualityGroup(new Object[]{bbBigEndian.array()}).addEqualityGroup(new Object[]{bbLittleEndian.array()}).addEqualityGroup(new Object[]{bsBufferCopyBigEndian, bsBufferCopyLittleEndian, bsLongCopy}).addEqualityGroup(new Object[]{bsBufferCopyBigEndian.asReadOnlyBuffer(), bsBufferCopyLittleEndian.asReadOnlyBuffer(), bsLongCopy.asReadOnlyBuffer()}).addEqualityGroup(new Object[]{bsBufferCopyBigEndian.asReadOnlyBuffer().order(), bsBufferCopyLittleEndian.asReadOnlyBuffer().order(), bsLongCopy.asReadOnlyBuffer().order(), ByteOrder.BIG_ENDIAN}).testEquals();
    }

    @Test
    public void testBitSetMethods() throws Exception {
        MatcherAssert.assertThat((String)"3 bytes, all 0's", (Object)ImmutableByteSequence.ofZeros((int)3), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)ImmutableByteSequence.copyFrom((byte[])new byte[]{0, 0, 0}))));
        MatcherAssert.assertThat((String)"3 bytes, all 0's via prefix", (Object)ImmutableByteSequence.prefixZeros((int)3, (long)24L), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)ImmutableByteSequence.copyFrom((byte[])new byte[]{0, 0, 0}))));
        MatcherAssert.assertThat((String)"3 bytes, all 1's", (Object)ImmutableByteSequence.ofZeros((int)3), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)ImmutableByteSequence.copyFrom((byte[])new byte[]{0, 0, 0}))));
        MatcherAssert.assertThat((String)"3 bytes, all 1's via prefix", (Object)ImmutableByteSequence.prefixOnes((int)3, (long)24L), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)ImmutableByteSequence.copyFrom((byte[])new byte[]{-1, -1, -1}))));
        MatcherAssert.assertThat((String)"2 bytes, prefixed with 5 0's", (Object)ImmutableByteSequence.prefix((int)2, (long)5L, (byte)0), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)ImmutableByteSequence.copyFrom((byte[])new byte[]{7, -1}))));
        MatcherAssert.assertThat((String)"4 bytes, prefixed with 16 0's", (Object)ImmutableByteSequence.prefix((int)4, (long)16L, (byte)0), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)ImmutableByteSequence.copyFrom((byte[])new byte[]{0, 0, -1, -1}))));
        MatcherAssert.assertThat((String)"4 bytes, prefixed with 20 0's", (Object)ImmutableByteSequence.prefix((int)4, (long)20L, (byte)0), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)ImmutableByteSequence.copyFrom((byte[])new byte[]{0, 0, 15, -1}))));
        MatcherAssert.assertThat((String)"8 bytes, prefixed with 36 0's", (Object)ImmutableByteSequence.prefixZeros((int)8, (long)38L), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)ImmutableByteSequence.copyFrom((byte[])new byte[]{0, 0, 0, 0, 3, -1, -1, -1}))));
        MatcherAssert.assertThat((String)"2 bytes, prefixed with 5 1's", (Object)ImmutableByteSequence.prefix((int)2, (long)5L, (byte)-1), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)ImmutableByteSequence.copyFrom((byte[])new byte[]{-8, 0}))));
        MatcherAssert.assertThat((String)"4 bytes, prefixed with 16 1's", (Object)ImmutableByteSequence.prefix((int)4, (long)16L, (byte)-1), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)ImmutableByteSequence.copyFrom((byte[])new byte[]{-1, -1, 0, 0}))));
        MatcherAssert.assertThat((String)"4 bytes, prefixed with 20 1's", (Object)ImmutableByteSequence.prefix((int)4, (long)20L, (byte)-1), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)ImmutableByteSequence.copyFrom((byte[])new byte[]{-1, -1, -16, 0}))));
        MatcherAssert.assertThat((String)"8 bytes, prefixed with 10 1's", (Object)ImmutableByteSequence.prefixOnes((int)8, (long)10L), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)ImmutableByteSequence.copyFrom((byte[])new byte[]{-1, -64, 0, 0, 0, 0, 0, 0}))));
    }

    @Test
    public void testBadPrefixVal() {
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.reportMissingExceptionWithMessage("Expect IllegalArgumentException due to val = 0x7");
        ImmutableByteSequence.prefix((int)5, (long)10L, (byte)7);
    }
}

