/*
 * Decompiled with CFR 0.152.
 */
package org.onlab.util;

import com.google.common.base.MoreObjects;
import java.util.Arrays;
import java.util.Objects;
import java.util.function.Function;

public final class Match<T> {
    public static final Match ANY = new Match();
    public static final Match NULL = new Match<Object>(null, false);
    public static final Match NOT_NULL = new Match<Object>(null, true);
    private final boolean matchAny;
    private final T value;
    private final boolean negation;

    public static <T> Match<T> any() {
        return ANY;
    }

    public static <T> Match<T> ifNull() {
        return NULL;
    }

    public static <T> Match<T> ifNotNull() {
        return NOT_NULL;
    }

    public static <T> Match<T> ifValue(T value) {
        return new Match<T>(value, false);
    }

    public static <T> Match<T> ifNotValue(T value) {
        return new Match<T>(value, true);
    }

    private Match() {
        this.matchAny = true;
        this.negation = false;
        this.value = null;
    }

    private Match(T value, boolean negation) {
        this.matchAny = false;
        this.value = value;
        this.negation = negation;
    }

    public <V> Match<V> map(Function<T, V> mapper) {
        if (this.matchAny) {
            return Match.any();
        }
        if (this.value == null) {
            return this.negation ? Match.ifNotNull() : Match.ifNull();
        }
        return this.negation ? Match.ifNotValue(mapper.apply(this.value)) : Match.ifValue(mapper.apply(this.value));
    }

    public boolean matches(T other) {
        if (this.matchAny) {
            return true;
        }
        if (other == null) {
            return this.negation ? this.value != null : this.value == null;
        }
        if (this.value instanceof byte[]) {
            boolean equal = Arrays.equals((byte[])this.value, (byte[])other);
            return this.negation ? !equal : equal;
        }
        return this.negation ? !Objects.equals(this.value, other) : Objects.equals(this.value, other);
    }

    public int hashCode() {
        return Objects.hash(this.matchAny, this.value, this.negation);
    }

    public boolean equals(Object other) {
        if (!(other instanceof Match)) {
            return false;
        }
        Match that = (Match)other;
        return this.matchAny == that.matchAny && Objects.equals(this.value, that.value) && this.negation == that.negation;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("matchAny", this.matchAny).add("negation", this.negation).add("value", this.value).toString();
    }
}

