/*
 * Decompiled with CFR 0.152.
 */
package org.onlab.packet.dhcp;

import com.google.common.base.MoreObjects;
import java.nio.ByteBuffer;
import org.onlab.packet.DHCP6;
import org.onlab.packet.DeserializationException;
import org.onlab.packet.Deserializer;
import org.onlab.packet.MacAddress;
import org.onlab.packet.dhcp.Dhcp6Option;

public final class Dhcp6InterfaceIdOption
extends Dhcp6Option {
    private MacAddress peerMacAddr;
    private byte[] inPort;

    @Override
    public short getCode() {
        return DHCP6.OptionCode.INTERFACE_ID.value();
    }

    @Override
    public short getLength() {
        return (short)this.payload.serialize().length;
    }

    @Override
    public byte[] getData() {
        return this.payload.serialize();
    }

    public Dhcp6InterfaceIdOption() {
    }

    public Dhcp6InterfaceIdOption(Dhcp6Option dhcp6Option) {
        super(dhcp6Option);
    }

    public void setMacAddress(MacAddress macAddress) {
        this.peerMacAddr = macAddress;
    }

    public MacAddress getMacAddress() {
        return this.peerMacAddr;
    }

    public void setInPort(byte[] port) {
        this.inPort = port;
    }

    public byte[] getInPort() {
        return this.inPort;
    }

    public static Deserializer<Dhcp6Option> deserializer() {
        return (data, offset, len) -> {
            Dhcp6Option dhcp6Option = Dhcp6Option.deserializer().deserialize(data, offset, len);
            if (dhcp6Option.getLength() < 4) {
                throw new DeserializationException("Invalid InterfaceIoption data");
            }
            Dhcp6InterfaceIdOption interfaceIdOption = new Dhcp6InterfaceIdOption(dhcp6Option);
            byte[] optionData = interfaceIdOption.getData();
            if (optionData.length >= 28) {
                ByteBuffer bb = ByteBuffer.wrap(optionData);
                byte[] macAddr = new byte[6];
                byte[] port = new byte[21];
                bb.get(macAddr);
                bb.get();
                bb.get(port);
                interfaceIdOption.setMacAddress(MacAddress.valueOf(macAddr));
                interfaceIdOption.setInPort(port);
            }
            return interfaceIdOption;
        };
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("code", (int)this.getCode()).add("length", (int)this.getLength()).add("data", (Object)this.payload.toString()).toString();
    }
}

