/*
 * Decompiled with CFR 0.152.
 */
package org.onlab.packet.dhcp;

import com.google.common.base.MoreObjects;
import java.nio.ByteBuffer;
import org.onlab.packet.DHCP6;
import org.onlab.packet.DeserializationException;
import org.onlab.packet.Deserializer;
import org.onlab.packet.dhcp.Dhcp6Duid;
import org.onlab.packet.dhcp.Dhcp6Option;

public final class Dhcp6ClientIdOption
extends Dhcp6Option {
    @Override
    public short getCode() {
        return DHCP6.OptionCode.CLIENTID.value();
    }

    @Override
    public short getLength() {
        return (short)this.payload.serialize().length;
    }

    @Override
    public byte[] getData() {
        return this.payload.serialize();
    }

    @Override
    public void setData(byte[] data) {
        try {
            Dhcp6Duid duid = Dhcp6Duid.deserializer().deserialize(data, 0, data.length);
            this.setDuid(duid);
        }
        catch (DeserializationException e) {
            throw new RuntimeException("Invalid DUID");
        }
    }

    public Dhcp6Duid getDuid() {
        return (Dhcp6Duid)this.payload;
    }

    public void setDuid(Dhcp6Duid duid) {
        this.setPayload(duid);
        duid.setParent(this);
    }

    public static Deserializer<Dhcp6Option> deserializer() {
        return (data, offset, length) -> {
            Dhcp6Option dhcp6Option = Dhcp6Option.deserializer().deserialize(data, offset, length);
            Dhcp6ClientIdOption clientIdentifier = new Dhcp6ClientIdOption();
            if (dhcp6Option.getLength() < 4) {
                throw new DeserializationException("Invalid length of Client Id option");
            }
            Dhcp6Duid duid = Dhcp6Duid.deserializer().deserialize(dhcp6Option.getData(), 0, dhcp6Option.getLength());
            clientIdentifier.setPayload(duid);
            return clientIdentifier;
        };
    }

    @Override
    public byte[] serialize() {
        ByteBuffer bb = ByteBuffer.allocate(this.getLength() + 4);
        bb.putShort(this.getCode());
        bb.putShort(this.getLength());
        bb.put(this.payload.serialize());
        return bb.array();
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("code", (int)this.getCode()).add("length", (int)this.getLength()).add("duid", (Object)this.getDuid().toString()).toString();
    }
}

