/*
 * Decompiled with CFR 0.152.
 */
package org.onlab.graph;

import com.google.common.collect.ImmutableSet;
import java.text.DecimalFormat;
import java.util.HashSet;
import java.util.NoSuchElementException;
import java.util.Set;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.onlab.graph.AbstractGraphPathSearch;
import org.onlab.graph.AdjacencyListsGraph;
import org.onlab.graph.BreadthFirstSearchTest;
import org.onlab.graph.DijkstraGraphSearch;
import org.onlab.graph.EdgeWeigher;
import org.onlab.graph.Graph;
import org.onlab.graph.GraphPathSearch;
import org.onlab.graph.Path;
import org.onlab.graph.ScalarWeight;
import org.onlab.graph.TestDoubleWeight;
import org.onlab.graph.TestEdge;
import org.onlab.graph.TestVertex;
import org.onlab.graph.Vertex;
import org.onlab.graph.Weight;

public class DijkstraGraphSearchTest
extends BreadthFirstSearchTest {
    @Rule
    public final ExpectedException exception = ExpectedException.none();

    @Override
    protected AbstractGraphPathSearch<TestVertex, TestEdge> graphSearch() {
        return new DijkstraGraphSearch();
    }

    @Override
    @Test
    public void defaultGraphTest() {
        this.executeDefaultTest(7, 5, new TestDoubleWeight(5.0));
    }

    @Override
    @Test
    public void defaultHopCountWeight() {
        this.weigher = null;
        this.executeDefaultTest(10, 3, (Weight)new ScalarWeight(3.0));
    }

    @Test
    public void noPath() {
        this.graph = new AdjacencyListsGraph((Set)ImmutableSet.of((Object)A, (Object)B, (Object)C, (Object)D), (Set)ImmutableSet.of((Object)((Object)new TestEdge(A, B, W1)), (Object)((Object)new TestEdge(B, A, W1)), (Object)((Object)new TestEdge(C, D, W1)), (Object)((Object)new TestEdge(D, C, W1))));
        AbstractGraphPathSearch<TestVertex, TestEdge> gs = this.graphSearch();
        Set paths = gs.search(this.graph, (Vertex)A, (Vertex)B, this.weigher, 1).paths();
        this.printPaths(paths);
        Assert.assertEquals((String)"incorrect paths count", (long)1L, (long)paths.size());
        Assert.assertEquals((String)"incorrect path cost", (Object)new TestDoubleWeight(1.0), (Object)((Path)paths.iterator().next()).cost());
        paths = gs.search(this.graph, (Vertex)A, (Vertex)D, this.weigher, 1).paths();
        this.printPaths(paths);
        Assert.assertEquals((String)"incorrect paths count", (long)0L, (long)paths.size());
        paths = gs.search(this.graph, (Vertex)A, null, this.weigher, 1).paths();
        this.printPaths(paths);
        Assert.assertEquals((String)"incorrect paths count", (long)1L, (long)paths.size());
        Assert.assertEquals((String)"incorrect path cost", (Object)new TestDoubleWeight(1.0), (Object)((Path)paths.iterator().next()).cost());
    }

    @Test
    public void exceptions() {
        this.graph = new AdjacencyListsGraph((Set)ImmutableSet.of((Object)A, (Object)B, (Object)C, (Object)D), (Set)ImmutableSet.of((Object)((Object)new TestEdge(A, B, W2)), (Object)((Object)new TestEdge(B, A, W1)), (Object)((Object)new TestEdge(A, A, W3)), (Object)((Object)new TestEdge(A, C, NW1)), (Object)((Object)new TestEdge(C, D, W3))));
        AbstractGraphPathSearch<TestVertex, TestEdge> gs = this.graphSearch();
        Set paths = gs.search(this.graph, (Vertex)A, (Vertex)D, this.weigher, -1).paths();
        this.printPaths(paths);
        Assert.assertEquals((String)"Incorrect path count", (long)0L, (long)paths.size());
        paths = gs.search(this.graph, (Vertex)A, (Vertex)A, this.weigher, 5).paths();
        this.exception.expect(NoSuchElementException.class);
        ((Path)paths.iterator().next()).cost();
    }

    @Test
    public void noEdges() {
        this.graph = new AdjacencyListsGraph(this.vertexes(), (Set)ImmutableSet.of());
        for (TestVertex v : this.vertexes()) {
            this.executeSearch((GraphPathSearch<TestVertex, TestEdge>)this.graphSearch(), (Graph<TestVertex, TestEdge>)this.graph, v, null, (EdgeWeigher<TestVertex, TestEdge>)this.weigher, 0, new TestDoubleWeight(0.0));
        }
    }

    @Test
    public void simpleMultiplePath() {
        this.graph = new AdjacencyListsGraph((Set)ImmutableSet.of((Object)A, (Object)B, (Object)C, (Object)D), (Set)ImmutableSet.of((Object)((Object)new TestEdge(A, B, W1)), (Object)((Object)new TestEdge(A, C, W1)), (Object)((Object)new TestEdge(B, D, W1)), (Object)((Object)new TestEdge(C, D, W1)), (Object)((Object)new TestEdge(D, E, W1)), (Object)((Object)new TestEdge(A, E, ZW)), (Object[])new TestEdge[]{new TestEdge(E, F, NW1), new TestEdge(F, B, ZW)}));
        this.executeSearch((GraphPathSearch<TestVertex, TestEdge>)this.graphSearch(), (Graph<TestVertex, TestEdge>)this.graph, A, D, (EdgeWeigher<TestVertex, TestEdge>)this.weigher, 2, W2);
        this.executeSinglePathSearch((GraphPathSearch<TestVertex, TestEdge>)this.graphSearch(), (Graph<TestVertex, TestEdge>)this.graph, A, D, (EdgeWeigher<TestVertex, TestEdge>)this.weigher, 1, W2);
        this.executeSearch((GraphPathSearch<TestVertex, TestEdge>)this.graphSearch(), (Graph<TestVertex, TestEdge>)this.graph, A, B, (EdgeWeigher<TestVertex, TestEdge>)this.weigher, 1, W1);
        this.executeSearch((GraphPathSearch<TestVertex, TestEdge>)this.graphSearch(), (Graph<TestVertex, TestEdge>)this.graph, D, A, (EdgeWeigher<TestVertex, TestEdge>)this.weigher, 0, null);
    }

    @Test
    public void manualDoubleWeights() {
        this.graph = new AdjacencyListsGraph((Set)ImmutableSet.of((Object)A, (Object)B, (Object)C, (Object)D, (Object)E), (Set)ImmutableSet.of((Object)((Object)new TestEdge(A, B, new TestDoubleWeight(1.5))), (Object)((Object)new TestEdge(B, D, new TestDoubleWeight(3.5))), (Object)((Object)new TestEdge(A, C, new TestDoubleWeight(2.2))), (Object)((Object)new TestEdge(C, E, new TestDoubleWeight(1.1))), (Object)((Object)new TestEdge(E, D, new TestDoubleWeight(1.7))), (Object)((Object)new TestEdge(A, D, new TestDoubleWeight(5.0))), (Object[])new TestEdge[0]));
        this.executeSearch((GraphPathSearch<TestVertex, TestEdge>)this.graphSearch(), (Graph<TestVertex, TestEdge>)this.graph, A, D, (EdgeWeigher<TestVertex, TestEdge>)this.weigher, 3, new TestDoubleWeight(5.0));
        this.executeSinglePathSearch((GraphPathSearch<TestVertex, TestEdge>)this.graphSearch(), (Graph<TestVertex, TestEdge>)this.graph, A, D, (EdgeWeigher<TestVertex, TestEdge>)this.weigher, 1, W5);
    }

    @Test
    public void denseMultiplePath() {
        this.graph = new AdjacencyListsGraph((Set)ImmutableSet.of((Object)A, (Object)B, (Object)C, (Object)D, (Object)E, (Object)F, (Object[])new TestVertex[]{G}), (Set)ImmutableSet.of((Object)((Object)new TestEdge(A, B, W1)), (Object)((Object)new TestEdge(A, C, W1)), (Object)((Object)new TestEdge(B, D, W1)), (Object)((Object)new TestEdge(C, D, W1)), (Object)((Object)new TestEdge(D, E, W1)), (Object)((Object)new TestEdge(D, F, W1)), (Object[])new TestEdge[]{new TestEdge(E, G, W1), new TestEdge(F, G, W1), new TestEdge(A, G, W4)}));
        this.executeSearch((GraphPathSearch<TestVertex, TestEdge>)this.graphSearch(), (Graph<TestVertex, TestEdge>)this.graph, A, G, (EdgeWeigher<TestVertex, TestEdge>)this.weigher, 5, W4);
        this.executeSinglePathSearch((GraphPathSearch<TestVertex, TestEdge>)this.graphSearch(), (Graph<TestVertex, TestEdge>)this.graph, A, G, (EdgeWeigher<TestVertex, TestEdge>)this.weigher, 1, W4);
    }

    @Test
    public void dualEdgeMultiplePath() {
        this.graph = new AdjacencyListsGraph((Set)ImmutableSet.of((Object)A, (Object)B, (Object)C, (Object)D, (Object)E, (Object)F, (Object[])new TestVertex[]{G, H}), (Set)ImmutableSet.of((Object)((Object)new TestEdge(A, B, W1)), (Object)((Object)new TestEdge(A, C, W3)), (Object)((Object)new TestEdge(B, D, W2)), (Object)((Object)new TestEdge(B, C, W1)), (Object)((Object)new TestEdge(B, E, W4)), (Object)((Object)new TestEdge(C, E, W1)), (Object[])new TestEdge[]{new TestEdge(D, H, W5), new TestEdge(D, E, W1), new TestEdge(E, F, W1), new TestEdge(F, D, W1), new TestEdge(F, G, W1), new TestEdge(F, H, W1), new TestEdge(A, E, W3), new TestEdge(B, D, W1)}));
        this.executeSearch((GraphPathSearch<TestVertex, TestEdge>)this.graphSearch(), (Graph<TestVertex, TestEdge>)this.graph, A, E, (EdgeWeigher<TestVertex, TestEdge>)this.weigher, 3, W3);
        this.executeSinglePathSearch((GraphPathSearch<TestVertex, TestEdge>)this.graphSearch(), (Graph<TestVertex, TestEdge>)this.graph, A, E, (EdgeWeigher<TestVertex, TestEdge>)this.weigher, 1, W3);
        AbstractGraphPathSearch<TestVertex, TestEdge> gs = this.graphSearch();
        Set pathF = gs.search(this.graph, (Vertex)A, (Vertex)F, this.weigher, -1).paths();
        Set pathE = gs.search(this.graph, (Vertex)A, (Vertex)E, this.weigher, -1).paths();
        Assert.assertEquals((long)0L, (long)(pathF.size() - pathE.size()));
        Assert.assertEquals((Object)new TestDoubleWeight(1.0), (Object)((Path)pathF.iterator().next()).cost().subtract(((Path)pathE.iterator().next()).cost()));
    }

    @Test
    public void negativeWeights() {
        this.graph = new AdjacencyListsGraph((Set)ImmutableSet.of((Object)A, (Object)B, (Object)C, (Object)D, (Object)E, (Object)F, (Object[])new TestVertex[]{G}), (Set)ImmutableSet.of((Object)((Object)new TestEdge(A, B, W1)), (Object)((Object)new TestEdge(A, C, NW1)), (Object)((Object)new TestEdge(B, D, W1)), (Object)((Object)new TestEdge(D, A, NW2)), (Object)((Object)new TestEdge(C, D, W1)), (Object)((Object)new TestEdge(D, E, W1)), (Object[])new TestEdge[]{new TestEdge(D, F, W1), new TestEdge(E, G, W1), new TestEdge(F, G, W1), new TestEdge(G, A, NW5), new TestEdge(A, G, W4)}));
        this.executeSearch((GraphPathSearch<TestVertex, TestEdge>)this.graphSearch(), (Graph<TestVertex, TestEdge>)this.graph, A, G, (EdgeWeigher<TestVertex, TestEdge>)this.weigher, 3, new TestDoubleWeight(4.0));
        this.executeSinglePathSearch((GraphPathSearch<TestVertex, TestEdge>)this.graphSearch(), (Graph<TestVertex, TestEdge>)this.graph, A, G, (EdgeWeigher<TestVertex, TestEdge>)this.weigher, 1, new TestDoubleWeight(4.0));
    }

    @Test
    public void disconnected() {
        HashSet<TestVertex> vertexes = new HashSet<TestVertex>();
        for (int i = 0; i < 200; ++i) {
            vertexes.add(new TestVertex("v" + i));
        }
        this.graph = new AdjacencyListsGraph(vertexes, (Set)ImmutableSet.of());
        long start = System.nanoTime();
        for (TestVertex src : vertexes) {
            this.executeSearch((GraphPathSearch<TestVertex, TestEdge>)this.graphSearch(), (Graph<TestVertex, TestEdge>)this.graph, src, null, null, 0, new TestDoubleWeight(0.0));
        }
        long end = System.nanoTime();
        DecimalFormat fmt = new DecimalFormat("#,###");
        System.out.println("Compute cost is " + fmt.format(end - start) + " nanos");
    }
}

