/*
 * Decompiled with CFR 0.152.
 */
package org.onlab.packet;

import java.nio.ByteBuffer;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.onlab.packet.Deserializer;
import org.onlab.packet.MPLS;
import org.onlab.packet.PacketTestUtils;

public class MplsTest {
    private Deserializer<MPLS> deserializer;
    private int label = 1048575;
    private byte bos = 1;
    private byte ttl = (byte)20;
    private byte protocol = 1;
    private byte[] bytes;

    @Before
    public void setUp() throws Exception {
        MPLS.protocolDeserializerMap = new HashMap();
        this.deserializer = MPLS.deserializer();
        ByteBuffer bb = ByteBuffer.allocate(4);
        bb.putInt((this.label & 0xFFFFF) << 12 | ((this.bos & 1) << 8 | this.ttl & 0xFF));
        this.bytes = bb.array();
    }

    @Test
    public void testDeserializeBadInput() throws Exception {
        PacketTestUtils.testDeserializeBadInput(this.deserializer);
    }

    @Test
    public void testDeserializeTruncated() throws Exception {
        PacketTestUtils.testDeserializeTruncated(this.deserializer, this.bytes);
    }

    @Test
    public void testDeserialize() throws Exception {
        MPLS mpls = (MPLS)this.deserializer.deserialize(this.bytes, 0, this.bytes.length);
        Assert.assertEquals((long)this.label, (long)mpls.label);
        Assert.assertEquals((long)this.bos, (long)mpls.bos);
        Assert.assertEquals((long)this.ttl, (long)mpls.ttl);
        Assert.assertEquals((long)this.protocol, (long)mpls.protocol);
    }

    @Test
    public void testToStringMpls() throws Exception {
        MPLS mpls = (MPLS)this.deserializer.deserialize(this.bytes, 0, this.bytes.length);
        String str = mpls.toString();
        Assert.assertTrue((boolean)StringUtils.contains((CharSequence)str, (CharSequence)("label=" + this.label)));
        Assert.assertTrue((boolean)StringUtils.contains((CharSequence)str, (CharSequence)("bos=" + this.bos)));
        Assert.assertTrue((boolean)StringUtils.contains((CharSequence)str, (CharSequence)("ttl=" + this.ttl)));
        Assert.assertTrue((boolean)StringUtils.contains((CharSequence)str, (CharSequence)("protocol=" + this.protocol)));
    }
}

