/*
 * Decompiled with CFR 0.152.
 */
package org.onlab.packet.pim;

import com.google.common.base.MoreObjects;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.HashMap;
import org.onlab.packet.BasePacket;
import org.onlab.packet.Deserializer;
import org.onlab.packet.IPacket;
import org.onlab.packet.IpPrefix;
import org.onlab.packet.PacketUtils;
import org.onlab.packet.pim.PIMAddrGroup;
import org.onlab.packet.pim.PIMAddrSource;
import org.onlab.packet.pim.PIMAddrUnicast;
import org.onlab.packet.pim.PIMJoinPruneGroup;

public class PIMJoinPrune
extends BasePacket {
    private PIMAddrUnicast upstreamAddr = new PIMAddrUnicast();
    private short holdTime = (short)-1;
    private HashMap<IpPrefix, PIMJoinPruneGroup> joinPrunes = new HashMap();

    public short getHoldTime() {
        return this.holdTime;
    }

    public void setHoldTime(short holdTime) {
        this.holdTime = holdTime;
    }

    public PIMAddrUnicast getUpstreamAddr() {
        return this.upstreamAddr;
    }

    public void setUpstreamAddr(PIMAddrUnicast upstr) {
        this.upstreamAddr = upstr;
    }

    public Collection<PIMJoinPruneGroup> getJoinPrunes() {
        return this.joinPrunes.values();
    }

    public void addJoinPrune(String saddr, String gaddr, boolean join) {
        IpPrefix gpfx = IpPrefix.valueOf(gaddr);
        IpPrefix spfx = IpPrefix.valueOf(saddr);
        this.addJoinPrune(spfx, gpfx, join);
    }

    public void addJoinPrune(IpPrefix spfx, IpPrefix gpfx, boolean join) {
        HashMap<IpPrefix, IpPrefix> members;
        PIMJoinPruneGroup jpg = this.joinPrunes.get(gpfx);
        if (jpg == null) {
            jpg = new PIMJoinPruneGroup(gpfx);
            this.joinPrunes.put(gpfx, jpg);
        }
        HashMap<IpPrefix, IpPrefix> hashMap = members = join ? jpg.getJoins() : jpg.getPrunes();
        if (members.get(spfx) == null) {
            members.put(spfx, spfx);
        }
    }

    public void addJoin(String saddr, String gaddr) {
        this.addJoinPrune(saddr, gaddr, true);
    }

    public void addPrune(String saddr, String gaddr) {
        this.addJoinPrune(saddr, gaddr, false);
    }

    @Override
    public byte[] serialize() {
        byte[] data = new byte[8096];
        ByteBuffer bb = ByteBuffer.wrap(data);
        bb.put(this.upstreamAddr.serialize());
        bb.put((byte)0);
        int ngrps = this.joinPrunes.size();
        bb.put((byte)ngrps);
        bb.putShort(this.holdTime);
        for (PIMJoinPruneGroup jpg : this.joinPrunes.values()) {
            PIMAddrSource src;
            PIMAddrGroup grp = new PIMAddrGroup(jpg.getGroup());
            bb.put(grp.serialize());
            bb.putShort((short)jpg.getJoins().size());
            bb.putShort((short)jpg.getPrunes().size());
            for (IpPrefix spfx : jpg.getJoins().values()) {
                src = new PIMAddrSource(spfx);
                bb.put(src.serialize());
            }
            for (IpPrefix spfx : jpg.getPrunes().values()) {
                src = new PIMAddrSource(spfx);
                bb.put(src.serialize());
            }
        }
        int len = bb.position();
        byte[] data2 = new byte[len];
        bb = ByteBuffer.wrap(data2, 0, len);
        bb.put(data, 0, len);
        return data2;
    }

    @Override
    public IPacket deserialize(byte[] data, int offset, int length) {
        ByteBuffer bb = ByteBuffer.wrap(data, offset, length);
        return this;
    }

    public static Deserializer<PIMJoinPrune> deserializer() {
        return (data, offset, length) -> {
            PIMJoinPrune jp = new PIMJoinPrune();
            ByteBuffer bb = ByteBuffer.wrap(data, offset, length);
            PIMAddrUnicast upstream = new PIMAddrUnicast();
            upstream.deserialize(bb);
            jp.setUpstreamAddr(upstream);
            boolean ipv4 = upstream.getAddr().isIp4();
            PacketUtils.checkInput(bb.array(), bb.position(), bb.limit() - bb.position(), 4);
            bb.get();
            int ngroups = bb.get();
            jp.setHoldTime(bb.getShort());
            for (int i = 0; i < ngroups; ++i) {
                PIMAddrSource src;
                int njoins;
                PIMAddrGroup grp = new PIMAddrGroup();
                grp.deserialize(bb);
                PacketUtils.checkInput(bb.array(), bb.position(), bb.limit() - bb.position(), 4);
                int nprunes = bb.getShort();
                int required = (njoins + nprunes) * (ipv4 ? 8 : 20);
                PacketUtils.checkInput(bb.array(), bb.position(), bb.limit() - bb.position(), required);
                for (njoins = bb.getShort(); njoins > 0; --njoins) {
                    src = new PIMAddrSource();
                    src.deserialize(bb);
                    jp.addJoinPrune(src.getAddr().toIpPrefix(), grp.getAddr().toIpPrefix(), true);
                }
                while (nprunes > 0) {
                    src = new PIMAddrSource();
                    src.deserialize(bb);
                    jp.addJoinPrune(src.getAddr().toIpPrefix(), grp.getAddr().toIpPrefix(), false);
                    --nprunes;
                }
            }
            return jp;
        };
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("upstreamAddr", (Object)this.upstreamAddr.toString()).add("holdTime", (Object)Short.toString(this.holdTime)).toString();
    }
}

