/*
 * Decompiled with CFR 0.152.
 */
package org.onlab.graph;

import com.google.common.collect.ImmutableList;
import com.google.common.testing.EqualsTester;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.onlab.graph.DefaultPath;
import org.onlab.graph.GraphTest;
import org.onlab.graph.Path;
import org.onlab.graph.TestDoubleWeight;
import org.onlab.graph.TestEdge;
import org.onlab.graph.TestVertex;
import org.onlab.graph.Weight;

public class DefaultPathTest
extends GraphTest {
    @Test
    public void equality() {
        ImmutableList edges = ImmutableList.of((Object)((Object)new TestEdge(A, B)), (Object)((Object)new TestEdge(B, C)));
        new EqualsTester().addEqualityGroup(new Object[]{new DefaultPath((List)edges, (Weight)new TestDoubleWeight(2.0)), new DefaultPath((List)edges, (Weight)new TestDoubleWeight(2.0))}).addEqualityGroup(new Object[]{new DefaultPath((List)edges, (Weight)new TestDoubleWeight(3.0))}).testEquals();
    }

    @Test
    public void basics() {
        DefaultPath p = new DefaultPath((List)ImmutableList.of((Object)((Object)new TestEdge(A, B)), (Object)((Object)new TestEdge(B, C))), (Weight)new TestDoubleWeight(2.0));
        this.validatePath((Path<TestVertex, TestEdge>)p, A, C, 2, new TestDoubleWeight(2.0));
    }

    protected void validatePath(Path<TestVertex, TestEdge> p, TestVertex src, TestVertex dst, int length, Weight cost) {
        Assert.assertEquals((String)"incorrect path length", (long)length, (long)p.edges().size());
        Assert.assertEquals((String)"incorrect source", (Object)src, (Object)p.src());
        Assert.assertEquals((String)"incorrect destination", (Object)dst, (Object)p.dst());
        Assert.assertEquals((String)"incorrect path cost", (Object)cost, (Object)p.cost());
    }
}

