/*
 * Decompiled with CFR 0.152.
 */
package org.onlab.packet;

import com.google.common.net.InetAddresses;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.util.Arrays;
import org.onlab.packet.IpAddress;

public final class Ip6Address
extends IpAddress {
    public static final IpAddress.Version VERSION = IpAddress.Version.INET6;
    public static final int BYTE_LENGTH = 16;
    public static final int BIT_LENGTH = 128;
    public static final Ip6Address ALL_DHCP_RELAY_AGENTS_AND_SERVERS = Ip6Address.valueOf("ff02::1:2");
    public static final Ip6Address ALL_DHCP_SERVERS = Ip6Address.valueOf("ff05::1:3");
    public static final Ip6Address ZERO = Ip6Address.valueOf("::");

    private Ip6Address(byte[] value) {
        super(VERSION, value);
    }

    public static Ip6Address valueOf(byte[] value) {
        return new Ip6Address(value);
    }

    public static Ip6Address valueOf(byte[] value, int offset) {
        IpAddress.checkArguments(VERSION, value, offset);
        byte[] bc = Arrays.copyOfRange(value, offset, value.length);
        return Ip6Address.valueOf(bc);
    }

    public static Ip6Address valueOf(InetAddress inetAddress) {
        byte[] bytes = inetAddress.getAddress();
        if (inetAddress instanceof Inet6Address) {
            return new Ip6Address(bytes);
        }
        if (inetAddress instanceof Inet4Address || bytes.length == 4) {
            String msg = "Invalid IPv6 version address string: " + inetAddress.toString();
            throw new IllegalArgumentException(msg);
        }
        if (bytes.length == 16) {
            return new Ip6Address(bytes);
        }
        String msg = "Unrecognized IP version address string: " + inetAddress.toString();
        throw new IllegalArgumentException(msg);
    }

    public static Ip6Address valueOf(String value) {
        InetAddress inetAddress = null;
        try {
            inetAddress = InetAddresses.forString((String)value);
        }
        catch (IllegalArgumentException e) {
            String msg = "Invalid IP address string: " + value;
            throw new IllegalArgumentException(msg);
        }
        return Ip6Address.valueOf(inetAddress);
    }

    public static Ip6Address makeMaskPrefix(int prefixLength) {
        byte[] mask = IpAddress.makeMaskPrefixArray(VERSION, prefixLength);
        return new Ip6Address(mask);
    }

    public static Ip6Address makeMaskedAddress(Ip6Address address, int prefixLength) {
        byte[] net = Ip6Address.makeMaskedAddressArray(address, prefixLength);
        return Ip6Address.valueOf(net);
    }
}

