/*
 * Decompiled with CFR 0.152.
 */
package org.onlab.packet;

import java.nio.ByteBuffer;
import java.util.Arrays;
import org.onlab.packet.DeserializationException;

public class LLDPTLV {
    protected byte type;
    protected short length;
    protected byte[] value;

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        sb.append("type= ");
        sb.append(this.type);
        sb.append("length= ");
        sb.append(this.length);
        sb.append("value= ");
        sb.append(Arrays.toString(this.value));
        sb.append("]");
        return sb.toString();
    }

    public byte getType() {
        return this.type;
    }

    public LLDPTLV setType(byte type) {
        this.type = type;
        return this;
    }

    public short getLength() {
        return this.length;
    }

    public LLDPTLV setLength(short length) {
        this.length = length;
        return this;
    }

    public byte[] getValue() {
        return this.value;
    }

    public LLDPTLV setValue(byte[] value) {
        this.value = value;
        return this;
    }

    public byte[] serialize() {
        short scratch = (short)((0x7F & this.type) << 9 | 0x1FF & this.length);
        byte[] data = new byte[2 + this.length];
        ByteBuffer bb = ByteBuffer.wrap(data);
        bb.putShort(scratch);
        if (this.value != null) {
            bb.put(this.value);
        }
        return data;
    }

    public LLDPTLV deserialize(ByteBuffer bb) throws DeserializationException {
        if (bb.remaining() < 2) {
            throw new DeserializationException("Not enough bytes to deserialize TLV type and length");
        }
        short typeLength = bb.getShort();
        this.type = (byte)(typeLength >> 9 & 0x7F);
        this.length = (short)(typeLength & 0x1FF);
        if (this.length > 0) {
            this.value = new byte[this.length];
            if (bb.remaining() < this.length) {
                throw new DeserializationException("Remaining bytes are less then the length of the TLV");
            }
            bb.get(this.value);
        }
        return this;
    }

    public int hashCode() {
        int prime = 1423;
        int result = 1;
        result = 1423 * result + this.length;
        result = 1423 * result + this.type;
        result = 1423 * result + Arrays.hashCode(this.value);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LLDPTLV)) {
            return false;
        }
        LLDPTLV other = (LLDPTLV)obj;
        if (this.length != other.length) {
            return false;
        }
        if (this.type != other.type) {
            return false;
        }
        return Arrays.equals(this.value, other.value);
    }
}

