/*
 * Decompiled with CFR 0.152.
 */
package org.onlab.graph;

import java.util.Set;
import org.junit.Assert;
import org.junit.Test;
import org.onlab.graph.AbstractGraphPathSearchTest;
import org.onlab.graph.AdjacencyListsGraph;
import org.onlab.graph.DepthFirstSearch;
import org.onlab.graph.Path;
import org.onlab.graph.ScalarWeight;
import org.onlab.graph.TestDoubleWeight;
import org.onlab.graph.TestEdge;
import org.onlab.graph.TestVertex;
import org.onlab.graph.Vertex;
import org.onlab.graph.Weight;

public class DepthFirstSearchTest
extends AbstractGraphPathSearchTest {
    protected DepthFirstSearch<TestVertex, TestEdge> graphSearch() {
        return new DepthFirstSearch();
    }

    @Test
    public void defaultGraphTest() {
        this.executeDefaultTest(3, 6, new TestDoubleWeight(5.0), new TestDoubleWeight(12.0));
        this.executeBroadSearch();
    }

    @Test
    public void defaultHopCountWeight() {
        this.weigher = null;
        this.executeDefaultTest(3, 6, (Weight)new ScalarWeight(3.0), (Weight)new ScalarWeight(6.0));
        this.executeBroadSearch();
    }

    protected void executeDefaultTest(int minLength, int maxLength, Weight minCost, Weight maxCost) {
        this.graph = new AdjacencyListsGraph(this.vertexes(), this.edges());
        DepthFirstSearch<TestVertex, TestEdge> search = this.graphSearch();
        DepthFirstSearch.SpanningTreeResult result = (DepthFirstSearch.SpanningTreeResult)search.search(this.graph, (Vertex)A, (Vertex)H, this.weigher, 1);
        Set paths = result.paths();
        Assert.assertEquals((String)"incorrect path count", (long)1L, (long)paths.size());
        Path path = (Path)paths.iterator().next();
        System.out.println(path);
        Assert.assertEquals((String)"incorrect src", (Object)A, (Object)path.src());
        Assert.assertEquals((String)"incorrect dst", (Object)H, (Object)path.dst());
        int l = path.edges().size();
        Assert.assertTrue((String)("incorrect path length " + l), (minLength <= l && l <= maxLength ? 1 : 0) != 0);
        Assert.assertTrue((String)("incorrect path cost " + path.cost()), (path.cost().compareTo((Object)minCost) >= 0 && path.cost().compareTo((Object)maxCost) <= 0 ? 1 : 0) != 0);
        System.out.println(result.edges());
        this.printPaths(paths);
    }

    public void executeBroadSearch() {
        this.graph = new AdjacencyListsGraph(this.vertexes(), this.edges());
        DepthFirstSearch<TestVertex, TestEdge> search = this.graphSearch();
        DepthFirstSearch.SpanningTreeResult result = (DepthFirstSearch.SpanningTreeResult)search.search(this.graph, (Vertex)A, null, this.weigher, -1);
        Assert.assertEquals((String)"incorrect paths count", (long)7L, (long)result.paths().size());
        int[] types = new int[]{0, 0, 0, 0};
        for (DepthFirstSearch.EdgeType t : result.edges().values()) {
            int n = t.ordinal();
            types[n] = types[n] + 1;
        }
        Assert.assertEquals((String)"incorrect tree-edge count", (long)7L, (long)types[DepthFirstSearch.EdgeType.TREE_EDGE.ordinal()]);
        Assert.assertEquals((String)"incorrect back-edge count", (long)1L, (long)types[DepthFirstSearch.EdgeType.BACK_EDGE.ordinal()]);
        Assert.assertEquals((String)"incorrect cross-edge & forward-edge count", (long)4L, (long)(types[DepthFirstSearch.EdgeType.FORWARD_EDGE.ordinal()] + types[DepthFirstSearch.EdgeType.CROSS_EDGE.ordinal()]));
    }
}

