/*
 * Decompiled with CFR 0.152.
 */
package org.onlab.packet;

import org.onlab.util.Identifier;

public final class VlanId
extends Identifier<Short> {
    public static final short UNTAGGED = -1;
    public static final short ANY_VALUE = 4096;
    public static final short NO_VID = 0;
    public static final short RESERVED = 4095;
    public static final VlanId NONE = VlanId.vlanId((short)-1);
    public static final VlanId ANY = VlanId.vlanId((short)4096);
    private static final String STRING_NONE = "None";
    private static final String STRING_NUMERIC_NONE = "-1";
    private static final String STRING_ANY = "Any";
    public static final short MAX_VLAN = 4095;

    private VlanId() {
        super((short)-1);
    }

    private VlanId(short value) {
        super(value);
    }

    public static VlanId vlanId() {
        return new VlanId(-1);
    }

    public static VlanId vlanId(short value) {
        if (value == -1) {
            return new VlanId();
        }
        if (value == 4096) {
            return new VlanId(4096);
        }
        if (value > 4095) {
            throw new IllegalArgumentException("value exceeds allowed maximum VLAN ID value (4095)");
        }
        return new VlanId(value);
    }

    public static VlanId vlanId(String value) {
        if (value.equals(STRING_NONE) || value.equals(STRING_NUMERIC_NONE)) {
            return new VlanId();
        }
        if (value.equals(STRING_ANY)) {
            return new VlanId(4096);
        }
        try {
            return VlanId.vlanId(Short.parseShort(value));
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public short toShort() {
        return (Short)this.identifier;
    }

    @Override
    public String toString() {
        if ((Short)this.identifier == 4096) {
            return STRING_ANY;
        }
        if ((Short)this.identifier == -1) {
            return STRING_NONE;
        }
        return String.valueOf(this.identifier);
    }
}

