/*
 * Decompiled with CFR 0.152.
 */
package org.onlab.util;

import com.google.common.base.Preconditions;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;

public final class CountDownCompleter<T> {
    private final T object;
    private final Consumer<T> onCompleteCallback;
    private final AtomicLong counter;

    public CountDownCompleter(T object, long count, Consumer<T> onCompleteCallback) {
        Preconditions.checkState((count >= 0L ? 1 : 0) != 0, (Object)"count must be non-negative");
        this.counter = new AtomicLong(count);
        this.object = Preconditions.checkNotNull(object);
        this.onCompleteCallback = (Consumer)Preconditions.checkNotNull(onCompleteCallback);
        if (count == 0L) {
            onCompleteCallback.accept(object);
        }
    }

    public T object() {
        return this.object;
    }

    public void countDown() {
        if (this.counter.decrementAndGet() == 0L) {
            this.onCompleteCallback.accept(this.object);
        }
    }

    public boolean isComplete() {
        return this.counter.get() <= 0L;
    }
}

