/*
 * Decompiled with CFR 0.152.
 */
package org.onlab.packet;

import com.google.common.base.Preconditions;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Objects;
import org.onlab.packet.BasePacket;
import org.onlab.packet.DeserializationException;
import org.onlab.packet.Deserializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RIPngEntry
extends BasePacket {
    public static final int OPT_CODE_LEN = 1;
    public static final int ENTRY_LEN = 20;
    public static final byte INFINITY_METRIC = 16;
    public static final byte NEXTHOP_METRIC = -128;
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    protected byte[] prefix;
    protected short routeTag;
    protected byte prefixLen;
    protected byte metric;

    @Override
    public byte[] serialize() {
        ByteBuffer byteBuffer = ByteBuffer.allocate(20);
        byteBuffer.put(this.prefix);
        byteBuffer.putShort(this.routeTag);
        byteBuffer.put(this.prefixLen);
        byteBuffer.put(this.metric);
        return byteBuffer.array();
    }

    public static Deserializer<RIPngEntry> deserializer() {
        return (data, offset, length) -> {
            RIPngEntry ripngEntry = new RIPngEntry();
            Preconditions.checkNotNull((Object)data);
            if (offset < 0 || length < 0 || length > data.length || offset >= data.length || offset + length > data.length) {
                throw new DeserializationException("Illegal offset or length");
            }
            ByteBuffer bb = ByteBuffer.wrap(data, offset, length);
            if (bb.remaining() < 20) {
                throw new DeserializationException("Buffer underflow while reading RIPng entry");
            }
            ripngEntry.prefix = new byte[16];
            bb.get(ripngEntry.prefix);
            ripngEntry.routeTag = bb.getShort();
            ripngEntry.prefixLen = bb.get();
            ripngEntry.metric = bb.get();
            return ripngEntry;
        };
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.metric, this.prefixLen, Arrays.hashCode(this.prefix), this.routeTag);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof RIPngEntry)) {
            return false;
        }
        RIPngEntry that = (RIPngEntry)obj;
        return super.equals(that) && Objects.equals(this.metric, this.metric) && Objects.equals(this.routeTag, that.routeTag) && Objects.equals(this.prefixLen, that.prefixLen) && Arrays.equals(this.prefix, that.prefix) && Objects.equals(this.routeTag, that.routeTag);
    }

    public byte[] getPrefix() {
        return this.prefix;
    }

    public RIPngEntry setPrefix(byte[] prefix) {
        this.prefix = prefix;
        return this;
    }

    public short getRouteTag() {
        return this.routeTag;
    }

    public RIPngEntry setRouteTag(short routetag) {
        this.routeTag = routetag;
        return this;
    }

    public byte getPrefixLen() {
        return this.prefixLen;
    }

    public RIPngEntry setPrefixLen(byte prefixlen) {
        this.prefixLen = prefixlen;
        return this;
    }

    public byte getMetric() {
        return this.metric;
    }

    public RIPngEntry setMetric(byte metric) {
        this.metric = metric;
        return this;
    }

    public String toString() {
        return "RIPngEntry [prefix=" + this.prefix + ", route tag=" + this.routeTag + ", prefix length=" + this.prefixLen + ", metric = " + this.metric + "]";
    }
}

