/*
 * Decompiled with CFR 0.152.
 */
package org.onlab.packet;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.onlab.packet.BasePacket;
import org.onlab.packet.DeserializationException;
import org.onlab.packet.Deserializer;
import org.onlab.packet.PacketUtils;
import org.onlab.packet.dhcp.DhcpOption;
import org.onlab.packet.dhcp.DhcpRelayAgentOption;

public class DHCP
extends BasePacket {
    public static final int MIN_HEADER_LENGTH = 240;
    public static final byte OPCODE_REQUEST = 1;
    public static final byte OPCODE_REPLY = 2;
    public static final byte HWTYPE_ETHERNET = 1;
    private static final Map<Byte, Deserializer<? extends DhcpOption>> OPTION_DESERIALIZERS = ImmutableMap.of((Object)DHCPOptionCode.OptionCode_CircuitID.value, DhcpRelayAgentOption.deserializer());
    private static final int UNSIGNED_BYTE_MASK = 255;
    private static final int BASE_OPTION_LEN = 60;
    private static final int MIN_DHCP_LEN = 240;
    private static final int BASE_HW_ADDR_LEN = 16;
    private static final byte PAD_BYTE = 0;
    private static final int BASE_SERVER_NAME_LEN = 64;
    private static final int BASE_BOOT_FILE_NAME_LEN = 128;
    private static final int MAGIC_COOKIE = 1669485411;
    protected byte opCode;
    protected byte hardwareType;
    protected byte hardwareAddressLength;
    protected byte hops;
    protected int transactionId;
    protected short seconds;
    protected short flags;
    protected int clientIPAddress;
    protected int yourIPAddress;
    protected int serverIPAddress;
    protected int gatewayIPAddress;
    protected byte[] clientHardwareAddress;
    protected String serverName;
    protected String bootFileName;
    protected List<DhcpOption> options = new ArrayList<DhcpOption>();

    public byte getOpCode() {
        return this.opCode;
    }

    public DHCP setOpCode(byte opCode) {
        this.opCode = opCode;
        return this;
    }

    public byte getHardwareType() {
        return this.hardwareType;
    }

    public DHCP setHardwareType(byte hardwareType) {
        this.hardwareType = hardwareType;
        return this;
    }

    public byte getHardwareAddressLength() {
        return this.hardwareAddressLength;
    }

    public DHCP setHardwareAddressLength(byte hardwareAddressLength) {
        this.hardwareAddressLength = hardwareAddressLength;
        return this;
    }

    public byte getHops() {
        return this.hops;
    }

    public DHCP setHops(byte hops) {
        this.hops = hops;
        return this;
    }

    public int getTransactionId() {
        return this.transactionId;
    }

    public DHCP setTransactionId(int transactionId) {
        this.transactionId = transactionId;
        return this;
    }

    public short getSeconds() {
        return this.seconds;
    }

    public DHCP setSeconds(short seconds) {
        this.seconds = seconds;
        return this;
    }

    public short getFlags() {
        return this.flags;
    }

    public DHCP setFlags(short flags) {
        this.flags = flags;
        return this;
    }

    public int getClientIPAddress() {
        return this.clientIPAddress;
    }

    public DHCP setClientIPAddress(int clientIPAddress) {
        this.clientIPAddress = clientIPAddress;
        return this;
    }

    public int getYourIPAddress() {
        return this.yourIPAddress;
    }

    public DHCP setYourIPAddress(int yourIPAddress) {
        this.yourIPAddress = yourIPAddress;
        return this;
    }

    public int getServerIPAddress() {
        return this.serverIPAddress;
    }

    public DHCP setServerIPAddress(int serverIPAddress) {
        this.serverIPAddress = serverIPAddress;
        return this;
    }

    public int getGatewayIPAddress() {
        return this.gatewayIPAddress;
    }

    public DHCP setGatewayIPAddress(int gatewayIPAddress) {
        this.gatewayIPAddress = gatewayIPAddress;
        return this;
    }

    public byte[] getClientHardwareAddress() {
        return this.clientHardwareAddress;
    }

    public DHCP setClientHardwareAddress(byte[] clientHardwareAddress) {
        this.clientHardwareAddress = clientHardwareAddress;
        return this;
    }

    public DhcpOption getOption(DHCPOptionCode optionCode) {
        for (DhcpOption opt : this.options) {
            if (opt.getCode() != optionCode.getValue()) continue;
            return opt;
        }
        return null;
    }

    public List<DhcpOption> getOptions() {
        return this.options;
    }

    public DHCP setOptions(List<DhcpOption> options) {
        this.options = options;
        return this;
    }

    public MsgType getPacketType() {
        return this.options.parallelStream().filter(op -> op.getCode() == DHCPOptionCode.OptionCode_MessageType.getValue()).map(DhcpOption::getData).filter(data -> ((byte[])data).length != 0).map(data -> data[0]).map(MsgType::getType).findFirst().orElse(null);
    }

    public String getServerName() {
        return this.serverName;
    }

    public DHCP setServerName(String server) {
        this.serverName = server;
        return this;
    }

    public String getBootFileName() {
        return this.bootFileName;
    }

    public DHCP setBootFileName(String bootFile) {
        this.bootFileName = bootFile;
        return this;
    }

    @Override
    public byte[] serialize() {
        this.resetChecksum();
        int optionsLength = 0;
        for (DhcpOption option : this.options) {
            if (option.getCode() == DHCPOptionCode.OptionCode_Pad.getValue() || option.getCode() == DHCPOptionCode.OptionCode_END.getValue()) {
                ++optionsLength;
                continue;
            }
            optionsLength += 2 + (0xFF & option.getLength());
        }
        int optionsPadLength = 0;
        if (optionsLength < 60) {
            optionsPadLength = 60 - optionsLength;
        }
        byte[] data = new byte[240 + optionsLength + optionsPadLength];
        ByteBuffer bb = ByteBuffer.wrap(data);
        bb.put(this.opCode);
        bb.put(this.hardwareType);
        bb.put(this.hardwareAddressLength);
        bb.put(this.hops);
        bb.putInt(this.transactionId);
        bb.putShort(this.seconds);
        bb.putShort(this.flags);
        bb.putInt(this.clientIPAddress);
        bb.putInt(this.yourIPAddress);
        bb.putInt(this.serverIPAddress);
        bb.putInt(this.gatewayIPAddress);
        Preconditions.checkArgument((this.clientHardwareAddress.length <= 16 ? 1 : 0) != 0, (String)"Hardware address is too long (%s bytes)", (int)this.clientHardwareAddress.length);
        bb.put(this.clientHardwareAddress);
        if (this.clientHardwareAddress.length < 16) {
            for (int i = 0; i < 16 - this.clientHardwareAddress.length; ++i) {
                bb.put((byte)0);
            }
        }
        this.writeString(this.serverName, bb, 64);
        this.writeString(this.bootFileName, bb, 128);
        bb.putInt(1669485411);
        for (DhcpOption option : this.options) {
            bb.put(option.serialize());
        }
        return data;
    }

    protected void writeString(String string, ByteBuffer bb, int maxLength) {
        if (string == null) {
            for (int i = 0; i < maxLength; ++i) {
                bb.put((byte)0);
            }
        } else {
            byte[] bytes = string.getBytes(StandardCharsets.US_ASCII);
            int writeLength = bytes.length;
            if (writeLength > maxLength) {
                writeLength = maxLength;
            }
            bb.put(bytes, 0, writeLength);
            for (int i = writeLength; i < maxLength; ++i) {
                bb.put((byte)0);
            }
        }
    }

    private static String readString(ByteBuffer bb, int maxLength) {
        byte[] bytes = new byte[maxLength];
        bb.get(bytes);
        String result = new String(bytes, StandardCharsets.US_ASCII).trim();
        return result;
    }

    public static Deserializer<DHCP> deserializer() {
        return (data, offset, length) -> {
            PacketUtils.checkInput(data, offset, length, 240);
            ByteBuffer bb = ByteBuffer.wrap(data, offset, length);
            DHCP dhcp = new DHCP();
            dhcp.opCode = bb.get();
            dhcp.hardwareType = bb.get();
            dhcp.hardwareAddressLength = bb.get();
            dhcp.hops = bb.get();
            dhcp.transactionId = bb.getInt();
            dhcp.seconds = bb.getShort();
            dhcp.flags = bb.getShort();
            dhcp.clientIPAddress = bb.getInt();
            dhcp.yourIPAddress = bb.getInt();
            dhcp.serverIPAddress = bb.getInt();
            dhcp.gatewayIPAddress = bb.getInt();
            int hardwareAddressLength = 0xFF & dhcp.hardwareAddressLength;
            dhcp.clientHardwareAddress = new byte[hardwareAddressLength];
            bb.get(dhcp.clientHardwareAddress);
            for (int i = hardwareAddressLength; i < 16; ++i) {
                bb.get();
            }
            dhcp.serverName = DHCP.readString(bb, 64);
            dhcp.bootFileName = DHCP.readString(bb, 128);
            bb.getInt();
            boolean foundEndOptionsMarker = false;
            while (bb.hasRemaining()) {
                DhcpOption option;
                int pos = bb.position();
                int optCode = 0xFF & bb.array()[pos];
                if (optCode == DHCPOptionCode.OptionCode_Pad.value) {
                    bb.get();
                    continue;
                }
                if (optCode == (0xFF & DHCPOptionCode.OptionCode_END.value)) {
                    option = new DhcpOption();
                    option.setCode((byte)optCode);
                    dhcp.options.add(option);
                    foundEndOptionsMarker = true;
                    break;
                }
                if (bb.remaining() < 2) {
                    throw new DeserializationException("Buffer underflow while reading DHCP option");
                }
                int optLen = 0xFF & bb.array()[pos + 1];
                if (bb.remaining() < 2 + optLen) {
                    throw new DeserializationException("Buffer underflow while reading DHCP option");
                }
                byte[] optData = new byte[2 + optLen];
                bb.get(optData);
                if (OPTION_DESERIALIZERS.containsKey((byte)optCode)) {
                    option = OPTION_DESERIALIZERS.get((byte)optCode).deserialize(optData, 0, optData.length);
                    dhcp.options.add(option);
                    continue;
                }
                option = DhcpOption.deserializer().deserialize(optData, 0, optData.length);
                dhcp.options.add(option);
            }
            if (!foundEndOptionsMarker) {
                throw new DeserializationException("DHCP End options marker was missing");
            }
            return dhcp;
        };
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("opCode", (Object)Byte.toString(this.opCode)).add("hardwareType", (Object)Byte.toString(this.hardwareType)).add("hardwareAddressLength", (Object)Byte.toString(this.hardwareAddressLength)).add("hops", (Object)Byte.toString(this.hops)).add("transactionId", (Object)Integer.toString(this.transactionId)).add("seconds", (Object)Short.toString(this.seconds)).add("flags", (Object)Short.toString(this.flags)).add("clientIPAddress", (Object)Integer.toString(this.clientIPAddress)).add("yourIPAddress", (Object)Integer.toString(this.yourIPAddress)).add("serverIPAddress", (Object)Integer.toString(this.serverIPAddress)).add("gatewayIPAddress", (Object)Integer.toString(this.gatewayIPAddress)).add("clientHardwareAddress", (Object)Arrays.toString(this.clientHardwareAddress)).add("serverName", (Object)this.serverName).add("bootFileName", (Object)this.bootFileName).toString();
    }

    public static enum MsgType {
        DHCPDISCOVER(1),
        DHCPOFFER(2),
        DHCPREQUEST(3),
        DHCPDECLINE(4),
        DHCPACK(5),
        DHCPNAK(6),
        DHCPRELEASE(7),
        DHCPINFORM(8),
        DHCPFORCERENEW(9),
        DHCPLEASEQUERY(10),
        DHCPLEASEUNASSIGNED(11),
        DHCPLEASEUNKNOWN(12),
        DHCPLEASEACTIVE(13);

        protected int value;

        private MsgType(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static MsgType getType(int value) {
            switch (value) {
                case 1: {
                    return DHCPDISCOVER;
                }
                case 2: {
                    return DHCPOFFER;
                }
                case 3: {
                    return DHCPREQUEST;
                }
                case 4: {
                    return DHCPDECLINE;
                }
                case 5: {
                    return DHCPACK;
                }
                case 6: {
                    return DHCPNAK;
                }
                case 7: {
                    return DHCPRELEASE;
                }
                case 8: {
                    return DHCPINFORM;
                }
                case 9: {
                    return DHCPFORCERENEW;
                }
                case 10: {
                    return DHCPLEASEQUERY;
                }
                case 11: {
                    return DHCPLEASEUNASSIGNED;
                }
                case 12: {
                    return DHCPLEASEUNKNOWN;
                }
                case 13: {
                    return DHCPLEASEACTIVE;
                }
            }
            return null;
        }
    }

    public static enum DHCPOptionCode {
        OptionCode_Pad(0),
        OptionCode_SubnetMask(1),
        OptionCode_RouterAddress(3),
        OptionCode_DomainServer(6),
        OptionCode_HostName(12),
        OptionCode_DomainName(15),
        OptionCode_BroadcastAddress(28),
        OptionCode_RequestedIP(50),
        OptionCode_LeaseTime(51),
        OptionCode_MessageType(53),
        OptionCode_DHCPServerIp(54),
        OptionCode_RequestedParameters(55),
        OptionCode_RenewalTime(58),
        OPtionCode_RebindingTime(59),
        OptionCode_ClientID(61),
        OptionCode_CircuitID(82),
        OptionCode_END(-1);

        protected byte value;

        private DHCPOptionCode(byte value) {
            this.value = value;
        }

        public byte getValue() {
            return this.value;
        }
    }
}

