/*
 * Decompiled with CFR 0.152.
 */
package org.onlab.packet;

import java.nio.ByteBuffer;
import org.onlab.packet.BasePacket;
import org.onlab.packet.DeserializationException;
import org.onlab.packet.Deserializer;
import org.onlab.packet.IPv4;
import org.onlab.packet.IPv6;

public abstract class IP
extends BasePacket {
    public abstract byte getVersion();

    public abstract IP setVersion(byte var1);

    public static Deserializer<? extends IP> deserializer() {
        return (data, offset, length) -> {
            ByteBuffer bb = ByteBuffer.wrap(data, offset, length);
            byte version = (byte)(bb.get() >> 4 & 0xF);
            switch (version) {
                case 4: {
                    return IPv4.deserializer().deserialize(data, offset, length);
                }
                case 6: {
                    return IPv6.deserializer().deserialize(data, offset, length);
                }
            }
            throw new DeserializationException("Invalid IP version");
        };
    }
}

