/*
 * Decompiled with CFR 0.152.
 */
package org.onlab.util;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ComparisonChain;
import org.onlab.util.RichComparable;

public final class Frequency
implements RichComparable<Frequency> {
    private static final long KHZ = 1000L;
    private static final long MHZ = 1000000L;
    private static final long GHZ = 1000000000L;
    private static final long THZ = 1000000000000L;
    private final long frequency;

    private Frequency(long frequency) {
        this.frequency = frequency;
    }

    public long asHz() {
        return this.frequency;
    }

    public double asKHz() {
        return (double)this.frequency / 1000.0;
    }

    public double asMHz() {
        return (double)this.frequency / 1000000.0;
    }

    public double asGHz() {
        return (double)this.frequency / 1.0E9;
    }

    public double asTHz() {
        return (double)this.frequency / 1.0E12;
    }

    public static Frequency ofHz(long value) {
        return new Frequency(value);
    }

    public static Frequency ofKHz(long value) {
        return new Frequency(value * 1000L);
    }

    public static Frequency ofKHz(double value) {
        return new Frequency((long)(value * 1000.0));
    }

    public static Frequency ofMHz(long value) {
        return new Frequency(value * 1000000L);
    }

    public static Frequency ofMHz(double value) {
        return new Frequency((long)(value * 1000000.0));
    }

    public static Frequency ofGHz(long value) {
        return new Frequency(value * 1000000000L);
    }

    public static Frequency ofGHz(double value) {
        return new Frequency((long)(value * 1.0E9));
    }

    public static Frequency ofTHz(long value) {
        return new Frequency(value * 1000000000000L);
    }

    public static Frequency ofTHz(double value) {
        return new Frequency((long)(value * 1.0E12));
    }

    public Frequency add(Frequency value) {
        return new Frequency(this.frequency + value.frequency);
    }

    public Frequency subtract(Frequency value) {
        return new Frequency(this.frequency - value.frequency);
    }

    public Frequency multiply(long value) {
        return new Frequency(this.frequency * value);
    }

    public Frequency floorDivision(long value) {
        return new Frequency(Math.floorDiv(this.frequency, value));
    }

    @Override
    public int compareTo(Frequency other) {
        return ComparisonChain.start().compare(this.frequency, other.frequency).result();
    }

    public int hashCode() {
        return Long.hashCode(this.frequency);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Frequency)) {
            return false;
        }
        Frequency other = (Frequency)obj;
        return this.frequency == other.frequency;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("frequency", (Object)(this.frequency + "Hz")).toString();
    }
}

