/*
 * Decompiled with CFR 0.152.
 */
package org.onlab.packet;

import org.apache.commons.lang3.StringUtils;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.onlab.packet.ICMP6;
import org.onlab.packet.IPacket;
import org.onlab.packet.IPv6;
import org.onlab.packet.PacketTestUtils;

public class ICMP6Test {
    private static final byte[] IPV6_SOURCE_ADDRESS = new byte[]{-2, -128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1};
    private static final byte[] IPV6_DESTINATION_ADDRESS = new byte[]{-2, -128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2};
    private static IPv6 ipv6 = new IPv6();
    private static byte[] bytePacket = new byte[]{-128, 0, -126, -68};

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        ipv6.setSourceAddress(IPV6_SOURCE_ADDRESS);
        ipv6.setDestinationAddress(IPV6_DESTINATION_ADDRESS);
        ipv6.setNextHeader((byte)58);
    }

    @Test
    public void testSerialize() {
        ICMP6 icmp6 = new ICMP6();
        icmp6.setIcmpType((byte)-128);
        icmp6.setIcmpCode((byte)0);
        icmp6.setParent((IPacket)ipv6);
        Assert.assertArrayEquals((byte[])bytePacket, (byte[])icmp6.serialize());
    }

    @Test
    public void testDeserializeBadInput() throws Exception {
        PacketTestUtils.testDeserializeBadInput(ICMP6.deserializer());
    }

    @Test
    public void testDeserializeTruncated() throws Exception {
        PacketTestUtils.testDeserializeTruncated(ICMP6.deserializer(), bytePacket);
    }

    @Test
    public void testDeserialize() throws Exception {
        ICMP6 icmp6 = (ICMP6)ICMP6.deserializer().deserialize(bytePacket, 0, bytePacket.length);
        Assert.assertThat((Object)icmp6.getIcmpType(), (Matcher)Matchers.is((Object)-128));
        Assert.assertThat((Object)icmp6.getIcmpCode(), (Matcher)Matchers.is((Object)0));
        Assert.assertThat((Object)icmp6.getChecksum(), (Matcher)Matchers.is((Object)-32068));
    }

    @Test
    public void testEqual() {
        ICMP6 icmp61 = new ICMP6();
        icmp61.setIcmpType((byte)-128);
        icmp61.setIcmpCode((byte)0);
        icmp61.setChecksum((short)0);
        ICMP6 icmp62 = new ICMP6();
        icmp62.setIcmpType((byte)-127);
        icmp62.setIcmpCode((byte)0);
        icmp62.setChecksum((short)0);
        Assert.assertTrue((boolean)icmp61.equals((Object)icmp61));
        Assert.assertFalse((boolean)icmp61.equals((Object)icmp62));
    }

    @Test
    public void testToStringIcmp6() throws Exception {
        ICMP6 icmp6 = (ICMP6)ICMP6.deserializer().deserialize(bytePacket, 0, bytePacket.length);
        String str = icmp6.toString();
        Assert.assertTrue((boolean)StringUtils.contains((CharSequence)str, (CharSequence)"icmpType=-128"));
        Assert.assertTrue((boolean)StringUtils.contains((CharSequence)str, (CharSequence)"icmpCode=0"));
        Assert.assertTrue((boolean)StringUtils.contains((CharSequence)str, (CharSequence)"checksum=-32068"));
    }
}

