/*
 * Decompiled with CFR 0.152.
 */
package org.onlab.packet;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.onlab.packet.BasePacket;
import org.onlab.packet.DeserializationException;
import org.onlab.packet.Deserializer;
import org.onlab.packet.IGMPGroup;
import org.onlab.packet.IGMPMembership;
import org.onlab.packet.IGMPQuery;
import org.onlab.packet.IpAddress;
import org.onlab.packet.PacketUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class IGMP
extends BasePacket {
    protected static final Logger log = LoggerFactory.getLogger(IGMP.class);
    public static final byte TYPE_IGMPV3_MEMBERSHIP_QUERY = 17;
    public static final byte TYPE_IGMPV1_MEMBERSHIP_REPORT = 18;
    public static final byte TYPE_IGMPV2_MEMBERSHIP_REPORT = 22;
    public static final byte TYPE_IGMPV2_LEAVE_GROUP = 23;
    public static final byte TYPE_IGMPV3_MEMBERSHIP_REPORT = 34;
    List<IGMPGroup> groups = new ArrayList<IGMPGroup>();
    protected byte igmpType;
    protected byte resField = 0;
    protected short checksum = 0;
    private byte[] unsupportTypeData;

    public byte getIgmpType() {
        return this.igmpType;
    }

    public void setIgmpType(byte msgType) {
        this.igmpType = msgType;
    }

    public short getChecksum() {
        return this.checksum;
    }

    public byte getMaxRespField() {
        return this.resField;
    }

    public abstract void setMaxRespCode(byte var1);

    public List<IGMPGroup> getGroups() {
        return ImmutableList.copyOf(this.groups);
    }

    public abstract boolean addGroup(IGMPGroup var1);

    @Override
    public byte[] serialize() {
        ByteBuffer bb;
        block12: {
            block11: {
                byte[] data = new byte[8915];
                bb = ByteBuffer.wrap(data);
                bb.put(this.getIgmpType());
                bb.put(this.resField);
                bb.putShort((short)0);
                if (!(this instanceof IGMPv3)) break block11;
                switch (this.igmpType) {
                    case 34: {
                        bb.putShort((short)0);
                        bb.putShort((short)this.groups.size());
                    }
                    case 17: {
                        for (IGMPGroup grp : this.groups) {
                            grp.serialize(bb);
                        }
                        break block12;
                    }
                    default: {
                        bb.put(this.unsupportTypeData);
                        break;
                    }
                }
                break block12;
            }
            if (this instanceof IGMPv2) {
                if (this.groups.isEmpty()) {
                    bb.putInt(0);
                } else {
                    bb.putInt(this.groups.get(0).getGaddr().getIp4Address().toInt());
                }
            } else {
                throw new UnsupportedOperationException();
            }
        }
        int size = bb.position();
        if (this.checksum == 0) {
            bb.rewind();
            int accumulation = 0;
            for (int i = 0; i < size * 2; ++i) {
                accumulation += 0xFFFF & bb.getShort();
            }
            accumulation = (accumulation >> 16 & 0xFFFF) + (accumulation & 0xFFFF);
            this.checksum = (short)(~accumulation & 0xFFFF);
            bb.putShort(2, this.checksum);
        }
        bb.position(0);
        byte[] rdata = new byte[size];
        bb.get(rdata, 0, size);
        return rdata;
    }

    public static Deserializer<IGMP> deserializer() {
        return (data, offset, length) -> {
            PacketUtils.checkInput(data, offset, length, 8);
            ByteBuffer bb = ByteBuffer.wrap(data, offset, length);
            byte igmpType = bb.get();
            boolean isV2 = igmpType == 22 || igmpType == 23 || length == 8;
            IGMP igmp = isV2 ? new IGMPv2() : new IGMPv3();
            igmp.igmpType = igmpType;
            igmp.resField = bb.get();
            igmp.checksum = bb.getShort();
            if (isV2) {
                igmp.addGroup(new IGMPQuery(IpAddress.valueOf(bb.getInt()), 0));
                if (igmp.validChecksum()) {
                    return igmp;
                }
                throw new DeserializationException("invalid checksum");
            }
            PacketUtils.checkInput(data, offset, length, 12);
            switch (igmp.igmpType) {
                case 17: {
                    IGMPQuery qgroup = new IGMPQuery();
                    qgroup.deserialize(bb);
                    igmp.groups.add(qgroup);
                    break;
                }
                case 34: {
                    bb.getShort();
                    for (int ngrps = bb.getShort(); ngrps > 0; --ngrps) {
                        IGMPMembership mgroup = new IGMPMembership();
                        mgroup.deserialize(bb);
                        igmp.groups.add(mgroup);
                    }
                    break;
                }
                case 18: 
                case 22: 
                case 23: {
                    igmp.unsupportTypeData = bb.array();
                    String msg = "IGMP message type: " + igmp.igmpType + " is not supported";
                    log.debug(msg);
                    break;
                }
                default: {
                    String msg = "IGMP message type: " + igmp.igmpType + " is not recognized";
                    igmp.unsupportTypeData = bb.array();
                    log.debug(msg);
                }
            }
            return igmp;
        };
    }

    protected abstract boolean validChecksum();

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof IGMP)) {
            return false;
        }
        IGMP other = (IGMP)obj;
        if (this.igmpType != other.igmpType) {
            return false;
        }
        if (this.resField != other.resField) {
            return false;
        }
        if (this.checksum != other.checksum) {
            return false;
        }
        if (this.groups.size() != other.groups.size()) {
            return false;
        }
        return this.groups.equals(other.groups);
    }

    @Override
    public int hashCode() {
        int prime = 2521;
        int result = super.hashCode();
        result = 2521 * result + this.igmpType;
        result = 2521 * result + this.groups.size();
        result = 2521 * result + this.resField;
        result = 2521 * result + this.checksum;
        result = 2521 * result + this.groups.hashCode();
        return result;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("igmpType", (Object)Byte.toString(this.igmpType)).add("resField", (Object)Byte.toString(this.resField)).add("checksum", (Object)Short.toString(this.checksum)).add("unsupportTypeData", (Object)Arrays.toString(this.unsupportTypeData)).toString();
    }

    public static class IGMPv2
    extends IGMP {
        public static final int HEADER_LENGTH = 8;

        @Override
        public void setMaxRespCode(byte respCode) {
            this.resField = respCode;
        }

        @Override
        public boolean addGroup(IGMPGroup group) {
            if (this.groups.isEmpty()) {
                this.groups = ImmutableList.of((Object)group);
                return true;
            }
            return false;
        }

        @Override
        protected boolean validChecksum() {
            short checksum;
            int accumulation = (this.igmpType & 0xFF) << 8;
            accumulation += this.resField & 0xFF;
            if (!this.groups.isEmpty()) {
                int ipaddr = ((IGMPGroup)this.groups.get(0)).getGaddr().getIp4Address().toInt();
                accumulation += ipaddr >> 16 & 0xFFFF;
                accumulation += ipaddr & 0xFFFF;
            }
            return (checksum = (short)(~(accumulation = (accumulation >> 16 & 0xFFFF) + (accumulation & 0xFFFF)) & 0xFFFF)) == this.checksum;
        }
    }

    public static class IGMPv3
    extends IGMP {
        public static final int MINIMUM_HEADER_LEN = 12;

        @Override
        public void setMaxRespCode(byte respCode) {
            if (this.igmpType != 17) {
                log.debug("Requesting the max response code for an incorrect field: ");
            }
            this.resField = respCode;
        }

        @Override
        public boolean addGroup(IGMPGroup group) {
            Preconditions.checkNotNull((Object)group);
            switch (this.igmpType) {
                case 17: {
                    if (group instanceof IGMPMembership) {
                        return false;
                    }
                    if (group.sources.size() <= 1) break;
                    return false;
                }
                case 34: {
                    if (!(group instanceof IGMPQuery)) break;
                    return false;
                }
                default: {
                    log.debug("Warning no IGMP message type has been set");
                }
            }
            this.groups.add(group);
            return true;
        }

        @Override
        protected boolean validChecksum() {
            return true;
        }
    }
}

