/*
 * Decompiled with CFR 0.152.
 */
package org.onlab.util;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.io.CharSource;
import java.io.IOException;
import java.io.StringWriter;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class XmlString
implements CharSequence {
    private static final Logger log = LoggerFactory.getLogger(XmlString.class);
    private final Supplier<String> prettyString = Suppliers.memoize(() -> this.prettyPrintXml(inputXml));

    public static CharSequence prettifyXml(CharSequence xml) {
        return new XmlString(CharSource.wrap((CharSequence)xml));
    }

    XmlString(CharSource inputXml) {
    }

    private String prettyPrintXml(CharSource inputXml) {
        try {
            Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new InputSource(inputXml.openStream()));
            document.normalize();
            XPath xPath = XPathFactory.newInstance().newXPath();
            NodeList nodeList = (NodeList)xPath.evaluate("//text()[normalize-space()='']", document, XPathConstants.NODESET);
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                node.getParentNode().removeChild(node);
            }
            Transformer t = TransformerFactory.newInstance().newTransformer();
            t.setOutputProperty("encoding", "UTF-8");
            t.setOutputProperty("omit-xml-declaration", "yes");
            t.setOutputProperty("indent", "yes");
            t.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            StringWriter strWriter = new StringWriter();
            t.transform(new DOMSource(document), new StreamResult(strWriter));
            return strWriter.toString();
        }
        catch (Exception e) {
            log.warn("Pretty printing failed", (Throwable)e);
            try {
                String rawInput = inputXml.read();
                log.debug("  failed input: \n{}", (Object)rawInput);
                return rawInput;
            }
            catch (IOException e1) {
                log.error("Failed to read from input", (Throwable)e1);
                return inputXml.toString();
            }
        }
    }

    @Override
    public int length() {
        return this.toString().length();
    }

    @Override
    public char charAt(int index) {
        return this.toString().charAt(index);
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return this.toString().subSequence(start, end);
    }

    @Override
    public String toString() {
        return (String)this.prettyString.get();
    }
}

