/*
 * Decompiled with CFR 0.152.
 */
package org.onlab.util;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.primitives.UnsignedLongs;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.security.SecureRandom;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.util.Arrays;
import java.util.Collection;
import java.util.Dictionary;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.onlab.util.BlockingAwareFuture;
import org.onlab.util.GroupedThreadFactory;
import org.onlab.util.ItemNotFoundException;
import org.onlab.util.Match;
import org.onlab.util.RetryingFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Tools {
    private static final Logger log = LoggerFactory.getLogger(Tools.class);
    private static Random random = new SecureRandom();
    private static final String INPUT_JSON_CANNOT_BE_NULL = "Input JSON cannot be null";

    private Tools() {
    }

    public static ThreadFactory namedThreads(String pattern) {
        return new ThreadFactoryBuilder().setNameFormat(pattern).setUncaughtExceptionHandler((t, e) -> log.error("Uncaught exception on " + t.getName(), e)).build();
    }

    public static ThreadFactory groupedThreads(String groupName, String pattern) {
        return Tools.groupedThreads(groupName, pattern, log);
    }

    public static ThreadFactory groupedThreads(String groupName, String pattern, Logger logger) {
        if (logger == null) {
            return Tools.groupedThreads(groupName, pattern);
        }
        return new ThreadFactoryBuilder().setThreadFactory((ThreadFactory)GroupedThreadFactory.groupedThreadFactory(groupName)).setNameFormat(groupName.replace("/", "-") + "-" + pattern).setUncaughtExceptionHandler((t, e) -> logger.error("Uncaught exception on " + t.getName(), e)).build();
    }

    public static ThreadFactory minPriority(ThreadFactory factory) {
        return new ThreadFactoryBuilder().setThreadFactory(factory).setPriority(1).build();
    }

    public static ThreadFactory maxPriority(ThreadFactory factory) {
        return new ThreadFactoryBuilder().setThreadFactory(factory).setPriority(10).build();
    }

    public static boolean isNullOrEmpty(Collection<?> collection) {
        return collection == null || collection.isEmpty();
    }

    public static <T> T nullIsNotFound(T item, String message) {
        if (item == null) {
            throw new ItemNotFoundException(message);
        }
        return item;
    }

    public static <T> Set<T> emptyIsNotFound(Set<T> item, String message) {
        if (item == null || item.isEmpty()) {
            throw new ItemNotFoundException(message);
        }
        return item;
    }

    public static <T> T nullIsIllegal(T item, String message) {
        if (item == null) {
            throw new IllegalArgumentException(message);
        }
        return item;
    }

    public static ObjectNode readTreeFromStream(ObjectMapper mapper, InputStream stream) throws IOException {
        return Tools.nullIsIllegal((ObjectNode)mapper.readTree(stream), INPUT_JSON_CANNOT_BE_NULL);
    }

    public static long fromHex(String string) {
        return UnsignedLongs.parseUnsignedLong((String)string, (int)16);
    }

    public static String toHex(long value) {
        return Strings.padStart((String)UnsignedLongs.toString((long)value, (int)16), (int)16, (char)'0');
    }

    public static String toHex(long value, int width) {
        return Strings.padStart((String)UnsignedLongs.toString((long)value, (int)16), (int)width, (char)'0');
    }

    public static String toHexWithPrefix(long value) {
        return "0x" + Long.toHexString(value);
    }

    public static byte[] getBytesUtf8(String input) {
        return input.getBytes(Charsets.UTF_8);
    }

    public static String toStringUtf8(byte[] input) {
        return new String(input, Charsets.UTF_8);
    }

    public static byte[] copyOf(byte[] original) {
        return Arrays.copyOf(original, original.length);
    }

    public static String get(Dictionary<?, ?> properties, String propertyName) {
        Object v = properties.get(propertyName);
        String s = v instanceof String ? (String)v : (v != null ? v.toString() : null);
        return Strings.isNullOrEmpty((String)s) ? null : s.trim();
    }

    public static Integer getIntegerProperty(Dictionary<?, ?> properties, String propertyName) {
        Integer value;
        try {
            String s = Tools.get(properties, propertyName);
            value = Strings.isNullOrEmpty((String)s) ? null : Integer.valueOf(s);
        }
        catch (ClassCastException | NumberFormatException e) {
            value = null;
        }
        return value;
    }

    public static int getIntegerProperty(Dictionary<?, ?> properties, String propertyName, int defaultValue) {
        try {
            String s = Tools.get(properties, propertyName);
            return Strings.isNullOrEmpty((String)s) ? defaultValue : Integer.valueOf(s);
        }
        catch (ClassCastException | NumberFormatException e) {
            return defaultValue;
        }
    }

    public static Boolean isPropertyEnabled(Dictionary<?, ?> properties, String propertyName) {
        Boolean value;
        try {
            String s = Tools.get(properties, propertyName);
            value = Strings.isNullOrEmpty((String)s) ? null : Boolean.valueOf(s);
        }
        catch (ClassCastException e) {
            value = null;
        }
        return value;
    }

    public static boolean isPropertyEnabled(Dictionary<?, ?> properties, String propertyName, boolean defaultValue) {
        try {
            String s = Tools.get(properties, propertyName);
            return Strings.isNullOrEmpty((String)s) ? defaultValue : Boolean.valueOf(s);
        }
        catch (ClassCastException e) {
            return defaultValue;
        }
    }

    public static void delay(int ms) {
        try {
            Thread.sleep(ms);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IllegalStateException("Interrupted", e);
        }
    }

    public static Long getLongProperty(Dictionary<?, ?> properties, String propertyName) {
        Long value;
        try {
            String s = Tools.get(properties, propertyName);
            value = Strings.isNullOrEmpty((String)s) ? null : Long.valueOf(s);
        }
        catch (ClassCastException | NumberFormatException e) {
            value = null;
        }
        return value;
    }

    public static <U, V> Function<U, V> retryable(Function<U, V> base, Class<? extends Throwable> exceptionClass, int maxRetries, int maxDelayBetweenRetries) {
        return new RetryingFunction<U, V>(base, exceptionClass, maxRetries, maxDelayBetweenRetries);
    }

    public static <V> Supplier<V> retryable(Supplier<V> base, Class<? extends Throwable> exceptionClass, int maxRetries, int maxDelayBetweenRetries) {
        return () -> new RetryingFunction<Object, Object>(arg_0 -> Tools.lambda$null$2((Supplier)base, arg_0), exceptionClass, maxRetries, maxDelayBetweenRetries).apply((Object)null);
    }

    public static void randomDelay(int ms) {
        try {
            Thread.sleep(random.nextInt(ms));
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IllegalStateException("Interrupted", e);
        }
    }

    public static void delay(int ms, int nanos) {
        try {
            Thread.sleep(ms, nanos);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IllegalStateException("Interrupted", e);
        }
    }

    public static void removeDirectory(String path) throws IOException {
        DirectoryDeleter visitor = new DirectoryDeleter();
        File dir = new File(path);
        if (dir.exists() && dir.isDirectory()) {
            Files.walkFileTree(Paths.get(path, new String[0]), visitor);
            if (visitor.exception != null) {
                throw visitor.exception;
            }
        }
    }

    public static void removeDirectory(File dir) throws IOException {
        DirectoryDeleter visitor = new DirectoryDeleter();
        if (dir.exists() && dir.isDirectory()) {
            Files.walkFileTree(Paths.get(dir.getAbsolutePath(), new String[0]), visitor);
            if (visitor.exception != null) {
                throw visitor.exception;
            }
        }
    }

    public static String timeAgo(long unixTime) {
        long deltaMillis = System.currentTimeMillis() - unixTime;
        long secondsSince = (long)((double)deltaMillis / 1000.0);
        long minsSince = (long)((double)deltaMillis / 60000.0);
        long hoursSince = (long)((double)deltaMillis / 3600000.0);
        long daysSince = (long)((double)deltaMillis / 8.64E7);
        if (daysSince > 0L) {
            return String.format("%dd%dh ago", daysSince, hoursSince - daysSince * 24L);
        }
        if (hoursSince > 0L) {
            return String.format("%dh%dm ago", hoursSince, minsSince - hoursSince * 60L);
        }
        if (minsSince > 0L) {
            return String.format("%dm%ds ago", minsSince, secondsSince - minsSince * 60L);
        }
        if (secondsSince > 0L) {
            return String.format("%ds ago", secondsSince);
        }
        return "just now";
    }

    public static void copyDirectory(String src, String dst) throws IOException {
        Files.walkFileTree(Paths.get(src, new String[0]), new DirectoryCopier(src, dst));
    }

    public static void copyDirectory(File src, File dst) throws IOException {
        Files.walkFileTree(Paths.get(src.getAbsolutePath(), new String[0]), new DirectoryCopier(src.getAbsolutePath(), dst.getAbsolutePath()));
    }

    public static <T> T futureGetOrElse(Future<T> future, T defaultValue) {
        try {
            return future.get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return defaultValue;
        }
        catch (ExecutionException e) {
            return defaultValue;
        }
    }

    public static <T> T futureGetOrElse(Future<T> future, long timeout, TimeUnit timeUnit, T defaultValue) {
        try {
            return future.get(timeout, timeUnit);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return defaultValue;
        }
        catch (ExecutionException | TimeoutException e) {
            return defaultValue;
        }
    }

    public static <T> CompletableFuture<T> exceptionalFuture(Throwable t) {
        CompletableFuture future = new CompletableFuture();
        future.completeExceptionally(t);
        return future;
    }

    public static <T> CompletableFuture<T> orderedFuture(CompletableFuture<T> future, Executor orderedExecutor, Executor threadPoolExecutor) {
        if (future.isDone()) {
            return future;
        }
        BlockingAwareFuture newFuture = new BlockingAwareFuture();
        future.whenComplete((result, error) -> {
            Runnable completer = () -> {
                if (future.isCompletedExceptionally()) {
                    newFuture.completeExceptionally((Throwable)error);
                } else {
                    newFuture.complete(result);
                }
            };
            if (newFuture.isBlocked()) {
                threadPoolExecutor.execute(completer);
            } else {
                orderedExecutor.execute(completer);
            }
        });
        return newFuture;
    }

    public static <T> CompletableFuture<List<T>> allOf(List<CompletableFuture<T>> futures) {
        return CompletableFuture.allOf(futures.toArray(new CompletableFuture[futures.size()])).thenApply(v -> futures.stream().map(CompletableFuture::join).collect(Collectors.toList()));
    }

    public static <T> CompletableFuture<T> allOf(List<CompletableFuture<T>> futures, BinaryOperator<T> reducer, T emptyValue) {
        return Tools.allOf(futures).thenApply(resultList -> resultList.stream().reduce(reducer).orElse(emptyValue));
    }

    public static <T> CompletableFuture<T> firstOf(List<CompletableFuture<T>> futures, Match<T> positiveResultMatcher, T negativeResult) {
        CompletableFuture responseFuture = new CompletableFuture();
        Tools.allOf(Lists.transform(futures, future -> future.thenAccept(r -> {
            if (positiveResultMatcher.matches(r)) {
                responseFuture.complete(r);
            }
        }))).whenComplete((r, e) -> {
            if (!responseFuture.isDone()) {
                if (e != null) {
                    responseFuture.completeExceptionally((Throwable)e);
                } else {
                    responseFuture.complete(negativeResult);
                }
            }
        });
        return responseFuture;
    }

    public static byte[] byteBuffertoArray(ByteBuffer buffer) {
        int length = buffer.remaining();
        if (buffer.hasArray()) {
            int offset = buffer.arrayOffset() + buffer.position();
            return Arrays.copyOfRange(buffer.array(), offset, offset + length);
        }
        byte[] bytes = new byte[length];
        buffer.duplicate().get(bytes);
        return bytes;
    }

    public static <T> Stream<T> stream(Iterable<T> it) {
        return StreamSupport.stream(it.spliterator(), false);
    }

    public static <T> Stream<T> stream(Optional<? extends T> optional) {
        return optional.map(x -> Stream.of(x)).orElse(Stream.empty());
    }

    public static OffsetDateTime defaultOffsetDataTime(long epochMillis) {
        return OffsetDateTime.ofInstant(Instant.ofEpochMilli(epochMillis), ZoneId.systemDefault());
    }

    public static <C extends Comparable<? super C>> C min(C l, C r) {
        Preconditions.checkNotNull(l, (Object)"l cannot be null");
        Preconditions.checkNotNull(r, (Object)"r cannot be null");
        return l.compareTo(r) <= 0 ? l : r;
    }

    public static <C extends Comparable<? super C>> C max(C l, C r) {
        Preconditions.checkNotNull(l, (Object)"l cannot be null");
        Preconditions.checkNotNull(r, (Object)"r cannot be null");
        return l.compareTo(r) >= 0 ? l : r;
    }

    public static void log(Logger logger, LogLevel level, String format, Object ... args) {
        switch (level) {
            case TRACE: {
                logger.trace(format, args);
                break;
            }
            case DEBUG: {
                logger.debug(format, args);
                break;
            }
            case INFO: {
                logger.info(format, args);
                break;
            }
            case WARN: {
                logger.warn(format, args);
                break;
            }
            case ERROR: {
                logger.error(format, args);
                break;
            }
            default: {
                log.error("Unknown log level {}", (Object)level);
            }
        }
    }

    private static /* synthetic */ Object lambda$null$2(Supplier base, Object v) {
        return base.get();
    }

    public static enum LogLevel {
        TRACE,
        DEBUG,
        INFO,
        WARN,
        ERROR;

    }

    private static class DirectoryCopier
    extends SimpleFileVisitor<Path> {
        private Path src;
        private Path dst;
        private StandardCopyOption copyOption = StandardCopyOption.REPLACE_EXISTING;

        DirectoryCopier(String src, String dst) {
            this.src = Paths.get(src, new String[0]);
            this.dst = Paths.get(dst, new String[0]);
        }

        @Override
        public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
            Path targetPath = this.dst.resolve(this.src.relativize(dir));
            if (!Files.exists(targetPath, new LinkOption[0])) {
                Files.createDirectory(targetPath, new FileAttribute[0]);
            }
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            Files.copy(file, this.dst.resolve(this.src.relativize(file)), this.copyOption);
            return FileVisitResult.CONTINUE;
        }
    }

    private static class DirectoryDeleter
    extends SimpleFileVisitor<Path> {
        private IOException exception;

        private DirectoryDeleter() {
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attributes) throws IOException {
            if (attributes.isRegularFile()) {
                Files.delete(file);
            }
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult postVisitDirectory(Path directory, IOException ioe) throws IOException {
            Files.delete(directory);
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFileFailed(Path file, IOException ioe) throws IOException {
            this.exception = ioe;
            return FileVisitResult.TERMINATE;
        }
    }
}

