/*
 * Decompiled with CFR 0.152.
 */
package org.onlab.packet;

import org.apache.commons.lang3.StringUtils;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.onlab.packet.Deserializer;
import org.onlab.packet.IPacket;
import org.onlab.packet.IPv4;
import org.onlab.packet.IPv6;
import org.onlab.packet.PacketTestUtils;
import org.onlab.packet.UDP;

public class UDPTest {
    private static final byte[] IPV4_SOURCE_ADDRESS = new byte[]{-64, -88, 1, 1};
    private static final byte[] IPV4_DESTINATION_ADDRESS = new byte[]{-64, -88, 1, 2};
    private static final byte[] IPV6_SOURCE_ADDRESS = new byte[]{-2, -128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1};
    private static final byte[] IPV6_DESTINATION_ADDRESS = new byte[]{-2, -128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2};
    private static IPv4 ipv4 = new IPv4();
    private static IPv6 ipv6 = new IPv6();
    private static byte[] bytePacketUDP4 = new byte[]{0, 80, 0, 96, 0, 8, 123, -38};
    private static byte[] bytePacketUDP6 = new byte[]{0, 80, 0, 96, 0, 8, 2, 42};
    private static Deserializer<UDP> deserializer;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        deserializer = UDP.deserializer();
        ipv4.setSourceAddress(IPv4.toIPv4Address((byte[])IPV4_SOURCE_ADDRESS));
        ipv4.setDestinationAddress(IPv4.toIPv4Address((byte[])IPV4_DESTINATION_ADDRESS));
        ipv4.setProtocol((byte)17);
        ipv6.setSourceAddress(IPV6_SOURCE_ADDRESS);
        ipv6.setDestinationAddress(IPV6_DESTINATION_ADDRESS);
        ipv6.setNextHeader((byte)17);
    }

    @Test
    public void testSerialize() {
        UDP udp = new UDP();
        udp.setSourcePort(80);
        udp.setDestinationPort(96);
        udp.setParent((IPacket)ipv4);
        Assert.assertArrayEquals((byte[])bytePacketUDP4, (byte[])udp.serialize());
        udp.resetChecksum();
        udp.setParent((IPacket)ipv6);
        Assert.assertArrayEquals((byte[])bytePacketUDP6, (byte[])udp.serialize());
    }

    @Test
    public void testDeserializeBadInput() throws Exception {
        PacketTestUtils.testDeserializeBadInput(deserializer);
    }

    @Test
    public void testDeserializeTruncated() throws Exception {
        PacketTestUtils.testDeserializeTruncated(deserializer, bytePacketUDP4);
    }

    @Test
    public void testDeserialize() throws Exception {
        UDP udp = (UDP)deserializer.deserialize(bytePacketUDP4, 0, bytePacketUDP4.length);
        Assert.assertThat((Object)udp.getSourcePort(), (Matcher)Matchers.is((Object)80));
        Assert.assertThat((Object)udp.getDestinationPort(), (Matcher)Matchers.is((Object)96));
        Assert.assertThat((Object)udp.getLength(), (Matcher)Matchers.is((Object)8));
        Assert.assertThat((Object)udp.getChecksum(), (Matcher)Matchers.is((Object)31706));
    }

    @Test
    public void testEqual() {
        UDP udp1 = new UDP();
        udp1.setSourcePort(80);
        udp1.setDestinationPort(96);
        UDP udp2 = new UDP();
        udp2.setSourcePort(112);
        udp2.setDestinationPort(96);
        Assert.assertTrue((boolean)udp1.equals((Object)udp1));
        Assert.assertFalse((boolean)udp1.equals((Object)udp2));
    }

    @Test
    public void testToStringUdp() throws Exception {
        UDP udp = (UDP)deserializer.deserialize(bytePacketUDP4, 0, bytePacketUDP4.length);
        String str = udp.toString();
        Assert.assertTrue((boolean)StringUtils.contains((CharSequence)str, (CharSequence)"sourcePort=80"));
        Assert.assertTrue((boolean)StringUtils.contains((CharSequence)str, (CharSequence)"destinationPort=96"));
        Assert.assertTrue((boolean)StringUtils.contains((CharSequence)str, (CharSequence)"length=8"));
        Assert.assertTrue((boolean)StringUtils.contains((CharSequence)str, (CharSequence)"checksum=31706"));
    }
}

