/*
 * Decompiled with CFR 0.152.
 */
package org.onlab.util;

import com.google.common.testing.EqualsTester;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.onlab.junit.ImmutableClassChecker;
import org.onlab.util.Frequency;

public class FrequencyTest {
    private final Frequency frequency1 = Frequency.ofMHz((long)1000L);
    private final Frequency sameFrequency1 = Frequency.ofMHz((long)1000L);
    private final Frequency frequency2 = Frequency.ofGHz((long)1000L);
    private final Frequency sameFrequency2 = Frequency.ofGHz((long)1000L);
    private final Frequency moreSameFrequency2 = Frequency.ofTHz((long)1L);
    private final Frequency frequency3 = Frequency.ofTHz((double)193.1);
    private final Frequency sameFrequency3 = Frequency.ofGHz((long)193100L);

    @Test
    public void testImmutability() {
        ImmutableClassChecker.assertThatClassIsImmutable(Frequency.class);
    }

    @Test
    public void testEquality() {
        new EqualsTester().addEqualityGroup(new Object[]{this.frequency1, this.sameFrequency1}).addEqualityGroup(new Object[]{this.frequency2, this.sameFrequency2, this.moreSameFrequency2}).addEqualityGroup(new Object[]{this.frequency3, this.sameFrequency3}).testEquals();
    }

    @Test
    public void testLessThan() {
        MatcherAssert.assertThat((Object)this.frequency1, (Matcher)Matchers.is((Matcher)Matchers.lessThan((Comparable)this.frequency2)));
        MatcherAssert.assertThat((Object)this.frequency1.isLessThan((Object)this.frequency2), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void testGreaterThan() {
        MatcherAssert.assertThat((Object)this.frequency2, (Matcher)Matchers.is((Matcher)Matchers.greaterThan((Comparable)this.frequency1)));
        MatcherAssert.assertThat((Object)this.frequency2.isGreaterThan((Object)this.frequency1), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void testAdd() {
        Frequency low = Frequency.ofMHz((long)100L);
        Frequency high = Frequency.ofGHz((long)1L);
        Frequency expected = Frequency.ofMHz((long)1100L);
        MatcherAssert.assertThat((Object)low.add(high), (Matcher)Matchers.is((Object)expected));
    }

    @Test
    public void testSubtract() {
        Frequency high = Frequency.ofGHz((long)1L);
        Frequency low = Frequency.ofMHz((long)100L);
        Frequency expected = Frequency.ofMHz((long)900L);
        MatcherAssert.assertThat((Object)high.subtract(low), (Matcher)Matchers.is((Object)expected));
    }

    @Test
    public void testMultiply() {
        Frequency frequency = Frequency.ofMHz((long)1000L);
        long factor = 5L;
        Frequency expected = Frequency.ofGHz((long)5L);
        MatcherAssert.assertThat((Object)frequency.multiply(5L), (Matcher)Matchers.is((Object)expected));
    }

    @Test
    public void testfloorDivision() {
        Frequency frequency = Frequency.ofGHz((long)1L);
        long factor = 5L;
        Frequency expected = Frequency.ofMHz((long)200L);
        MatcherAssert.assertThat((Object)frequency.floorDivision(factor), (Matcher)Matchers.is((Object)expected));
    }

    @Test
    public void testasHz() {
        Frequency frequency = Frequency.ofKHz((long)1L);
        MatcherAssert.assertThat((Object)frequency.asHz(), (Matcher)Matchers.is((Object)1000L));
    }

    @Test
    public void testasKHz() {
        Frequency frequency = Frequency.ofMHz((long)1L);
        MatcherAssert.assertThat((Object)frequency.asKHz(), (Matcher)Matchers.is((Object)1000.0));
    }

    @Test
    public void testasMHz() {
        Frequency frequency = Frequency.ofGHz((long)1L);
        MatcherAssert.assertThat((Object)frequency.asMHz(), (Matcher)Matchers.is((Object)1000.0));
    }

    @Test
    public void testasGHz() {
        Frequency frequency = Frequency.ofTHz((long)1L);
        MatcherAssert.assertThat((Object)frequency.asGHz(), (Matcher)Matchers.is((Object)1000.0));
    }

    @Test
    public void testasTHz() {
        Frequency frequency = Frequency.ofHz((long)1000000000000L);
        MatcherAssert.assertThat((Object)frequency.asTHz(), (Matcher)Matchers.is((Object)1.0));
    }

    @Test
    public void testofKHz() {
        Frequency frequency = Frequency.ofKHz((double)1.0);
        MatcherAssert.assertThat((Object)frequency.asHz(), (Matcher)Matchers.is((Object)1000L));
    }

    @Test
    public void testofMHz() {
        Frequency frequency = Frequency.ofMHz((double)1.0);
        MatcherAssert.assertThat((Object)frequency.asKHz(), (Matcher)Matchers.is((Object)1000.0));
    }

    @Test
    public void testofGHz() {
        Frequency frequency = Frequency.ofGHz((double)1.0);
        MatcherAssert.assertThat((Object)frequency.asMHz(), (Matcher)Matchers.is((Object)1000.0));
    }

    @Test
    public void testofTHz() {
        Frequency frequency = Frequency.ofTHz((double)1.0);
        MatcherAssert.assertThat((Object)frequency.asGHz(), (Matcher)Matchers.is((Object)1000.0));
    }
}

