/*
 * Decompiled with CFR 0.152.
 */
package org.onlab.util;

import junit.framework.TestCase;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.onlab.util.SlidingWindowCounter;

public class SlidingWindowCounterTest {
    private SlidingWindowCounter counter;

    @Before
    public void setUp() {
        this.counter = new SlidingWindowCounter(2);
    }

    @After
    public void tearDown() {
        this.counter.destroy();
    }

    @Test
    public void testIncrementCount() {
        Assert.assertEquals((long)0L, (long)this.counter.get(1));
        Assert.assertEquals((long)0L, (long)this.counter.get(2));
        this.counter.incrementCount();
        Assert.assertEquals((long)1L, (long)this.counter.get(1));
        Assert.assertEquals((long)1L, (long)this.counter.get(2));
        this.counter.incrementCount(2L);
        Assert.assertEquals((long)3L, (long)this.counter.get(2));
    }

    @Test
    public void testSlide() {
        this.counter.incrementCount();
        this.counter.advanceHead();
        Assert.assertEquals((long)0L, (long)this.counter.get(1));
        Assert.assertEquals((long)1L, (long)this.counter.get(2));
        this.counter.incrementCount(2L);
        Assert.assertEquals((long)2L, (long)this.counter.get(1));
        Assert.assertEquals((long)3L, (long)this.counter.get(2));
    }

    @Test
    public void testWrap() {
        this.counter.incrementCount();
        this.counter.advanceHead();
        this.counter.incrementCount(2L);
        this.counter.advanceHead();
        Assert.assertEquals((long)0L, (long)this.counter.get(1));
        Assert.assertEquals((long)2L, (long)this.counter.get(2));
        this.counter.advanceHead();
        Assert.assertEquals((long)0L, (long)this.counter.get(1));
        Assert.assertEquals((long)0L, (long)this.counter.get(2));
    }

    @Test
    public void testSlidingWindowStats() {
        SlidingWindowCounter counter = new SlidingWindowCounter(3);
        counter.incrementCount(1L);
        Assert.assertEquals((long)1L, (long)counter.getWindowCount());
        Assert.assertEquals((long)1L, (long)counter.getWindowCount(1));
        counter.advanceHead();
        Assert.assertEquals((long)1L, (long)counter.getWindowCount());
        Assert.assertEquals((long)0L, (long)counter.getWindowCount(1));
        Assert.assertEquals((long)1L, (long)counter.getWindowCount(2));
        counter.incrementCount(2L);
        Assert.assertEquals((long)3L, (long)counter.getWindowCount());
        Assert.assertEquals((long)2L, (long)counter.getWindowCount(1));
        Assert.assertEquals((long)3L, (long)counter.getWindowCount(2));
        counter.advanceHead();
        Assert.assertEquals((long)3L, (long)counter.getWindowCount());
        Assert.assertEquals((long)0L, (long)counter.getWindowCount(1));
        Assert.assertEquals((long)2L, (long)counter.getWindowCount(2));
        Assert.assertEquals((long)3L, (long)counter.getWindowCount(3));
        counter.incrementCount(3L);
        Assert.assertEquals((long)6L, (long)counter.getWindowCount());
        Assert.assertEquals((long)3L, (long)counter.getWindowCount(1));
        Assert.assertEquals((long)5L, (long)counter.getWindowCount(2));
        Assert.assertEquals((long)6L, (long)counter.getWindowCount(3));
        counter.advanceHead();
        Assert.assertEquals((long)5L, (long)counter.getWindowCount());
        Assert.assertEquals((long)0L, (long)counter.getWindowCount(1));
        Assert.assertEquals((long)3L, (long)counter.getWindowCount(2));
        Assert.assertEquals((long)5L, (long)counter.getWindowCount(3));
        counter.incrementCount(4L);
        Assert.assertEquals((long)9L, (long)counter.getWindowCount());
        Assert.assertEquals((long)4L, (long)counter.getWindowCount(1));
        Assert.assertEquals((long)7L, (long)counter.getWindowCount(2));
        Assert.assertEquals((long)9L, (long)counter.getWindowCount(3));
        counter.advanceHead();
        Assert.assertEquals((long)7L, (long)counter.getWindowCount());
        Assert.assertEquals((long)0L, (long)counter.getWindowCount(1));
        Assert.assertEquals((long)4L, (long)counter.getWindowCount(2));
        Assert.assertEquals((long)7L, (long)counter.getWindowCount(3));
        counter.incrementCount(5L);
        Assert.assertEquals((long)12L, (long)counter.getWindowCount());
        Assert.assertEquals((long)5L, (long)counter.getWindowCount(1));
        Assert.assertEquals((long)9L, (long)counter.getWindowCount(2));
        Assert.assertEquals((long)12L, (long)counter.getWindowCount(3));
        counter.advanceHead();
        Assert.assertEquals((long)9L, (long)counter.getWindowCount());
        Assert.assertEquals((long)0L, (long)counter.getWindowCount(1));
        Assert.assertEquals((long)5L, (long)counter.getWindowCount(2));
        Assert.assertEquals((long)9L, (long)counter.getWindowCount(3));
        counter.destroy();
    }

    @Test
    public void testRates() {
        Assert.assertEquals((double)0.0, (double)this.counter.getWindowRate(), (double)0.01);
        Assert.assertEquals((double)0.0, (double)this.counter.getOverallRate(), (double)0.01);
        Assert.assertEquals((long)0L, (long)this.counter.getOverallCount());
        this.counter.incrementCount();
        Assert.assertEquals((double)1.0, (double)this.counter.getWindowRate(), (double)0.01);
        Assert.assertEquals((double)1.0, (double)this.counter.getOverallRate(), (double)0.01);
        Assert.assertEquals((long)1L, (long)this.counter.getOverallCount());
        this.counter.advanceHead();
        this.counter.incrementCount();
        this.counter.incrementCount();
        Assert.assertEquals((double)1.5, (double)this.counter.getWindowRate(), (double)0.01);
        Assert.assertEquals((double)2.0, (double)this.counter.getWindowRate(1), (double)0.01);
        Assert.assertEquals((double)1.5, (double)this.counter.getOverallRate(), (double)0.01);
        Assert.assertEquals((long)3L, (long)this.counter.getOverallCount());
        this.counter.advanceHead();
        this.counter.incrementCount();
        this.counter.incrementCount();
        this.counter.incrementCount();
        Assert.assertEquals((double)2.5, (double)this.counter.getWindowRate(), (double)0.01);
        Assert.assertEquals((double)2.0, (double)this.counter.getOverallRate(), (double)0.01);
        Assert.assertEquals((long)6L, (long)this.counter.getOverallCount());
    }

    @Test
    public void testCornerCases() {
        try {
            this.counter.get(3);
            TestCase.fail((String)"Exception should have been thrown");
        }
        catch (IllegalArgumentException e) {
            Assert.assertTrue((boolean)true);
        }
        try {
            new SlidingWindowCounter(0);
            TestCase.fail((String)"Exception should have been thrown");
        }
        catch (IllegalArgumentException e) {
            Assert.assertTrue((boolean)true);
        }
        try {
            new SlidingWindowCounter(-1);
            TestCase.fail((String)"Exception should have been thrown");
        }
        catch (IllegalArgumentException e) {
            Assert.assertTrue((boolean)true);
        }
    }
}

