/*
 * Decompiled with CFR 0.152.
 */
package org.onlab.packet;

import java.nio.ByteBuffer;
import junit.framework.TestCase;
import org.apache.commons.lang3.StringUtils;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.onlab.packet.Deserializer;
import org.onlab.packet.Ethernet;
import org.onlab.packet.ICMP;
import org.onlab.packet.ICMP6;
import org.onlab.packet.IPacket;
import org.onlab.packet.IPv4;
import org.onlab.packet.IPv6;
import org.onlab.packet.Ip4Address;
import org.onlab.packet.Ip6Address;
import org.onlab.packet.MPLS;
import org.onlab.packet.MacAddress;
import org.onlab.packet.PacketTestUtils;

public class MplsTest {
    private Deserializer<MPLS> deserializer;
    private int label = 1048575;
    private byte bos = 1;
    private byte ttl = (byte)20;
    private byte protocol = 1;
    private byte[] bytes;
    private byte[] truncatedBytes;
    private static final MacAddress SRC_MAC = MacAddress.valueOf((String)"00:00:00:00:00:01");
    private static final MacAddress DST_MAC = MacAddress.valueOf((String)"00:00:00:00:00:02");
    private static final ICMP ICMP = new ICMP().setIcmpType((byte)8);
    private static final Ip4Address SRC_IPV4 = Ip4Address.valueOf((String)"10.0.1.1");
    private static final Ip4Address DST_IPV4 = Ip4Address.valueOf((String)"10.0.0.254");
    private static final IPv4 IPV4 = (IPv4)new IPv4().setDestinationAddress(DST_IPV4.toInt()).setSourceAddress(SRC_IPV4.toInt()).setTtl((byte)64).setProtocol((byte)1).setPayload((IPacket)ICMP);
    private static final ICMP6 ICMP6 = new ICMP6().setIcmpType((byte)-128);
    private static final Ip6Address SRC_IPV6 = Ip6Address.valueOf((String)"2000::101");
    private static final Ip6Address DST_IPV6 = Ip6Address.valueOf((String)"2000::ff");
    private static final IPv6 IPV6 = (IPv6)new IPv6().setDestinationAddress(DST_IPV6.toOctets()).setSourceAddress(SRC_IPV6.toOctets()).setHopLimit((byte)-1).setNextHeader((byte)58).setPayload((IPacket)ICMP6);
    private static final MPLS MPLS_IPV4 = new MPLS();
    private static final MPLS MPLS_BOS_IPV4 = new MPLS();
    private static final MPLS MPLS_IPV6 = new MPLS();
    private static final MPLS MPLS_BOS_IPV6 = new MPLS();
    private static final Ethernet ETH_IPV4 = (Ethernet)new Ethernet().setEtherType(Ethernet.MPLS_UNICAST).setDestinationMACAddress(DST_MAC).setSourceMACAddress(SRC_MAC).setPayload((IPacket)MPLS_IPV4);
    private static final Ethernet ETH_IPV6 = (Ethernet)new Ethernet().setEtherType(Ethernet.MPLS_UNICAST).setDestinationMACAddress(DST_MAC).setSourceMACAddress(SRC_MAC).setPayload((IPacket)MPLS_IPV6);

    @Before
    public void setUp() throws Exception {
        this.deserializer = MPLS.deserializer();
        byte[] ipv4 = IPV4.serialize();
        ByteBuffer bb = ByteBuffer.allocate(4 + IPV4.getTotalLength());
        bb.putInt((this.label & 0xFFFFF) << 12 | ((this.bos & 1) << 8 | this.ttl & 0xFF));
        bb.put(ipv4);
        this.bytes = bb.array();
        bb = ByteBuffer.allocate(4);
        bb.putInt((this.label & 0xFFFFF) << 12 | ((this.bos & 1) << 8 | this.ttl & 0xFF));
        this.truncatedBytes = bb.array();
        MPLS_BOS_IPV4.setLabel(101);
        MPLS_BOS_IPV4.setPayload((IPacket)IPV4);
        MPLS_IPV4.setLabel(1);
        MPLS_IPV4.setPayload((IPacket)MPLS_BOS_IPV4);
        ETH_IPV4.setPayload((IPacket)MPLS_IPV4);
        MPLS_BOS_IPV6.setLabel(201);
        MPLS_BOS_IPV6.setPayload((IPacket)IPV6);
        MPLS_IPV6.setLabel(2);
        MPLS_IPV6.setPayload((IPacket)MPLS_BOS_IPV6);
        ETH_IPV6.setPayload((IPacket)MPLS_IPV6);
    }

    @Test
    public void testDeserializeBadInput() throws Exception {
        PacketTestUtils.testDeserializeBadInput(this.deserializer);
    }

    @Test
    public void testDeserializeTruncated() throws Exception {
        PacketTestUtils.testDeserializeTruncated(this.deserializer, this.truncatedBytes);
    }

    @Test
    public void testDeserialize() throws Exception {
        MPLS mpls = (MPLS)this.deserializer.deserialize(this.bytes, 0, this.bytes.length);
        Assert.assertEquals((long)this.label, (long)mpls.label);
        Assert.assertEquals((long)this.bos, (long)mpls.bos);
        Assert.assertEquals((long)this.ttl, (long)mpls.ttl);
        Assert.assertEquals((long)this.protocol, (long)mpls.protocol);
    }

    @Test
    public void testToStringMpls() throws Exception {
        MPLS mpls = (MPLS)this.deserializer.deserialize(this.bytes, 0, this.bytes.length);
        String str = mpls.toString();
        Assert.assertTrue((boolean)StringUtils.contains((CharSequence)str, (CharSequence)("label=" + this.label)));
        Assert.assertTrue((boolean)StringUtils.contains((CharSequence)str, (CharSequence)("bos=" + this.bos)));
        Assert.assertTrue((boolean)StringUtils.contains((CharSequence)str, (CharSequence)("ttl=" + this.ttl)));
        Assert.assertTrue((boolean)StringUtils.contains((CharSequence)str, (CharSequence)("protocol=" + this.protocol)));
    }

    @Test
    public void testIpv4OverMplsDeserialize() throws Exception {
        byte[] packet = ETH_IPV4.serialize();
        Assert.assertThat((Object)MplsTest.MPLS_IPV4.protocol, (Matcher)Is.is((Object)6));
        Assert.assertThat((Object)MplsTest.MPLS_IPV4.bos, (Matcher)Is.is((Object)0));
        Assert.assertThat((Object)MplsTest.MPLS_BOS_IPV4.protocol, (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)MplsTest.MPLS_BOS_IPV4.bos, (Matcher)Is.is((Object)1));
        Ethernet ethernet = (Ethernet)Ethernet.deserializer().deserialize(packet, 0, packet.length);
        TestCase.assertNotNull((Object)ethernet);
        Assert.assertThat((Object)ethernet.getSourceMAC(), (Matcher)Is.is((Object)ETH_IPV4.getSourceMAC()));
        Assert.assertThat((Object)ethernet.getDestinationMAC(), (Matcher)Is.is((Object)ETH_IPV4.getDestinationMAC()));
        Assert.assertThat((Object)ethernet.getEtherType(), (Matcher)Is.is((Object)Ethernet.MPLS_UNICAST));
        Assert.assertTrue((boolean)(ethernet.getPayload() instanceof MPLS));
        MPLS mpls = (MPLS)ethernet.getPayload();
        Assert.assertThat((Object)mpls.getLabel(), (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)mpls.getTtl(), (Matcher)Is.is((Object)0));
        Assert.assertThat((Object)mpls.protocol, (Matcher)Is.is((Object)6));
        Assert.assertThat((Object)mpls.bos, (Matcher)Is.is((Object)0));
        Assert.assertTrue((boolean)(mpls.getPayload() instanceof MPLS));
        mpls = (MPLS)mpls.getPayload();
        Assert.assertThat((Object)mpls.getLabel(), (Matcher)Is.is((Object)101));
        Assert.assertThat((Object)mpls.getTtl(), (Matcher)Is.is((Object)0));
        Assert.assertThat((Object)mpls.protocol, (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)mpls.bos, (Matcher)Is.is((Object)1));
        IPv4 ip = (IPv4)mpls.getPayload();
        Assert.assertThat((Object)ip.getSourceAddress(), (Matcher)Is.is((Object)SRC_IPV4.toInt()));
        Assert.assertThat((Object)ip.getDestinationAddress(), (Matcher)Is.is((Object)DST_IPV4.toInt()));
        Assert.assertTrue((boolean)(ip.getPayload() instanceof ICMP));
        ICMP icmp = (ICMP)ip.getPayload();
        Assert.assertThat((Object)icmp.getIcmpType(), (Matcher)Is.is((Object)8));
    }

    @Test
    public void testIpv6OverMplsDeserialize() throws Exception {
        byte[] packet = ETH_IPV6.serialize();
        Assert.assertThat((Object)MplsTest.MPLS_IPV6.protocol, (Matcher)Is.is((Object)6));
        Assert.assertThat((Object)MplsTest.MPLS_IPV6.bos, (Matcher)Is.is((Object)0));
        Assert.assertThat((Object)MplsTest.MPLS_BOS_IPV6.protocol, (Matcher)Is.is((Object)2));
        Assert.assertThat((Object)MplsTest.MPLS_BOS_IPV6.bos, (Matcher)Is.is((Object)1));
        Ethernet ethernet = (Ethernet)Ethernet.deserializer().deserialize(packet, 0, packet.length);
        TestCase.assertNotNull((Object)ethernet);
        Assert.assertThat((Object)ethernet.getSourceMAC(), (Matcher)Is.is((Object)ETH_IPV6.getSourceMAC()));
        Assert.assertThat((Object)ethernet.getDestinationMAC(), (Matcher)Is.is((Object)ETH_IPV6.getDestinationMAC()));
        Assert.assertThat((Object)ethernet.getEtherType(), (Matcher)Is.is((Object)Ethernet.MPLS_UNICAST));
        Assert.assertTrue((boolean)(ethernet.getPayload() instanceof MPLS));
        MPLS mpls = (MPLS)ethernet.getPayload();
        Assert.assertThat((Object)mpls.getLabel(), (Matcher)Is.is((Object)2));
        Assert.assertThat((Object)mpls.getTtl(), (Matcher)Is.is((Object)0));
        Assert.assertThat((Object)mpls.protocol, (Matcher)Is.is((Object)6));
        Assert.assertThat((Object)mpls.bos, (Matcher)Is.is((Object)0));
        Assert.assertTrue((boolean)(mpls.getPayload() instanceof MPLS));
        mpls = (MPLS)mpls.getPayload();
        Assert.assertThat((Object)mpls.getLabel(), (Matcher)Is.is((Object)201));
        Assert.assertThat((Object)mpls.getTtl(), (Matcher)Is.is((Object)0));
        Assert.assertThat((Object)mpls.protocol, (Matcher)Is.is((Object)2));
        Assert.assertThat((Object)mpls.bos, (Matcher)Is.is((Object)1));
        IPv6 ip = (IPv6)mpls.getPayload();
        Assert.assertThat((Object)ip.getSourceAddress(), (Matcher)Is.is((Object)SRC_IPV6.toOctets()));
        Assert.assertThat((Object)ip.getDestinationAddress(), (Matcher)Is.is((Object)DST_IPV6.toOctets()));
        Assert.assertTrue((boolean)(ip.getPayload() instanceof ICMP6));
        ICMP6 icmp = (ICMP6)ip.getPayload();
        Assert.assertThat((Object)icmp.getIcmpType(), (Matcher)Is.is((Object)-128));
    }
}

