/*
 * Decompiled with CFR 0.152.
 */
package org.onlab.util;

import com.google.common.annotations.Beta;

@Beta
public enum DataRateUnit {
    BPS(1L),
    KBPS(1000L),
    MBPS(1000000L),
    GBPS(1000000000L);

    private final long multiplier;

    private DataRateUnit(long multiplier) {
        this.multiplier = multiplier;
    }

    public long multiplier() {
        return this.multiplier;
    }

    public long toBitsPerSecond(long v) {
        return v * this.multiplier;
    }

    public double toBitsPerSecond(double v) {
        return v * (double)this.multiplier;
    }
}

