/*
 * Decompiled with CFR 0.152.
 */
package org.onlab.packet.dhcp;

import com.google.common.io.Resources;
import java.net.URL;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.stream.IntStream;
import org.apache.commons.io.Charsets;
import org.apache.commons.lang.ArrayUtils;
import org.junit.Assert;
import org.junit.Test;
import org.onlab.packet.DHCP;
import org.onlab.packet.Ethernet;
import org.onlab.packet.Ip4Address;
import org.onlab.packet.MacAddress;
import org.onlab.packet.PacketTestUtils;
import org.onlab.packet.dhcp.Dhcp6RelayTest;
import org.onlab.packet.dhcp.DhcpOption;
import org.onlab.packet.dhcp.DhcpRelayAgentOption;

public class DhcpTest {
    private static final String DISCOVER = "dhcp_discover.bin";
    private static final String OFFER = "dhcp_offer.bin";
    private static final String REQUEST = "dhcp_request.bin";
    private static final String ACK = "dhcp_ack.bin";
    private static final String LONG_OPT = "dhcp_long_opt.bin";
    private static final String EMPTY = "";
    private static final byte HW_TYPE = 1;
    private static final byte HW_ADDR_LEN = 6;
    private static final byte HOPS = 1;
    private static final int XID = -1889920916;
    private static final short SECS = 0;
    private static final short FLAGS = 0;
    private static final int NO_IP = 0;
    private static final Ip4Address GW_IP = Ip4Address.valueOf((String)"10.0.4.254");
    private static final Ip4Address SERVER_IP = Ip4Address.valueOf((String)"10.0.99.3");
    private static final MacAddress CLIENT_HW_ADDR = MacAddress.valueOf((String)"00:aa:00:00:00:01");
    private static final Ip4Address CLIENT_IP = Ip4Address.valueOf((String)"10.0.4.1");
    private static final Ip4Address DNS_1 = Ip4Address.valueOf((String)"8.8.8.8");
    private static final Ip4Address DNS_2 = Ip4Address.valueOf((String)"8.8.4.4");
    private static final Ip4Address SUBNET_MASK = Ip4Address.valueOf((String)"255.255.255.0");
    private static final String HOSTNAME = "charlie-n";
    private static final String CIRCUIT_ID = "relay-eth0";
    private static final String DOMAIN_NAME = "trellis.local";

    @Test
    public void testDeserializeBadInput() throws Exception {
        PacketTestUtils.testDeserializeBadInput(DHCP.deserializer());
    }

    @Test
    public void testDeserializeTruncated() throws Exception {
        byte[] byteHeader = ByteBuffer.allocate(241).put((byte)1).put((byte)1).put((byte)6).put((byte)0).putInt(1000).putShort((short)0).putShort((short)0).putInt(0).putInt(0).putInt(0).putInt(0).put(MacAddress.valueOf((String)"1a:1a:1a:1a:1a:1a").toBytes()).put(new byte[10]).put(new byte[64]).put(new byte[128]).putInt(1669485411).put((byte)-1).array();
        PacketTestUtils.testDeserializeTruncated(DHCP.deserializer(), byteHeader);
    }

    @Test
    public void testDeserializeDiscover() throws Exception {
        byte[] data = Resources.toByteArray((URL)Dhcp6RelayTest.class.getResource(DISCOVER));
        Ethernet eth = (Ethernet)Ethernet.deserializer().deserialize(data, 0, data.length);
        DHCP dhcp = (DHCP)eth.getPayload().getPayload().getPayload();
        Assert.assertEquals((long)1L, (long)dhcp.getOpCode());
        Assert.assertEquals((long)1L, (long)dhcp.getHardwareType());
        Assert.assertEquals((long)6L, (long)dhcp.getHardwareAddressLength());
        Assert.assertEquals((long)1L, (long)dhcp.getHops());
        Assert.assertEquals((long)-1889920916L, (long)dhcp.getTransactionId());
        Assert.assertEquals((long)0L, (long)dhcp.getSeconds());
        Assert.assertEquals((long)0L, (long)dhcp.getFlags());
        Assert.assertEquals((long)0L, (long)dhcp.getClientIPAddress());
        Assert.assertEquals((long)0L, (long)dhcp.getYourIPAddress());
        Assert.assertEquals((long)0L, (long)dhcp.getServerIPAddress());
        Assert.assertEquals((long)GW_IP.toInt(), (long)dhcp.getGatewayIPAddress());
        Assert.assertTrue((boolean)Arrays.equals(CLIENT_HW_ADDR.toBytes(), dhcp.getClientHardwareAddress()));
        Assert.assertEquals((Object)EMPTY, (Object)dhcp.getServerName());
        Assert.assertEquals((Object)EMPTY, (Object)dhcp.getBootFileName());
        Assert.assertEquals((long)6L, (long)dhcp.getOptions().size());
        DhcpOption option = (DhcpOption)dhcp.getOptions().get(0);
        Assert.assertEquals((long)DHCP.DHCPOptionCode.OptionCode_MessageType.getValue(), (long)option.code);
        Assert.assertEquals((long)1L, (long)option.length);
        Assert.assertEquals((long)DHCP.MsgType.DHCPDISCOVER.getValue(), (long)option.getData()[0]);
        option = (DhcpOption)dhcp.getOptions().get(1);
        Assert.assertEquals((long)DHCP.DHCPOptionCode.OptionCode_RequestedIP.getValue(), (long)option.code);
        Assert.assertEquals((long)4L, (long)option.length);
        Assert.assertArrayEquals((byte[])CLIENT_IP.toOctets(), (byte[])option.getData());
        option = (DhcpOption)dhcp.getOptions().get(2);
        Assert.assertEquals((long)DHCP.DHCPOptionCode.OptionCode_HostName.getValue(), (long)option.code);
        Assert.assertEquals((long)9L, (long)option.length);
        Assert.assertArrayEquals((byte[])HOSTNAME.getBytes(Charsets.US_ASCII), (byte[])option.getData());
        option = (DhcpOption)dhcp.getOptions().get(3);
        Assert.assertEquals((long)DHCP.DHCPOptionCode.OptionCode_RequestedParameters.getValue(), (long)option.code);
        Assert.assertEquals((long)13L, (long)option.length);
        Assert.assertArrayEquals((byte[])new byte[]{1, 28, 2, 3, 15, 6, 119, 12, 44, 47, 26, 121, 42}, (byte[])option.getData());
        option = (DhcpOption)dhcp.getOptions().get(4);
        Assert.assertTrue((boolean)(option instanceof DhcpRelayAgentOption));
        DhcpRelayAgentOption relayAgentOption = (DhcpRelayAgentOption)option;
        Assert.assertEquals((long)DHCP.DHCPOptionCode.OptionCode_CircuitID.getValue(), (long)relayAgentOption.code);
        Assert.assertEquals((long)12L, (long)relayAgentOption.length);
        DhcpOption subOption = relayAgentOption.getSubOption(DhcpRelayAgentOption.RelayAgentInfoOptions.CIRCUIT_ID.getValue());
        Assert.assertEquals((long)10L, (long)subOption.getLength());
        Assert.assertArrayEquals((byte[])CIRCUIT_ID.getBytes(Charsets.US_ASCII), (byte[])subOption.getData());
        option = (DhcpOption)dhcp.getOptions().get(5);
        Assert.assertEquals((long)DHCP.DHCPOptionCode.OptionCode_END.getValue(), (long)option.code);
        Assert.assertEquals((long)0L, (long)option.length);
    }

    @Test
    public void testDeserializeOffer() throws Exception {
        byte[] data = Resources.toByteArray((URL)Dhcp6RelayTest.class.getResource(OFFER));
        Ethernet eth = (Ethernet)Ethernet.deserializer().deserialize(data, 0, data.length);
        DHCP dhcp = (DHCP)eth.getPayload().getPayload().getPayload();
        Assert.assertEquals((long)2L, (long)dhcp.getOpCode());
        Assert.assertEquals((long)1L, (long)dhcp.getHardwareType());
        Assert.assertEquals((long)6L, (long)dhcp.getHardwareAddressLength());
        Assert.assertEquals((long)1L, (long)dhcp.getHops());
        Assert.assertEquals((long)-1889920916L, (long)dhcp.getTransactionId());
        Assert.assertEquals((long)0L, (long)dhcp.getSeconds());
        Assert.assertEquals((long)0L, (long)dhcp.getFlags());
        Assert.assertEquals((long)0L, (long)dhcp.getClientIPAddress());
        Assert.assertEquals((long)CLIENT_IP.toInt(), (long)dhcp.getYourIPAddress());
        Assert.assertEquals((long)SERVER_IP.toInt(), (long)dhcp.getServerIPAddress());
        Assert.assertEquals((long)GW_IP.toInt(), (long)dhcp.getGatewayIPAddress());
        Assert.assertTrue((boolean)Arrays.equals(CLIENT_HW_ADDR.toBytes(), dhcp.getClientHardwareAddress()));
        Assert.assertEquals((Object)EMPTY, (Object)dhcp.getServerName());
        Assert.assertEquals((Object)EMPTY, (Object)dhcp.getBootFileName());
        Assert.assertEquals((long)9L, (long)dhcp.getOptions().size());
        DhcpOption option = (DhcpOption)dhcp.getOptions().get(0);
        Assert.assertEquals((long)DHCP.DHCPOptionCode.OptionCode_MessageType.getValue(), (long)option.code);
        Assert.assertEquals((long)1L, (long)option.length);
        Assert.assertEquals((long)DHCP.MsgType.DHCPOFFER.getValue(), (long)option.getData()[0]);
        option = (DhcpOption)dhcp.getOptions().get(1);
        Assert.assertEquals((long)DHCP.DHCPOptionCode.OptionCode_DHCPServerIp.getValue(), (long)option.code);
        Assert.assertEquals((long)4L, (long)option.length);
        Assert.assertArrayEquals((byte[])SERVER_IP.toOctets(), (byte[])option.getData());
        option = (DhcpOption)dhcp.getOptions().get(2);
        Assert.assertEquals((long)DHCP.DHCPOptionCode.OptionCode_LeaseTime.getValue(), (long)option.code);
        Assert.assertEquals((long)4L, (long)option.length);
        Assert.assertArrayEquals((byte[])new byte[]{0, 0, 2, 88}, (byte[])option.getData());
        option = (DhcpOption)dhcp.getOptions().get(3);
        Assert.assertEquals((long)DHCP.DHCPOptionCode.OptionCode_SubnetMask.getValue(), (long)option.code);
        Assert.assertEquals((long)4L, (long)option.length);
        Assert.assertArrayEquals((byte[])SUBNET_MASK.toOctets(), (byte[])option.getData());
        option = (DhcpOption)dhcp.getOptions().get(4);
        Assert.assertEquals((long)DHCP.DHCPOptionCode.OptionCode_RouterAddress.getValue(), (long)option.code);
        Assert.assertEquals((long)4L, (long)option.length);
        Assert.assertArrayEquals((byte[])GW_IP.toOctets(), (byte[])option.getData());
        option = (DhcpOption)dhcp.getOptions().get(5);
        Assert.assertEquals((long)DHCP.DHCPOptionCode.OptionCode_DomainName.getValue(), (long)option.code);
        Assert.assertEquals((long)13L, (long)option.length);
        Assert.assertArrayEquals((byte[])DOMAIN_NAME.getBytes(Charsets.US_ASCII), (byte[])option.getData());
        option = (DhcpOption)dhcp.getOptions().get(6);
        Assert.assertEquals((long)DHCP.DHCPOptionCode.OptionCode_DomainServer.getValue(), (long)option.code);
        Assert.assertEquals((long)8L, (long)option.length);
        Assert.assertArrayEquals((byte[])ArrayUtils.addAll((byte[])DNS_1.toOctets(), (byte[])DNS_2.toOctets()), (byte[])option.getData());
        option = (DhcpOption)dhcp.getOptions().get(7);
        Assert.assertTrue((boolean)(option instanceof DhcpRelayAgentOption));
        DhcpRelayAgentOption relayAgentOption = (DhcpRelayAgentOption)option;
        Assert.assertEquals((long)DHCP.DHCPOptionCode.OptionCode_CircuitID.getValue(), (long)relayAgentOption.code);
        Assert.assertEquals((long)12L, (long)relayAgentOption.length);
        DhcpOption subOption = relayAgentOption.getSubOption(DhcpRelayAgentOption.RelayAgentInfoOptions.CIRCUIT_ID.getValue());
        Assert.assertEquals((long)10L, (long)subOption.getLength());
        Assert.assertArrayEquals((byte[])CIRCUIT_ID.getBytes(Charsets.US_ASCII), (byte[])subOption.getData());
        option = (DhcpOption)dhcp.getOptions().get(8);
        Assert.assertEquals((long)DHCP.DHCPOptionCode.OptionCode_END.getValue(), (long)option.code);
        Assert.assertEquals((long)0L, (long)option.length);
    }

    @Test
    public void testDeserializeRequest() throws Exception {
        byte[] data = Resources.toByteArray((URL)Dhcp6RelayTest.class.getResource(REQUEST));
        Ethernet eth = (Ethernet)Ethernet.deserializer().deserialize(data, 0, data.length);
        DHCP dhcp = (DHCP)eth.getPayload().getPayload().getPayload();
        Assert.assertEquals((long)1L, (long)dhcp.getOpCode());
        Assert.assertEquals((long)1L, (long)dhcp.getHardwareType());
        Assert.assertEquals((long)6L, (long)dhcp.getHardwareAddressLength());
        Assert.assertEquals((long)1L, (long)dhcp.getHops());
        Assert.assertEquals((long)-1889920916L, (long)dhcp.getTransactionId());
        Assert.assertEquals((long)0L, (long)dhcp.getSeconds());
        Assert.assertEquals((long)0L, (long)dhcp.getFlags());
        Assert.assertEquals((long)0L, (long)dhcp.getClientIPAddress());
        Assert.assertEquals((long)0L, (long)dhcp.getYourIPAddress());
        Assert.assertEquals((long)0L, (long)dhcp.getServerIPAddress());
        Assert.assertEquals((long)GW_IP.toInt(), (long)dhcp.getGatewayIPAddress());
        Assert.assertTrue((boolean)Arrays.equals(CLIENT_HW_ADDR.toBytes(), dhcp.getClientHardwareAddress()));
        Assert.assertEquals((Object)EMPTY, (Object)dhcp.getServerName());
        Assert.assertEquals((Object)EMPTY, (Object)dhcp.getBootFileName());
        Assert.assertEquals((long)7L, (long)dhcp.getOptions().size());
        DhcpOption option = (DhcpOption)dhcp.getOptions().get(0);
        Assert.assertEquals((long)DHCP.DHCPOptionCode.OptionCode_MessageType.getValue(), (long)option.code);
        Assert.assertEquals((long)1L, (long)option.length);
        Assert.assertEquals((long)DHCP.MsgType.DHCPREQUEST.getValue(), (long)option.getData()[0]);
        option = (DhcpOption)dhcp.getOptions().get(1);
        Assert.assertEquals((long)DHCP.DHCPOptionCode.OptionCode_DHCPServerIp.getValue(), (long)option.code);
        Assert.assertEquals((long)4L, (long)option.length);
        Assert.assertArrayEquals((byte[])SERVER_IP.toOctets(), (byte[])option.getData());
        option = (DhcpOption)dhcp.getOptions().get(2);
        Assert.assertEquals((long)DHCP.DHCPOptionCode.OptionCode_RequestedIP.getValue(), (long)option.code);
        Assert.assertEquals((long)4L, (long)option.length);
        Assert.assertArrayEquals((byte[])CLIENT_IP.toOctets(), (byte[])option.getData());
        option = (DhcpOption)dhcp.getOptions().get(3);
        Assert.assertEquals((long)DHCP.DHCPOptionCode.OptionCode_HostName.getValue(), (long)option.code);
        Assert.assertEquals((long)9L, (long)option.length);
        Assert.assertArrayEquals((byte[])HOSTNAME.getBytes(Charsets.US_ASCII), (byte[])option.getData());
        option = (DhcpOption)dhcp.getOptions().get(4);
        Assert.assertEquals((long)DHCP.DHCPOptionCode.OptionCode_RequestedParameters.getValue(), (long)option.code);
        Assert.assertEquals((long)13L, (long)option.length);
        Assert.assertArrayEquals((byte[])new byte[]{1, 28, 2, 3, 15, 6, 119, 12, 44, 47, 26, 121, 42}, (byte[])option.getData());
        option = (DhcpOption)dhcp.getOptions().get(5);
        Assert.assertTrue((boolean)(option instanceof DhcpRelayAgentOption));
        DhcpRelayAgentOption relayAgentOption = (DhcpRelayAgentOption)option;
        Assert.assertEquals((long)DHCP.DHCPOptionCode.OptionCode_CircuitID.getValue(), (long)relayAgentOption.code);
        Assert.assertEquals((long)12L, (long)relayAgentOption.length);
        DhcpOption subOption = relayAgentOption.getSubOption(DhcpRelayAgentOption.RelayAgentInfoOptions.CIRCUIT_ID.getValue());
        Assert.assertEquals((long)10L, (long)subOption.getLength());
        Assert.assertArrayEquals((byte[])CIRCUIT_ID.getBytes(Charsets.US_ASCII), (byte[])subOption.getData());
        option = (DhcpOption)dhcp.getOptions().get(6);
        Assert.assertEquals((long)DHCP.DHCPOptionCode.OptionCode_END.getValue(), (long)option.code);
        Assert.assertEquals((long)0L, (long)option.length);
    }

    @Test
    public void testDeserializeAck() throws Exception {
        byte[] data = Resources.toByteArray((URL)Dhcp6RelayTest.class.getResource(ACK));
        Ethernet eth = (Ethernet)Ethernet.deserializer().deserialize(data, 0, data.length);
        DHCP dhcp = (DHCP)eth.getPayload().getPayload().getPayload();
        Assert.assertEquals((long)2L, (long)dhcp.getOpCode());
        Assert.assertEquals((long)1L, (long)dhcp.getHardwareType());
        Assert.assertEquals((long)6L, (long)dhcp.getHardwareAddressLength());
        Assert.assertEquals((long)1L, (long)dhcp.getHops());
        Assert.assertEquals((long)-1889920916L, (long)dhcp.getTransactionId());
        Assert.assertEquals((long)0L, (long)dhcp.getSeconds());
        Assert.assertEquals((long)0L, (long)dhcp.getFlags());
        Assert.assertEquals((long)0L, (long)dhcp.getClientIPAddress());
        Assert.assertEquals((long)CLIENT_IP.toInt(), (long)dhcp.getYourIPAddress());
        Assert.assertEquals((long)SERVER_IP.toInt(), (long)dhcp.getServerIPAddress());
        Assert.assertEquals((long)GW_IP.toInt(), (long)dhcp.getGatewayIPAddress());
        Assert.assertTrue((boolean)Arrays.equals(CLIENT_HW_ADDR.toBytes(), dhcp.getClientHardwareAddress()));
        Assert.assertEquals((Object)EMPTY, (Object)dhcp.getServerName());
        Assert.assertEquals((Object)EMPTY, (Object)dhcp.getBootFileName());
        Assert.assertEquals((long)9L, (long)dhcp.getOptions().size());
        DhcpOption option = (DhcpOption)dhcp.getOptions().get(0);
        Assert.assertEquals((long)DHCP.DHCPOptionCode.OptionCode_MessageType.getValue(), (long)option.code);
        Assert.assertEquals((long)1L, (long)option.length);
        Assert.assertEquals((long)DHCP.MsgType.DHCPACK.getValue(), (long)option.getData()[0]);
        option = (DhcpOption)dhcp.getOptions().get(1);
        Assert.assertEquals((long)DHCP.DHCPOptionCode.OptionCode_DHCPServerIp.getValue(), (long)option.code);
        Assert.assertEquals((long)4L, (long)option.length);
        Assert.assertArrayEquals((byte[])SERVER_IP.toOctets(), (byte[])option.getData());
        option = (DhcpOption)dhcp.getOptions().get(2);
        Assert.assertEquals((long)DHCP.DHCPOptionCode.OptionCode_LeaseTime.getValue(), (long)option.code);
        Assert.assertEquals((long)4L, (long)option.length);
        Assert.assertArrayEquals((byte[])new byte[]{0, 0, 2, 88}, (byte[])option.getData());
        option = (DhcpOption)dhcp.getOptions().get(3);
        Assert.assertEquals((long)DHCP.DHCPOptionCode.OptionCode_SubnetMask.getValue(), (long)option.code);
        Assert.assertEquals((long)4L, (long)option.length);
        Assert.assertArrayEquals((byte[])SUBNET_MASK.toOctets(), (byte[])option.getData());
        option = (DhcpOption)dhcp.getOptions().get(4);
        Assert.assertEquals((long)DHCP.DHCPOptionCode.OptionCode_RouterAddress.getValue(), (long)option.code);
        Assert.assertEquals((long)4L, (long)option.length);
        Assert.assertArrayEquals((byte[])GW_IP.toOctets(), (byte[])option.getData());
        option = (DhcpOption)dhcp.getOptions().get(5);
        Assert.assertEquals((long)DHCP.DHCPOptionCode.OptionCode_DomainName.getValue(), (long)option.code);
        Assert.assertEquals((long)13L, (long)option.length);
        Assert.assertArrayEquals((byte[])DOMAIN_NAME.getBytes(Charsets.US_ASCII), (byte[])option.getData());
        option = (DhcpOption)dhcp.getOptions().get(6);
        Assert.assertEquals((long)DHCP.DHCPOptionCode.OptionCode_DomainServer.getValue(), (long)option.code);
        Assert.assertEquals((long)8L, (long)option.length);
        Assert.assertArrayEquals((byte[])ArrayUtils.addAll((byte[])DNS_1.toOctets(), (byte[])DNS_2.toOctets()), (byte[])option.getData());
        option = (DhcpOption)dhcp.getOptions().get(7);
        Assert.assertTrue((boolean)(option instanceof DhcpRelayAgentOption));
        DhcpRelayAgentOption relayAgentOption = (DhcpRelayAgentOption)option;
        Assert.assertEquals((long)DHCP.DHCPOptionCode.OptionCode_CircuitID.getValue(), (long)relayAgentOption.code);
        Assert.assertEquals((long)12L, (long)relayAgentOption.length);
        DhcpOption subOption = relayAgentOption.getSubOption(DhcpRelayAgentOption.RelayAgentInfoOptions.CIRCUIT_ID.getValue());
        Assert.assertEquals((long)10L, (long)subOption.getLength());
        Assert.assertArrayEquals((byte[])CIRCUIT_ID.getBytes(Charsets.US_ASCII), (byte[])subOption.getData());
        option = (DhcpOption)dhcp.getOptions().get(8);
        Assert.assertEquals((long)DHCP.DHCPOptionCode.OptionCode_END.getValue(), (long)option.code);
        Assert.assertEquals((long)0L, (long)option.length);
    }

    @Test
    public void longOptionTest() throws Exception {
        byte[] data = Resources.toByteArray((URL)Dhcp6RelayTest.class.getResource(LONG_OPT));
        DHCP dhcp = (DHCP)DHCP.deserializer().deserialize(data, 0, data.length);
        Assert.assertEquals((long)2L, (long)dhcp.getOptions().size());
        DhcpOption hostnameOption = dhcp.getOption(DHCP.DHCPOptionCode.OptionCode_HostName);
        DhcpOption endOption = dhcp.getOption(DHCP.DHCPOptionCode.OptionCode_END);
        Assert.assertNotNull((Object)hostnameOption);
        Assert.assertNotNull((Object)endOption);
        StringBuilder hostnameBuilder = new StringBuilder();
        IntStream.range(0, 200).forEach(i -> hostnameBuilder.append("A"));
        String hostname = hostnameBuilder.toString();
        Assert.assertEquals((long)-56L, (long)hostnameOption.getLength());
        Assert.assertArrayEquals((byte[])hostname.getBytes(Charsets.US_ASCII), (byte[])hostnameOption.getData());
    }
}

