/*
 * Decompiled with CFR 0.152.
 */
package org.onlab.graph;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.onlab.graph.AbstractEdge;
import org.onlab.graph.AbstractGraphPathSearch;
import org.onlab.graph.DijkstraGraphSearch;
import org.onlab.graph.DisjointPathPair;
import org.onlab.graph.Edge;
import org.onlab.graph.EdgeWeigher;
import org.onlab.graph.Graph;
import org.onlab.graph.GraphPathSearch;
import org.onlab.graph.MutableAdjacencyListsGraph;
import org.onlab.graph.MutableGraph;
import org.onlab.graph.Path;
import org.onlab.graph.ScalarWeight;
import org.onlab.graph.Vertex;
import org.onlab.graph.Weight;

public class SuurballeGraphSearch<V extends Vertex, E extends Edge<V>>
extends DijkstraGraphSearch<V, E> {
    @Override
    protected GraphPathSearch.Result<V, E> internalSearch(Graph<V, E> graph, V src, V dst, EdgeWeigher<V, E> weigher, int maxPaths) {
        final EdgeWeigher<V, E> weightf = weigher;
        AbstractGraphPathSearch.DefaultResult firstDijkstraS = (AbstractGraphPathSearch.DefaultResult)super.internalSearch(graph, src, dst, weigher, -1);
        final AbstractGraphPathSearch.DefaultResult firstDijkstra = (AbstractGraphPathSearch.DefaultResult)super.internalSearch(graph, src, null, weigher, -1);
        Path shortPath = null;
        if (firstDijkstraS.paths().isEmpty()) {
            return firstDijkstraS;
        }
        DisjointPathResult result = new DisjointPathResult(this, firstDijkstra, (Vertex)src, (Vertex)dst, maxPaths);
        Iterator iterator = firstDijkstraS.paths().iterator();
        while (iterator.hasNext()) {
            Path p;
            shortPath = p = iterator.next();
            EdgeWeigher modified = new EdgeWeigher<V, E>(){

                @Override
                public Weight weight(E edge) {
                    return edge instanceof ReverseEdge ? weightf.getInitialWeight() : (weightf.weight(edge).isNegative() ? new ScalarWeight(-1.0) : weightf.weight(edge).merge(firstDijkstra.cost(edge.src())).subtract(firstDijkstra.cost(edge.dst())));
                }

                @Override
                public Weight getInitialWeight() {
                    return weightf.getInitialWeight();
                }

                @Override
                public Weight getNonViableWeight() {
                    return weightf.getNonViableWeight();
                }
            };
            EdgeWeigher modified2 = new EdgeWeigher<V, E>(){

                @Override
                public Weight weight(E edge) {
                    return weightf.weight(edge).merge(firstDijkstra.cost(edge.src())).subtract(firstDijkstra.cost(edge.dst()));
                }

                @Override
                public Weight getInitialWeight() {
                    return weightf.getInitialWeight();
                }

                @Override
                public Weight getNonViableWeight() {
                    return weightf.getNonViableWeight();
                }
            };
            MutableGraph<V, Edge> gt = this.mutableCopy(graph);
            HashMap revToEdge = new HashMap();
            graph.getEdgesTo(src).forEach(gt::removeEdge);
            for (Edge edge : shortPath.edges()) {
                gt.removeEdge(edge);
                ReverseEdge reverse = new ReverseEdge(edge);
                revToEdge.put(reverse, edge);
                gt.addEdge(reverse);
            }
            GraphPathSearch.Result<V, E> secondDijkstra = new DijkstraGraphSearch<V, Edge>().search(gt, src, dst, modified, -1);
            Path<V, E> residualShortPath = null;
            if (secondDijkstra.paths().isEmpty()) {
                result.dpps.add(new DisjointPathPair(shortPath, null));
                continue;
            }
            Iterator<Path<V, E>> iterator2 = secondDijkstra.paths().iterator();
            block2: while (iterator2.hasNext()) {
                Path<V, E> p2;
                residualShortPath = p2 = iterator2.next();
                MutableGraph<V, Edge> roundTrip = this.mutableCopy(graph);
                List<Edge> tmp = roundTrip.getEdges().stream().collect(Collectors.toList());
                tmp.forEach(roundTrip::removeEdge);
                shortPath.edges().forEach(roundTrip::addEdge);
                if (residualShortPath != null) {
                    for (Edge edge : residualShortPath.edges()) {
                        if (edge instanceof ReverseEdge) {
                            roundTrip.removeEdge((Edge)revToEdge.get(edge));
                            continue;
                        }
                        roundTrip.addEdge(edge);
                    }
                }
                AbstractGraphPathSearch.DefaultResult lastSearch = (AbstractGraphPathSearch.DefaultResult)super.internalSearch(roundTrip, src, dst, weigher, -1);
                Path primary = lastSearch.paths().iterator().next();
                primary.edges().forEach(roundTrip::removeEdge);
                Set<Path<V, E>> backups = super.internalSearch(roundTrip, src, dst, weigher, -1).paths();
                for (Path<V, E> backup : backups) {
                    if (!this.isDisjoint(primary, backup)) continue;
                    result.dpps.add(new DisjointPathPair(primary, backup));
                    continue block2;
                }
            }
        }
        for (int i = result.dpps.size() - 1; i > 0; --i) {
            if (((DisjointPathPair)result.dpps.get(i)).size() > 1) continue;
            result.dpps.remove(i);
        }
        result.buildPaths();
        return result;
    }

    private boolean isDisjoint(Path<V, E> a, Path<V, E> b) {
        return Sets.intersection(this.vertices(a), this.vertices(b)).isEmpty();
    }

    private Set<V> vertices(Path<V, E> p) {
        HashSet set = new HashSet();
        p.edges().forEach(e -> set.add(e.src()));
        set.remove(p.src());
        return set;
    }

    private MutableGraph<V, E> mutableCopy(Graph<V, E> graph) {
        return new MutableAdjacencyListsGraph<V, E>(graph.getVertexes(), graph.getEdges());
    }

    private final class DisjointPathResult
    implements GraphPathSearch.Result<V, E> {
        private final GraphPathSearch.Result<V, E> searchResult;
        private final V src;
        private final V dst;
        private final int maxPaths;
        private final List<DisjointPathPair<V, E>> dpps = new ArrayList();
        private final Set<Path<V, E>> disjointPaths = new HashSet();
        final /* synthetic */ SuurballeGraphSearch this$0;

        /*
         * WARNING - Possible parameter corruption
         */
        private DisjointPathResult(GraphPathSearch.Result<V, E> searchResult, V src, V dst, int maxPaths) {
            this.this$0 = (SuurballeGraphSearch)n;
            this.searchResult = searchResult;
            this.src = src;
            this.dst = dst;
            this.maxPaths = maxPaths;
        }

        @Override
        public V src() {
            return this.src;
        }

        @Override
        public V dst() {
            return this.dst;
        }

        @Override
        public Set<Path<V, E>> paths() {
            return this.disjointPaths;
        }

        private void buildPaths() {
            int paths = 0;
            for (DisjointPathPair path : this.dpps) {
                this.disjointPaths.add(path);
                if (++paths != this.maxPaths) continue;
                break;
            }
        }

        @Override
        public Map<V, Set<E>> parents() {
            return this.searchResult.parents();
        }

        @Override
        public Map<V, Weight> costs() {
            return this.searchResult.costs();
        }
    }

    private static final class ReverseEdge<V extends Vertex>
    extends AbstractEdge<V> {
        private ReverseEdge(Edge<V> edge) {
            super(edge.dst(), edge.src());
        }

        @Override
        public String toString() {
            return "ReversedEdge src=" + this.src() + " dst=" + this.dst();
        }
    }
}

