/*
 * Decompiled with CFR 0.152.
 */
package org.onlab.packet;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.nio.ByteBuffer;
import java.util.Map;
import org.onlab.packet.BasePacket;
import org.onlab.packet.Data;
import org.onlab.packet.Deserializer;
import org.onlab.packet.IPacket;
import org.onlab.packet.IpAddress;
import org.onlab.packet.PacketUtils;
import org.onlab.packet.pim.PIMHello;
import org.onlab.packet.pim.PIMJoinPrune;

public class PIM
extends BasePacket {
    public static final IpAddress PIM_ADDRESS = IpAddress.valueOf("224.0.0.13");
    public static final byte TYPE_HELLO = 0;
    public static final byte TYPE_REGISTER = 1;
    public static final byte TYPE_REGISTER_STOP = 2;
    public static final byte TYPE_JOIN_PRUNE_REQUEST = 3;
    public static final byte TYPE_BOOTSTRAP = 4;
    public static final byte TYPE_ASSERT = 5;
    public static final byte TYPE_GRAFT = 6;
    public static final byte TYPE_GRAFT_ACK = 7;
    public static final byte TYPE_CANDIDATE_RP_ADV = 8;
    public static final int PIM_HEADER_LEN = 4;
    public static final byte ADDRESS_FAMILY_IP4 = 1;
    public static final byte ADDRESS_FAMILY_IP6 = 2;
    public static final Map<Byte, Deserializer<? extends IPacket>> PROTOCOL_DESERIALIZER_MAP = ImmutableMap.builder().put((Object)0, PIMHello.deserializer()).put((Object)3, PIMJoinPrune.deserializer()).build();
    protected byte version = (byte)2;
    protected byte type;
    protected byte reserved = 0;
    protected short checksum;

    public byte getPimMsgType() {
        return this.type;
    }

    public PIM setPIMType(byte type) {
        this.type = type;
        return this;
    }

    public byte getVersion() {
        return this.version;
    }

    public void setVersion(byte version) {
        this.version = version;
    }

    public byte getReserved() {
        return this.reserved;
    }

    public void setReserved(byte reserved) {
        this.reserved = reserved;
    }

    public short getChecksum() {
        return this.checksum;
    }

    public void setChecksum(short checksum) {
        this.checksum = checksum;
    }

    @Override
    public int hashCode() {
        int prime = 5807;
        int result = super.hashCode();
        result = 5807 * result + this.type;
        result = 5807 * result + this.version;
        result = 5807 * result + this.checksum;
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof PIM)) {
            return false;
        }
        PIM other = (PIM)obj;
        if (this.type != other.type) {
            return false;
        }
        if (this.version != other.version) {
            return false;
        }
        return this.checksum == other.checksum;
    }

    @Override
    public byte[] serialize() {
        int length = 4;
        byte[] payloadData = null;
        if (this.payload != null) {
            this.payload.setParent(this);
            payloadData = this.payload.serialize();
            length += payloadData.length;
        }
        byte[] data = new byte[length];
        ByteBuffer bb = ByteBuffer.wrap(data);
        bb.put((byte)((this.version & 0xF) << 4 | this.type & 0xF));
        bb.put(this.reserved);
        bb.putShort(this.checksum);
        if (payloadData != null) {
            bb.put(payloadData);
        }
        if (this.parent != null && this.parent instanceof PIM) {
            ((PIM)this.parent).setPIMType((byte)3);
        }
        if (this.checksum == 0) {
            bb.rewind();
            int accumulation = 0;
            for (int i = 0; i < length / 2; ++i) {
                accumulation += 0xFFFF & bb.getShort();
            }
            if (length % 2 > 0) {
                accumulation += (bb.get() & 0xFF) << 8;
            }
            accumulation = (accumulation >> 16 & 0xFFFF) + (accumulation & 0xFFFF);
            this.checksum = (short)(~accumulation & 0xFFFF);
            bb.putShort(2, this.checksum);
        }
        return data;
    }

    public static Deserializer<PIM> deserializer() {
        return (data, offset, length) -> {
            PacketUtils.checkInput(data, offset, length, 4);
            PIM pim = new PIM();
            ByteBuffer bb = ByteBuffer.wrap(data, offset, length);
            byte versionByte = bb.get();
            pim.version = (byte)(versionByte >> 4 & 0xF);
            pim.setPIMType((byte)(versionByte & 0xF));
            pim.reserved = bb.get();
            pim.checksum = bb.getShort();
            Deserializer<IPacket> deserializer = PROTOCOL_DESERIALIZER_MAP.containsKey(pim.getPimMsgType()) ? PROTOCOL_DESERIALIZER_MAP.get(pim.getPimMsgType()) : Data.deserializer();
            pim.payload = deserializer.deserialize(data, bb.position(), bb.limit() - bb.position());
            pim.payload.setParent(pim);
            return pim;
        };
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("version", (Object)Byte.toString(this.version)).add("type", (Object)Byte.toString(this.type)).add("reserved", (Object)Byte.toString(this.reserved)).add("checksum", (Object)Short.toString(this.reserved)).toString();
    }
}

