/*
 * Decompiled with CFR 0.152.
 */
package org.onlab.packet.ndp;

import com.google.common.base.MoreObjects;
import java.nio.ByteBuffer;
import java.util.List;
import org.onlab.packet.BasePacket;
import org.onlab.packet.Deserializer;
import org.onlab.packet.PacketUtils;
import org.onlab.packet.ndp.NeighborDiscoveryOptions;

public class RouterAdvertisement
extends BasePacket {
    public static final byte HEADER_LENGTH = 12;
    protected byte currentHopLimit;
    protected byte mFlag;
    protected byte oFlag;
    protected short routerLifetime;
    protected int reachableTime;
    protected int retransmitTimer;
    private final NeighborDiscoveryOptions options = new NeighborDiscoveryOptions();

    public byte getCurrentHopLimit() {
        return this.currentHopLimit;
    }

    public RouterAdvertisement setCurrentHopLimit(byte currentHopLimit) {
        this.currentHopLimit = currentHopLimit;
        return this;
    }

    public byte getMFlag() {
        return this.mFlag;
    }

    public RouterAdvertisement setMFlag(byte mFlag) {
        this.mFlag = mFlag;
        return this;
    }

    public byte getOFlag() {
        return this.oFlag;
    }

    public RouterAdvertisement setOFlag(byte oFlag) {
        this.oFlag = oFlag;
        return this;
    }

    public short getRouterLifetime() {
        return this.routerLifetime;
    }

    public RouterAdvertisement setRouterLifetime(short routerLifetime) {
        this.routerLifetime = routerLifetime;
        return this;
    }

    public int getReachableTime() {
        return this.reachableTime;
    }

    public RouterAdvertisement setReachableTime(int reachableTime) {
        this.reachableTime = reachableTime;
        return this;
    }

    public int getRetransmitTimer() {
        return this.retransmitTimer;
    }

    public RouterAdvertisement setRetransmitTimer(int retransmitTimer) {
        this.retransmitTimer = retransmitTimer;
        return this;
    }

    public List<NeighborDiscoveryOptions.Option> getOptions() {
        return this.options.options();
    }

    public RouterAdvertisement addOption(byte type, byte[] data) {
        this.options.addOption(type, data);
        return this;
    }

    @Override
    public byte[] serialize() {
        byte[] optionsData = null;
        if (this.options.hasOptions()) {
            optionsData = this.options.serialize();
        }
        int optionsLength = 0;
        if (optionsData != null) {
            optionsLength = optionsData.length;
        }
        byte[] data = new byte[12 + optionsLength];
        ByteBuffer bb = ByteBuffer.wrap(data);
        bb.put(this.currentHopLimit);
        bb.put((byte)((this.mFlag & 1) << 7 | (this.oFlag & 1) << 6));
        bb.putShort(this.routerLifetime);
        bb.putInt(this.reachableTime);
        bb.putInt(this.retransmitTimer);
        if (optionsData != null) {
            bb.put(optionsData);
        }
        return data;
    }

    @Override
    public int hashCode() {
        int prime = 5807;
        int result = super.hashCode();
        result = 5807 * result + this.currentHopLimit;
        result = 5807 * result + this.mFlag;
        result = 5807 * result + this.oFlag;
        result = 5807 * result + this.routerLifetime;
        result = 5807 * result + this.reachableTime;
        result = 5807 * result + this.retransmitTimer;
        result = 5807 * result + this.options.hashCode();
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof RouterAdvertisement)) {
            return false;
        }
        RouterAdvertisement other = (RouterAdvertisement)obj;
        if (this.currentHopLimit != other.currentHopLimit) {
            return false;
        }
        if (this.mFlag != other.mFlag) {
            return false;
        }
        if (this.oFlag != other.oFlag) {
            return false;
        }
        if (this.routerLifetime != other.routerLifetime) {
            return false;
        }
        if (this.reachableTime != other.reachableTime) {
            return false;
        }
        if (this.retransmitTimer != other.retransmitTimer) {
            return false;
        }
        return this.options.equals(other.options);
    }

    public static Deserializer<RouterAdvertisement> deserializer() {
        return (data, offset, length) -> {
            PacketUtils.checkInput(data, offset, length, 12);
            RouterAdvertisement routerAdvertisement = new RouterAdvertisement();
            ByteBuffer bb = ByteBuffer.wrap(data, offset, length);
            routerAdvertisement.currentHopLimit = bb.get();
            byte bscratch = bb.get();
            routerAdvertisement.mFlag = (byte)(bscratch >> 7 & 1);
            routerAdvertisement.oFlag = (byte)(bscratch >> 6 & 1);
            routerAdvertisement.routerLifetime = bb.getShort();
            routerAdvertisement.reachableTime = bb.getInt();
            routerAdvertisement.retransmitTimer = bb.getInt();
            if (bb.limit() - bb.position() > 0) {
                NeighborDiscoveryOptions options = NeighborDiscoveryOptions.deserializer().deserialize(data, bb.position(), bb.limit() - bb.position());
                for (NeighborDiscoveryOptions.Option option : options.options()) {
                    routerAdvertisement.addOption(option.type(), option.data());
                }
            }
            return routerAdvertisement;
        };
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("currentHopLimit", (Object)Byte.toString(this.currentHopLimit)).add("mFlag", (Object)Byte.toString(this.mFlag)).add("oFlag", (Object)Byte.toString(this.oFlag)).add("routerLifetime", (Object)Short.toString(this.routerLifetime)).add("reachableTime", (Object)Integer.toString(this.reachableTime)).add("retransmitTimer", (Object)Integer.toString(this.retransmitTimer)).toString();
    }
}

