/*
 * Decompiled with CFR 0.152.
 */
package org.onlab.packet;

import com.google.common.testing.EqualsTester;
import org.junit.Assert;
import org.junit.Test;
import org.onlab.packet.VlanId;

public class VlanIdTest {
    @Test
    public void testEquality() {
        VlanId vlan1 = VlanId.vlanId((String)"None");
        VlanId vlan2 = VlanId.vlanId((short)-1);
        VlanId vlan3 = VlanId.vlanId((short)100);
        VlanId vlan4 = VlanId.vlanId((short)100);
        new EqualsTester().addEqualityGroup(new Object[]{VlanId.vlanId(), vlan1}).addEqualityGroup(new Object[]{vlan1, vlan2}).addEqualityGroup(new Object[]{vlan3, vlan4}).addEqualityGroup(new Object[]{VlanId.vlanId((short)10)});
    }

    @Test
    public void basics() {
        VlanId vlan1 = VlanId.vlanId((short)10);
        VlanId vlan2 = VlanId.vlanId((short)-1);
        VlanId vlan3 = VlanId.vlanId((String)"None");
        Assert.assertEquals((String)"incorrect VLAN value", (long)10L, (long)vlan1.toShort());
        Assert.assertEquals((String)"invalid untagged value", (float)-1.0f, (float)vlan2.toShort(), (float)vlan3.toShort());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testIllicitVlan() {
        VlanId.vlanId((short)5000);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testIllicitVlanString() {
        VlanId.vlanId((String)"5000");
    }
}

