/*
 * Decompiled with CFR 0.152.
 */
package org.onlab.packet;

import junit.framework.Assert;
import org.junit.Before;
import org.junit.Test;
import org.onlab.packet.Deserializer;
import org.onlab.packet.IGMP;
import org.onlab.packet.IGMPGroup;
import org.onlab.packet.IGMPMembership;
import org.onlab.packet.IGMPQuery;
import org.onlab.packet.Ip4Address;
import org.onlab.packet.IpAddress;
import org.onlab.packet.PacketTestUtils;

public class IGMPTest {
    private Deserializer<IGMP> deserializer;
    private IGMP igmpQuery;
    private IGMP igmpMembership;
    private Ip4Address gaddr1;
    private Ip4Address gaddr2;
    private Ip4Address saddr1;
    private Ip4Address saddr2;

    @Before
    public void setUp() throws Exception {
        this.gaddr1 = Ip4Address.valueOf((int)-520027903);
        this.gaddr2 = Ip4Address.valueOf((int)-503184894);
        this.saddr1 = Ip4Address.valueOf((int)0xA010101);
        this.saddr2 = Ip4Address.valueOf((int)0xB020202);
        this.deserializer = IGMP.deserializer();
        this.igmpQuery = new IGMP.IGMPv3();
        this.igmpQuery.setIgmpType((byte)17);
        this.igmpQuery.setMaxRespCode((byte)127);
        IGMPQuery q = new IGMPQuery((IpAddress)this.gaddr1, 127);
        q.addSource((IpAddress)this.saddr1);
        q.addSource((IpAddress)this.saddr2);
        q.setSbit(false);
        this.igmpQuery.groups.add(q);
        this.igmpMembership = new IGMP.IGMPv3();
        this.igmpMembership.setIgmpType((byte)34);
        IGMPMembership g1 = new IGMPMembership(this.gaddr1);
        g1.addSource((IpAddress)this.saddr1);
        g1.addSource((IpAddress)this.saddr2);
        this.igmpMembership.groups.add(g1);
        IGMPMembership g2 = new IGMPMembership(this.gaddr2);
        g2.addSource((IpAddress)this.saddr1);
        g2.addSource((IpAddress)this.saddr2);
        this.igmpMembership.groups.add(g2);
    }

    @Test
    public void testDeserializeBadInput() throws Exception {
        PacketTestUtils.testDeserializeBadInput(this.deserializer);
    }

    @Test
    public void testDeserializeTruncated() throws Exception {
        byte[] bits = this.igmpQuery.serialize();
        PacketTestUtils.testDeserializeTruncated(this.deserializer, bits);
        bits = this.igmpMembership.serialize();
        PacketTestUtils.testDeserializeTruncated(this.deserializer, bits);
    }

    @Test
    public void testDeserializeQuery() throws Exception {
        byte[] data = this.igmpQuery.serialize();
        IGMP igmp = (IGMP)this.deserializer.deserialize(data, 0, data.length);
        Assert.assertTrue((boolean)igmp.equals((Object)this.igmpQuery));
    }

    @Test
    public void testDeserializeMembership() throws Exception {
        byte[] data = this.igmpMembership.serialize();
        IGMP igmp = (IGMP)this.deserializer.deserialize(data, 0, data.length);
        Assert.assertTrue((boolean)igmp.equals((Object)this.igmpMembership));
    }

    @Test
    public void testIGMPv2() throws Exception {
        IGMP.IGMPv2 igmp = new IGMP.IGMPv2();
        igmp.setIgmpType((byte)17);
        igmp.setMaxRespCode((byte)100);
        igmp.addGroup((IGMPGroup)new IGMPQuery(IpAddress.valueOf((int)0), 0));
        byte[] data = igmp.serialize();
        Assert.assertEquals((String)"Packet length is not 8 bytes", (int)data.length, (int)8);
        IGMP deserialized = (IGMP)this.deserializer.deserialize(data, 0, data.length);
        Assert.assertTrue((boolean)igmp.equals((Object)deserialized));
    }

    @Test
    public void testToStringIgmp() throws Exception {
    }
}

